/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace((RunLineMarkerContributor.Info)a)) {
            return 1;
        }
        if (a.shouldReplace((RunLineMarkerContributor.Info)b)) {
            return -1;
        }
        return 0;
    };
    private static final Key<Boolean> HAS_ANYTHING_RUNNABLE = Key.create((String)"HAS_ANYTHING_RUNNABLE");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        InjectedLanguageManager injectedLanguageManager;
        if (element2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element2.getProject())).isInjectedFragment(element2.getContainingFile())) {
            return null;
        }
        List contributors = RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(element2.getLanguage());
        Icon icon2 = null;
        List infos = null;
        for (RunLineMarkerContributor contributor : contributors) {
            RunLineMarkerContributor.Info info2 = contributor.getInfo(element2);
            if (info2 == null) continue;
            if (icon2 == null) {
                icon2 = info2.icon;
            }
            if (infos == null) {
                infos = new SmartList();
            }
            infos.add(info2);
        }
        if (icon2 == null) {
            return null;
        }
        return RunLineMarkerProvider.createLineMarker(element2, icon2, infos);
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            List contributors = RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(psiElement.getLanguage());
            Icon icon2 = null;
            List infos = null;
            for (RunLineMarkerContributor contributor : contributors) {
                RunLineMarkerContributor.Info info2 = contributor.getSlowInfo(psiElement);
                if (info2 == null) continue;
                if (icon2 == null) {
                    icon2 = info2.icon;
                }
                if (infos == null) {
                    infos = new SmartList();
                }
                infos.add(info2);
            }
            if (icon2 == null) continue;
            result2.add(RunLineMarkerProvider.createLineMarker(psiElement, icon2, infos));
        }
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement element2, @NotNull Icon icon2, @NotNull List<RunLineMarkerContributor.Info> infos) {
        if (element2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (icon2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (infos == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (infos.size() > 1) {
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = infos.get(0);
            infos.removeIf(info2 -> info2 != first && first.shouldReplace((RunLineMarkerContributor.Info)info2));
        }
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info3 : infos) {
            for (AnAction action2 : info3.actions) {
                actionGroup2.add((AnAction)(action2 instanceof Separator ? action2 : new LineMarkerActionWrapper(element2, action2)));
            }
            if (info3 == infos.get(infos.size() - 1)) continue;
            actionGroup2.add((AnAction)new Separator());
        }
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip2 = new StringBuilder();
            for (RunLineMarkerContributor.Info info2 : infos) {
                String string;
                if (info2.tooltipProvider == null || (string = info2.tooltipProvider.apply((PsiElement)element1)) == null) continue;
                if (tooltip2.length() != 0) {
                    tooltip2.append("\n");
                }
                tooltip2.append(string);
            }
            return tooltip2.length() == 0 ? null : RunLineMarkerProvider.appendShortcut(tooltip2.toString());
        };
        return new RunLineMarkerInfo(element2, icon2, (Function<? super PsiElement, String>)tooltipProvider, actionGroup2);
    }

    private static String appendShortcut(String tooltip2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return tooltip2;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        if (executor != null) {
            String actionId = executor.getContextActionId();
            String shortcutText = KeymapUtil.getShortcutText((String)actionId);
            @NotNull String shortcutColor = ColorUtil.toHex((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground());
            return XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)tooltip2).replaceAll("\n", "<br>") + "&nbsp;&nbsp;<font color='#" + shortcutColor + "'>" + XmlStringUtil.escapeString((String)shortcutText) + "</font>"));
        }
        return tooltip2;
    }

    @NotNull
    public String getName() {
        String string = ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
        if (string == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    @NotNull
    public static ThreeState hadAnythingRunnable(@NotNull VirtualFile file2) {
        Boolean data2;
        if (file2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(7);
        }
        ThreeState threeState = (data2 = (Boolean)file2.getUserData(HAS_ANYTHING_RUNNABLE)) == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)data2);
        if (threeState == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    public static void markRunnable(@NotNull VirtualFile file2, boolean isRunnable) {
        if (file2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(9);
        }
        file2.putUserData(HAS_ANYTHING_RUNNABLE, (Object)isRunnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "hadAnythingRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hadAnythingRunnable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "markRunnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RunLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;
        private final AnAction mySingleAction;

        RunLineMarkerInfo(PsiElement element2, Icon icon2, Function<? super PsiElement, @Nls String> tooltipProvider, DefaultActionGroup actionGroup2) {
            super(element2, element2.getTextRange(), icon2, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER, () -> (String)tooltipProvider.fun((Object)element2));
            this.myActionGroup = actionGroup2;
            this.mySingleAction = this.myActionGroup.getChildrenCount() == 1 ? this.myActionGroup.getChildActionsOrStubs()[0] : null;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return mySingleAction;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
            if (markupEditorFilter == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(0);
            }
            return markupEditorFilter;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info2) {
            if (info2 == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(1);
            }
            return info2 instanceof RunLineMarkerInfo && info2.getIcon() == this.getIcon();
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider$RunLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

