/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runToolbar.ExecutorRunToolbarAction;
import com.intellij.execution.runToolbar.RTBarAction;
import com.intellij.execution.runToolbar.RunToolbarData;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarMainSlotState;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarProcessAction;", "Lcom/intellij/execution/ExecutorRegistryImpl$ExecutorAction;", "Lcom/intellij/execution/runToolbar/ExecutorRunToolbarAction;", "Lcom/intellij/openapi/project/DumbAware;", "process", "Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/runToolbar/RunToolbarProcess;Lcom/intellij/execution/Executor;)V", "getExecutor", "()Lcom/intellij/execution/Executor;", "getProcess", "()Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canRun", "", "checkMainSlotVisibility", "state", "Lcom/intellij/execution/runToolbar/RunToolbarMainSlotState;", "displayTextInToolbar", "getInformativeIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "selectedConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getSelectedConfiguration", "update", "intellij.platform.execution.impl"})
public class RunToolbarProcessAction
extends ExecutorRegistryImpl.ExecutorAction
implements ExecutorRunToolbarAction,
DumbAware {
    @NotNull
    private final RunToolbarProcess process;
    @NotNull
    private final Executor executor;

    public boolean displayTextInToolbar() {
        return true;
    }

    @Override
    @NotNull
    protected Icon getInformativeIcon(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)selectedConfiguration2, (String)"selectedConfiguration");
        Icon icon2 = this.executor.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"executor.icon");
        return icon2;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) break block3;
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project project3 = project2;
            boolean bl3 = false;
            if (this.canRun(e)) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getSelectedConfiguration(e);
                if (runnerAndConfigurationSettings != null) {
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    RunnerAndConfigurationSettings it = runnerAndConfigurationSettings2;
                    boolean bl6 = false;
                    RunToolbarData runToolbarData = RunToolbarDataKt.runToolbarData(e);
                    if (runToolbarData != null) {
                        Project project4 = project3;
                        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                        String string = this.executor.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executor.id");
                        RunToolbarDataKt.startWaitingForAProcess(runToolbarData, project4, it, string);
                    }
                    ExecutorRegistryImpl.RunnerHelper.run(project3, it.getConfiguration(), it, e.getDataContext(), this.executor);
                }
            }
        }
    }

    @Override
    public boolean checkMainSlotVisibility(@NotNull RunToolbarMainSlotState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return state == RunToolbarMainSlotState.CONFIGURATION;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setText(this.executor.getActionName());
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
        presentation3.setVisible(!RunToolbarDataKt.isActiveProcess(e));
        if (!RunToolbarProcess.Companion.isExperimentalUpdatingEnabled()) {
            RunToolbarMainSlotState runToolbarMainSlotState = RunToolbarDataKt.mainState(e);
            if (runToolbarMainSlotState != null) {
                RunToolbarMainSlotState runToolbarMainSlotState2 = runToolbarMainSlotState;
                boolean bl = false;
                boolean bl2 = false;
                RunToolbarMainSlotState it = runToolbarMainSlotState2;
                boolean bl3 = false;
                Presentation presentation4 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
                Presentation presentation5 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
                presentation4.setVisible(presentation5.isVisible() && this.checkMainSlotVisibility(it));
            }
        }
        Presentation presentation6 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
        if (presentation6.isVisible()) {
            Presentation presentation7 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation7, (String)"e.presentation");
            presentation7.setEnabled(this.canRun(e));
        }
    }

    @Override
    @Nullable
    protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return RunToolbarDataKt.configuration(e);
    }

    protected final boolean canRun(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project != null) {
            boolean bl;
            Project project2 = project;
            boolean bl2 = false;
            boolean bl3 = false;
            Project project3 = project2;
            boolean bl4 = false;
            ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)project3);
            Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"ExecutionTargetManager.getActiveTarget(project)");
            ExecutionTarget activeTarget = executionTarget;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getSelectedConfiguration(e);
            if (runnerAndConfigurationSettings != null) {
                boolean canRun;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
                boolean bl5 = false;
                boolean bl6 = false;
                RunnerAndConfigurationSettings it = runnerAndConfigurationSettings2;
                boolean bl7 = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"it.configuration");
                SettingsAndEffectiveTarget target2 = new SettingsAndEffectiveTarget(runConfiguration, activeTarget);
                bl = canRun = ExecutorRegistryImpl.RunnerHelper.canRun(project3, CollectionsKt.listOf((Object)target2), this.executor);
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @Override
    @NotNull
    public RunToolbarProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    public RunToolbarProcessAction(@NotNull RunToolbarProcess process2, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(executor);
        this.process = process2;
        this.executor = executor;
    }

    @Override
    @NotNull
    public RTBarAction.Type getRightSideType() {
        return ExecutorRunToolbarAction.DefaultImpls.getRightSideType(this);
    }

    @Override
    public void traceLog(@NotNull Logger logger, @NotNull AnActionEvent e, @Nullable String additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ExecutorRunToolbarAction.DefaultImpls.traceLog(this, logger, e, additionalInfo);
    }
}

