/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarSpacer;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewActionProvider {
    @NonNls
    private static final String SERVICE_VIEW_ITEM_TOOLBAR = "ServiceViewItemToolbar";
    @NonNls
    static final String SERVICE_VIEW_ITEM_POPUP = "ServiceViewItemPopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    private static final ServiceViewActionProvider ourInstance = new ServiceViewActionProvider();

    ServiceViewActionProvider() {
    }

    static ServiceViewActionProvider getInstance() {
        return ourInstance;
    }

    ActionToolbar createServiceToolbar(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(0);
        }
        ActionGroup actions2 = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions2, false);
        toolbar.setTargetComponent(component2);
        return toolbar;
    }

    JComponent wrapServiceToolbar(@NotNull ActionToolbar toolbar) {
        if (toolbar == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(1);
        }
        final JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)toolbar.getComponent(), "Center");
        toolbar.getComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                wrapper2.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                wrapper2.setVisible(false);
            }
        });
        wrapper2.add((Component)new ActionToolbarSpacer(false), "South");
        return wrapper2;
    }

    void installPopupHandler(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(2);
        }
        PopupHandler.installPopupMenu((JComponent)component2, (String)SERVICE_VIEW_ITEM_POPUP, (String)"ServicesPopup");
    }

    ActionToolbar createMasterComponentToolbar(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (component2 instanceof JTree) {
            ServiceViewTreeExpander treeExpander = new ServiceViewTreeExpander((JTree)component2);
            AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, component2);
            group2.add(expandAllAction);
            AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, component2);
            group2.add(collapseAllAction);
            group2.addSeparator();
        }
        group2.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet(component2, null);
        group2.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", (ActionGroup)group2, true);
        treeActionsToolBar.setTargetComponent(component2);
        return treeActionsToolBar;
    }

    List<AnAction> getAdditionalGearActions() {
        AnAction showServicesActions = ActionManager.getInstance().getAction("ServiceView.ShowServices");
        return showServicesActions == null ? Collections.emptyList() : Collections.singletonList(showServicesActions);
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull AnActionEvent e) {
        if (e == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(4);
        }
        return ServiceViewActionProvider.getSelectedView((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull DataProvider provider2) {
        if (provider2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(5);
        }
        return ServiceViewActionProvider.getSelectedView((Component)ObjectUtils.tryCast((Object)provider2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()), Component.class));
    }

    @Nullable
    private static ServiceView getSelectedView(@Nullable Component contextComponent) {
        while (contextComponent != null && !(contextComponent instanceof ServiceView)) {
            contextComponent = contextComponent.getParent();
        }
        return (ServiceView)contextComponent;
    }

    private static AnAction @NotNull [] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        ServiceViewDescriptor descriptor2;
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(6);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(7);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(8);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
        if (selectedItems.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(9);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (selectedItems.size() == 1) {
            descriptor2 = selectedItems.get(0).getViewDescriptor();
        } else {
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selectedItems);
            ServiceViewDescriptor serviceViewDescriptor = descriptor2 = contributor == null ? null : contributor.getViewDescriptor(project);
        }
        if (descriptor2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(10);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ActionGroup group2 = toolbar ? descriptor2.getToolbarActions() : descriptor2.getPopupActions();
        AnAction[] anActionArray = group2 == null ? AnAction.EMPTY_ARRAY : group2.getChildren(e);
        if (anActionArray == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(11);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createServiceToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapServiceToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMasterComponentToolbar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedView";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ItemPopupActionGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, false);
            if (anActionArray == null) {
                ItemPopupActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemPopupActionGroup", "getChildren"));
        }
    }

    public static class ItemToolbarActionGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, true);
            if (anActionArray == null) {
                ItemToolbarActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemToolbarActionGroup", "getChildren"));
        }
    }

    private static class ServiceViewTreeExpander
    extends DefaultTreeExpander {
        private boolean myFlat;

        ServiceViewTreeExpander(final JTree tree) {
            super(tree);
            TreeModelAdapter listener2 = new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myFlat = ServiceViewTreeExpander.isFlat(tree.getModel());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/services/ServiceViewActionProvider$ServiceViewTreeExpander$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            tree.getModel().addTreeModelListener((TreeModelListener)listener2);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener((TreeModelListener)listener2){
                final /* synthetic */ TreeModelListener val$listener;
                {
                    this.val$listener = treeModelListener;
                }

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object newValue2;
                    Object oldValue = event.getOldValue();
                    if (oldValue instanceof TreeModel) {
                        ((TreeModel)oldValue).removeTreeModelListener(this.val$listener);
                    }
                    if ((newValue2 = event.getNewValue()) instanceof TreeModel) {
                        ((TreeModel)newValue2).addTreeModelListener(this.val$listener);
                    }
                }
            };
            tree.addPropertyChangeListener("model", propertyChangeListener2);
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private static boolean isFlat(TreeModel treeModel) {
            Object root2 = treeModel.getRoot();
            if (root2 == null) {
                return false;
            }
            int childCount = treeModel.getChildCount(root2);
            for (int i2 = 0; i2 < childCount; ++i2) {
                Object child2 = treeModel.getChild(root2, i2);
                if (treeModel.isLeaf(child2)) continue;
                return false;
            }
            return true;
        }
    }
}

