/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;

public final class LvcsHelper {
    private static final Color RED = new JBColor(new Color(250, 220, 220), new Color(104, 67, 67));
    private static final Color GREEN = new JBColor(new Color(220, 250, 220), new Color(44, 66, 60));

    public static void addLabel(TestFrameworkRunningModel model2) {
        String name2;
        int color;
        AbstractTestProxy root2 = model2.getRoot();
        if (root2.isInterrupted()) {
            return;
        }
        TestConsoleProperties consoleProperties = model2.getProperties();
        String configName = consoleProperties.getConfiguration().getName();
        if (root2.isPassed() || root2.isIgnored()) {
            color = GREEN.getRGB();
            name2 = ExecutionBundle.message((String)"junit.running.info.tests.passed.with.test.name.label", (Object[])new Object[]{configName});
        } else {
            color = RED.getRGB();
            name2 = ExecutionBundle.message((String)"junit.running.info.tests.failed.with.test.name.label", (Object[])new Object[]{configName});
        }
        Project project = consoleProperties.getProject();
        if (project.isDisposed()) {
            return;
        }
        LocalHistory.getInstance().putSystemLabel(project, name2, color);
    }
}

