/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor {
    @NotNull
    public static DiffRequestChain createRequestChain(@Nullable Project project, @NotNull ListSelection<? extends DiffHyperlink> requests2) {
        if (requests2 == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        ListSelection producers2 = requests2.map(hyperlink -> new DiffHyperlinkRequestProducer(project, (DiffHyperlink)hyperlink));
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducers((List)producers2.getList(), (int)producers2.getSelectedIndex());
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"TestsFiledAssertions");
        chain.putUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, (Object)true);
        chain.putUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, (Object)"#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
        SimpleDiffRequestChain simpleDiffRequestChain = chain;
        if (simpleDiffRequestChain == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        return simpleDiffRequestChain;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path2) {
        if (path2 == null) {
            return null;
        }
        JarFileSystem fs = path2.contains("!/") ? JarFileSystem.getInstance() : LocalFileSystem.getInstance();
        return fs.refreshAndFindFileByPath(path2);
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project, @NotNull String content2, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (content2 == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        if (contentFile != null) {
            DiffContent diffContent = DiffContentFactory.getInstance().create(project, contentFile);
            if (diffContent == null) {
                TestDiffRequestProcessor.$$$reportNull$$$0(3);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, content2, highlightFile);
        if (documentContent == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        return documentContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestChain";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentWithTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRequestChain";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContentWithTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DiffHyperlinkRequestProducer
    implements DiffRequestProducer {
        private final Project myProject;
        private final DiffHyperlink myHyperlink;

        private DiffHyperlinkRequestProducer(@Nullable Project project, @NotNull DiffHyperlink hyperlink) {
            if (hyperlink == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myHyperlink = hyperlink;
        }

        @Nls
        @NotNull
        public String getName() {
            String testName = this.myHyperlink.getTestName();
            if (testName != null) {
                String string = testName;
                if (string == null) {
                    DiffHyperlinkRequestProducer.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.myHyperlink.getDiffTitle();
            if (string == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
            if (context2 == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator2 == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(4);
            }
            String windowTitle = this.myHyperlink.getDiffTitle();
            String text1 = this.myHyperlink.getLeft();
            String text2 = this.myHyperlink.getRight();
            VirtualFile file1 = TestDiffRequestProcessor.findFile(this.myHyperlink.getFilePath());
            VirtualFile file2 = TestDiffRequestProcessor.findFile(this.myHyperlink.getActualFilePath());
            DiffContent content1 = TestDiffRequestProcessor.createContentWithTitle(this.myProject, text1, file1, file2);
            DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.myProject, text2, file2, file1);
            String title1 = file1 != null ? ExecutionBundle.message((String)"diff.content.expected.title.with.file.url", (Object[])new Object[]{file1.getPresentableUrl()}) : ExecutionBundle.message((String)"diff.content.expected.title", (Object[])new Object[0]);
            String title2 = file2 != null ? ExecutionBundle.message((String)"diff.content.actual.title.with.file.url", (Object[])new Object[]{file2.getPresentableUrl()}) : ExecutionBundle.message((String)"diff.content.actual.title", (Object[])new Object[0]);
            return new SimpleDiffRequest(windowTitle, content1, content2, title1, title2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffHyperlinkRequestProducer producer = (DiffHyperlinkRequestProducer)o;
            return Objects.equals(this.myHyperlink, producer.myHyperlink);
        }

        public int hashCode() {
            return Objects.hash(this.myHyperlink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlink";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

