/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.layout.actions.ViewLayoutModificationAction;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.custom.options.CustomContentLayoutOption;
import com.intellij.ui.content.custom.options.CustomContentLayoutOptions;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ViewLayoutModeActionGroup
extends DefaultActionGroup
implements ViewLayoutModificationAction {
    @NotNull
    private final Content myContent;

    public ViewLayoutModeActionGroup(@NotNull RunnerContentUi ui2, @NotNull Content content2) {
        if (ui2 == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(1);
        }
        super(content2.getDisplayName(), true);
        CustomContentLayoutOptions customLayoutOptions = (CustomContentLayoutOptions)content2.getUserData(CustomContentLayoutOptions.KEY);
        assert (customLayoutOptions != null);
        this.add((AnAction)new ViewLayoutModeAction(new HideContentLayoutModeOption(content2, ui2, customLayoutOptions)));
        for (CustomContentLayoutOption option2 : customLayoutOptions.getAvailableOptions()) {
            this.add((AnAction)new ViewLayoutModeAction(option2));
        }
        this.myContent = content2;
    }

    public boolean isDumbAware() {
        return true;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content2 = this.myContent;
        if (content2 == null) {
            ViewLayoutModeActionGroup.$$$reportNull$$$0(2);
        }
        return content2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HideContentLayoutModeOption
    implements CustomContentLayoutOption {
        private final Content myContent;
        private final RunnerContentUi myUi;
        private final CustomContentLayoutOptions myOptions;

        public HideContentLayoutModeOption(Content content2, RunnerContentUi ui2, CustomContentLayoutOptions options2) {
            this.myContent = content2;
            this.myUi = ui2;
            this.myOptions = options2;
        }

        @Override
        public boolean isSelected() {
            return !this.myContent.isValid() || Objects.requireNonNull(this.myContent.getManager()).getIndexOfContent(this.myContent) == -1;
        }

        @Override
        public void select() {
            this.myUi.minimize(this.myContent, null);
            this.myOptions.onHide();
        }

        @Override
        public boolean isEnabled() {
            return this.isSelected() || this.myUi.getContentManager().getContents().length > 1;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = IdeBundle.message((String)"run.layout.do.not.show.view.option.message", (Object[])new Object[0]);
            if (string == null) {
                HideContentLayoutModeOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup$HideContentLayoutModeOption", "getDisplayName"));
        }
    }

    public static class ViewLayoutModeAction
    extends DumbAwareToggleAction {
        private final CustomContentLayoutOption myOption;

        public ViewLayoutModeAction(@NotNull CustomContentLayoutOption option2) {
            if (option2 == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(0);
            }
            this.myOption = option2;
        }

        public boolean isDumbAware() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(1);
            }
            return this.myOption.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(2);
            }
            this.myOption.select();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewLayoutModeAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myOption.isEnabled());
            e.getPresentation().setText(this.myOption.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/layout/actions/ViewLayoutModeActionGroup$ViewLayoutModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

