/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.hash.LinkedHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    protected Map<String, ViewImpl> myViews = new LinkedHashMap();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    protected Set<TabImpl> myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
    private final Int2ObjectMap<TabImpl.Default> myDefaultTabs = new Int2ObjectOpenHashMap();
    protected General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
    private Set<String> myLightWeightIds = null;

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @Nullable
    public Icon getDefaultIcon(int defaultIndex) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myIcon : null;
    }

    public int getDefaultTabIndex(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null ? viewDefault.getTabID() : -1;
    }

    @Nullable
    public PlaceInGrid getDefaultPlaceInGrid(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null ? viewDefault.getPlaceInGrid() : null;
    }

    public boolean getDefaultIsMinimized(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null ? viewDefault.isMinimizedInGrid() : false;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index2) {
        if (index2 < 0) {
            TabImpl tabImpl = this.createNewTab();
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(0);
            }
            return tabImpl;
        }
        TabImpl tab = this.findTab(index2);
        if (tab != null) {
            TabImpl tabImpl = tab;
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(1);
            }
            return tabImpl;
        }
        TabImpl tabImpl = tab = this.createNewTab(index2);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(2);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl createNewTab(int index2) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index2);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        TabImpl tabImpl = tab;
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(3);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index2) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(index2);
        if (tab == null) {
            tab = new TabImpl.Default(index2, null, null);
            this.myDefaultTabs.put(index2, (Object)tab);
        }
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(4);
        }
        return default_;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index2 = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        return this.createNewTab(index2);
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        if (tab == null) {
            RunnerLayout.$$$reportNull$$$0(5);
        }
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index2) {
        for (TabImpl each : this.myTabs) {
            if (index2 != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element element2 = this.write(new Element("layout"));
        if (element2 == null) {
            RunnerLayout.$$$reportNull$$$0(6);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RunnerLayout.$$$reportNull$$$0(7);
        }
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(8);
        }
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Element)eachTabElement, (Object)this.getOrCreateTab(eachTab.getIndex()));
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Element content2 : views) {
            ViewImpl view = new ViewImpl();
            XmlSerializer.deserializeInto((Element)content2, (Object)view);
            view.assignTab(this.getOrCreateTab(view.getTabIndex()));
            this.myViews.put(view.getID(), view);
        }
        Element general = parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$'));
        XmlSerializer.deserializeInto((Element)(general == null ? new Element("state") : general), (Object)this.myGeneral);
        Element element2 = parentNode;
        if (element2 == null) {
            RunnerLayout.$$$reportNull$$$0(9);
        }
        return element2;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        Element element2;
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(10);
        }
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            element2 = XmlSerializer.serialize((Object)eachState);
            parentNode.addContent(element2 == null ? new Element("ViewImpl") : element2);
        }
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            element2 = XmlSerializer.serialize((Object)eachTab);
            parentNode.addContent(element2 == null ? new Element("TabImpl") : element2);
        }
        Element generalContent = XmlSerializer.serialize((Object)this.myGeneral);
        if (generalContent != null) {
            parentNode.addContent(generalContent);
        }
        Element element3 = parentNode;
        if (element3 == null) {
            RunnerLayout.$$$reportNull$$$0(11);
        }
        return element3;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(12);
        }
        return this.getOrCreateView(RunnerLayout.getOrCreateContentId(content2));
    }

    public void clearStateFor(@NotNull Content content2) {
        Tab tab;
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(13);
        }
        String id2 = RunnerLayout.getOrCreateContentId(content2);
        this.myDefaultViews.remove(id2);
        ViewImpl view = this.myViews.remove(id2);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content2) {
        Object id2;
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(14);
        }
        if ((id2 = (String)content2.getUserData(ViewImpl.ID)) == null) {
            id2 = "UnknownView-" + content2.getDisplayName();
            content2.putUserData(ViewImpl.ID, id2);
        }
        String string = id2;
        if (string == null) {
            RunnerLayout.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id2) {
        ViewImpl view;
        if (id2 == null) {
            RunnerLayout.$$$reportNull$$$0(16);
        }
        if ((view = this.myViews.get(id2)) == null) {
            view = this.getOrCreateDefault(id2).createView(this);
            this.myViews.put(id2, view);
        }
        ViewImpl viewImpl = view;
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(17);
        }
        return viewImpl;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id2) {
        if (id2 == null) {
            RunnerLayout.$$$reportNull$$$0(18);
        }
        if (this.myDefaultViews.containsKey(id2)) {
            ViewImpl.Default default_ = this.myDefaultViews.get(id2);
            if (default_ == null) {
                RunnerLayout.$$$reportNull$$$0(19);
            }
            return default_;
        }
        ViewImpl.Default default_ = this.setDefault(id2, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(20);
        }
        return default_;
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon2) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon2);
        this.myDefaultTabs.put(tabID, (Object)tab);
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(21);
        }
        return default_;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id2, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        if (id2 == null) {
            RunnerLayout.$$$reportNull$$$0(22);
        }
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(23);
        }
        ViewImpl.Default view = new ViewImpl.Default(id2, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id2, view);
        ViewImpl.Default default_ = view;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(24);
        }
        return default_;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(25);
        }
        PlaceInGrid placeInGrid = this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content2)).getPlaceInGrid();
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(26);
        }
        return placeInGrid;
    }

    public boolean isToFocus(String id2, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(27);
        }
        return Objects.equals(id2, this.getToFocus(condition));
    }

    public void setToFocus(String id2, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(28);
        }
        this.myGeneral.focusOnCondition.put(condition, id2);
    }

    public void setDefaultToFocus(@NotNull String id2, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id2 == null) {
            RunnerLayout.$$$reportNull$$$0(29);
        }
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(30);
        }
        if (policy == null) {
            RunnerLayout.$$$reportNull$$$0(31);
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id2, (Object)policy));
    }

    void cancelDefaultFocusBy(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(32);
        }
        this.myDefaultFocus.remove(condition);
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(33);
        }
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair;
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(34);
        }
        Object object = (pair = this.myDefaultFocus.get(condition)) == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
        if (object == null) {
            RunnerLayout.$$$reportNull$$$0(35);
        }
        return object;
    }

    public void setLightWeight(Content content2) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 18: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInGrid";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefaultTab";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateView";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefault";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefault";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGridPlace";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttractionPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearStateFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateView";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDefault";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDefault";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGridPlace";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isToFocus";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setToFocus";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultToFocus";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "cancelDefaultFocusBy";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getToFocus";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAttractionPolicy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

