/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLDistributionService;
import com.intellij.execution.wsl.WslDistributionAndVersion;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.wsl");
    private static final String WSL_PATH_TO_REMOVE = "wsl://";
    private static final NotNullLazyValue<Integer> WINDOWS_RELEASE_ID = NotNullLazyValue.createValue(() -> StringUtil.parseInt((String)WSLUtil.getWindowsReleaseIdString(), (int)-1));
    private static final NullableLazyValue<WSLToolFlags> WSL_TOOL_FLAGS = NullableLazyValue.createValue(() -> WSLUtil.getWSLToolFlagsInternal());
    private static final Pattern QUIET = Pattern.compile("\\s--quiet,?\\b");
    private static final Pattern VERBOSE = Pattern.compile("\\s--verbose,?\\b");

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static boolean hasAvailableDistributions() {
        return !WSLUtil.getAvailableDistributions().isEmpty();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        if (!WSLUtil.isSystemCompatible()) {
            List<WSLDistribution> list2 = Collections.emptyList();
            if (list2 == null) {
                WSLUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Path executableRoot = WSLUtil.getExecutableRootPath();
        if (executableRoot == null) {
            List<WSLDistribution> list3 = Collections.emptyList();
            if (list3 == null) {
                WSLUtil.$$$reportNull$$$0(1);
            }
            return list3;
        }
        Collection<WslDistributionDescriptor> descriptors = WSLDistributionService.getInstance().getDescriptors();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(descriptors.size() + 1);
        for (WslDistributionDescriptor descriptor2 : descriptors) {
            String executablePathStr = descriptor2.getExecutablePath();
            if (executablePathStr == null) continue;
            Path executablePath = Paths.get(executablePathStr, new String[0]);
            if (!executablePath.isAbsolute()) {
                executablePath = executableRoot.resolve(executablePath);
            }
            if (!Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) continue;
            result2.add(new WSLDistribution(descriptor2, executablePath));
        }
        if (Experiments.getInstance().isFeatureEnabled("wsl.legacy.distribution")) {
            ContainerUtil.addIfNotNull(result2, (Object)WSLDistributionLegacy.getInstance());
        }
        ArrayList<WSLDistribution> arrayList = result2;
        if (arrayList == null) {
            WSLUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static Path getExecutableRootPath() {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : Paths.get(localAppDataPath, "Microsoft\\WindowsApps");
    }

    @Deprecated
    @Nullable
    public static WSLDistribution getDistributionByMsId(@Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        for (WSLDistribution distribution2 : WSLUtil.getAvailableDistributions()) {
            if (!name2.equals(distribution2.getMsId())) continue;
            return distribution2;
        }
        return null;
    }

    public static boolean isSystemCompatible() {
        return SystemInfo.isWin10OrNewer;
    }

    @Nullable
    public static String getWindowsPath(@NotNull String wslPath, @NotNull String mntRoot) {
        if (wslPath == null) {
            WSLUtil.$$$reportNull$$$0(3);
        }
        if (mntRoot == null) {
            WSLUtil.$$$reportNull$$$0(4);
        }
        if (!wslPath.startsWith(mntRoot)) {
            return null;
        }
        int driveLetterIndex = mntRoot.length();
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(Character.toUpperCase(wslPath.charAt(driveLetterIndex)) + ":" + wslPath.substring(slashIndex)));
    }

    static int getWslVersion(@NotNull WSLDistribution distribution2) {
        int version2;
        if (distribution2 == null) {
            WSLUtil.$$$reportNull$$$0(5);
        }
        if ((version2 = WSLUtil.getVersionFromWslCli(distribution2)) < 0) {
            version2 = WSLUtil.getVersionByUname(distribution2);
        }
        return version2;
    }

    private static int getVersionFromWslCli(@NotNull WSLDistribution distribution2) {
        if (distribution2 == null) {
            WSLUtil.$$$reportNull$$$0(6);
        }
        try {
            List<WslDistributionAndVersion> versions = WslDistributionManager.getInstance().loadInstalledDistributionsWithVersions();
            WslDistributionAndVersion distributionAndVersion = (WslDistributionAndVersion)ContainerUtil.find(versions, version2 -> version2.getDistributionName().equals(distribution2.getMsId()));
            if (distributionAndVersion != null) {
                return distributionAndVersion.getVersion();
            }
            LOG.warn("WSL distribution '" + distribution2.getMsId() + "' not found");
        }
        catch (IOException | IllegalStateException e) {
            LOG.warn("Failed to calculate version for " + distribution2.getMsId() + ": " + e.getMessage());
        }
        return -1;
    }

    private static int getVersionByUname(@NotNull WSLDistribution distribution2) {
        if (distribution2 == null) {
            WSLUtil.$$$reportNull$$$0(7);
        }
        try {
            ProcessOutput output2 = distribution2.executeOnWsl(WSLDistribution.DEFAULT_TIMEOUT, "uname", "-v");
            if (output2.checkSuccess(LOG)) {
                return output2.getStdout().contains("Microsoft") ? 1 : 2;
            }
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        return -1;
    }

    @NotNull
    @NlsSafe
    public static String getMsId(@NotNull @NlsSafe String msOrInternalId) {
        WslDistributionDescriptor descriptor2;
        if (msOrInternalId == null) {
            WSLUtil.$$$reportNull$$$0(8);
        }
        String string = (descriptor2 = (WslDistributionDescriptor)ContainerUtil.find(WSLDistributionService.getInstance().getDescriptors(), d -> d.getId().equals(msOrInternalId))) != null ? descriptor2.getMsId() : msOrInternalId;
        if (string == null) {
            WSLUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static int getWindowsReleaseId() {
        return (Integer)WINDOWS_RELEASE_ID.getValue();
    }

    @Nullable
    private static String getWindowsReleaseIdString() {
        try {
            if (JnaLoader.isLoaded()) {
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"ReleaseId");
            }
        }
        catch (Throwable e) {
            LOG.warn("Cannot read Windows version", e);
        }
        return WindowsRegistryUtil.readRegistryValue((String)"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"ReleaseId");
    }

    @Nullable
    public static WSLToolFlags getWSLToolFlags() {
        return (WSLToolFlags)WSL_TOOL_FLAGS.getValue();
    }

    @Nullable
    private static WSLToolFlags getWSLToolFlagsInternal() {
        Path wslExe = WSLDistribution.findWslExe();
        if (wslExe == null) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{wslExe.toString(), "--help"}).withCharset(StandardCharsets.UTF_16LE);
        try {
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)5000);
            if (output2.isTimeout()) {
                return null;
            }
            String stdout = output2.getStdout();
            return new WSLToolFlags(QUIET.matcher(stdout).find(), VERBOSE.matcher(stdout).find());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void fixWslPrefix(@NotNull Sdk sdk2) {
        String path2;
        if (sdk2 == null) {
            WSLUtil.$$$reportNull$$$0(10);
        }
        if (sdk2 instanceof ProjectJdkImpl && (path2 = sdk2.getHomePath()) != null && path2.startsWith(WSL_PATH_TO_REMOVE)) {
            ((ProjectJdkImpl)sdk2).setHomePath("\\\\wsl$\\" + path2.substring(WSL_PATH_TO_REMOVE.length()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mntRoot";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msOrInternalId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWslVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromWslCli";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionByUname";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMsId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixWslPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class WSLToolFlags {
        public final boolean isQuietFlagAvailable;
        public final boolean isVerboseFlagAvailable;

        WSLToolFlags(boolean isQuietAvailable, boolean isVerboseAvailable) {
            this.isQuietFlagAvailable = isQuietAvailable;
            this.isVerboseFlagAvailable = isVerboseAvailable;
        }
    }
}

