/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/wsl/WslDistributionConsoleFolding;", "Lcom/intellij/execution/ConsoleFolding;", "()V", "getPlaceholderText", "", "project", "Lcom/intellij/openapi/project/Project;", "lines", "", "line", "shouldBeAttachedToThePreviousLine", "", "shouldFoldLine", "shouldFoldLineNoProject", "Companion", "intellij.platform.execution.impl"})
public final class WslDistributionConsoleFolding
extends ConsoleFolding {
    private static final String WSL_EXE_DISTRIBUTION = "wsl.exe --distribution";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean shouldFoldLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.shouldFoldLineNoProject(line);
    }

    @VisibleForTesting
    public final boolean shouldFoldLineNoProject(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int wslExeIndex = StringsKt.indexOf$default((CharSequence)line, (String)WSL_EXE_DISTRIBUTION, (int)0, (boolean)false, (int)6, null);
        if (wslExeIndex <= 0) {
            return false;
        }
        int execIndex = StringsKt.indexOf$default((CharSequence)line, (String)"--exec", (int)(wslExeIndex + 1), (boolean)false, (int)4, null);
        if (execIndex < 0) {
            return false;
        }
        int ampIndex = StringsKt.indexOf$default((CharSequence)line, (String)"&& ", (int)0, (boolean)false, (int)6, null);
        int n = ampIndex;
        if (0 <= n && execIndex > n) {
            return false;
        }
        String string = line;
        int n2 = 0;
        boolean bl = false;
        String string2 = string.substring(n2, wslExeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String wslExePath = StringsKt.trim((String)string2, (char[])new char[]{'\\', '/'});
        String string3 = PathEnvironmentVariableUtil.getPathVariableValue();
        return string3 != null && StringsKt.contains$default((CharSequence)string3, (CharSequence)wslExePath, (boolean)false, (int)2, null);
        {
        }
    }

    @Override
    public boolean shouldBeAttachedToThePreviousLine() {
        return false;
    }

    @Override
    @Nullable
    public String getPlaceholderText(@NotNull Project project, @NotNull List<String> lines2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines");
        if (lines2.size() != 1) {
            return null;
        }
        return this.getPlaceholderText(lines2.get(0));
    }

    @VisibleForTesting
    @Nullable
    public final String getPlaceholderText(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int indexOfDistribution = StringsKt.indexOf$default((CharSequence)line, (String)"--distribution", (int)0, (boolean)false, (int)6, null) + "--distribution".length() + 1;
        if (indexOfDistribution <= "--distribution".length() || indexOfDistribution >= line.length()) {
            return null;
        }
        String string = line;
        boolean bl = false;
        String string2 = string.substring(indexOfDistribution);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String distributionLine = string2;
        int distributionSpaceIndex = StringsKt.indexOf$default((CharSequence)distributionLine, (String)" ", (int)0, (boolean)false, (int)6, null);
        if (distributionSpaceIndex < 0) {
            return null;
        }
        String string3 = distributionLine;
        int n = 0;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, distributionSpaceIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        distributionLine = string5;
        distributionLine = StringsKt.trim((String)distributionLine, (char[])new char[]{'\"'});
        int indexOfAmp = StringsKt.lastIndexOf$default((CharSequence)line, (String)"&& ", (int)0, (boolean)false, (int)6, null);
        int indexOfExec = StringsKt.indexOf$default((CharSequence)line, (String)"--exec", (int)0, (boolean)false, (int)6, null);
        int userCLStart = indexOfAmp + 3;
        if (userCLStart <= 2 && (userCLStart = indexOfExec + "--exec".length() + 1) <= "--exec".length()) {
            return null;
        }
        int indexOfExitCode = StringsKt.lastIndexOf$default((CharSequence)line, (String)"; exitcode=$?", (int)0, (boolean)false, (int)6, null);
        boolean endsWithQuote = StringsKt.endsWith$default((String)line, (String)"\"", (boolean)false, (int)2, null);
        int userCLEnd = indexOfExitCode == -1 ? (endsWithQuote ? (indexOfAmp < 0 && indexOfExec >= 0 && StringsKt.indexOf$default((CharSequence)line, (String)"-c \"", (int)0, (boolean)false, (int)6, null) >= 0 ? line.length() - 1 : line.length() - 2) : line.length() - 1) : indexOfExitCode - 1;
        int n2 = userCLStart;
        String userCL = StringsKt.substring((String)line, (IntRange)new IntRange(n2, userCLEnd));
        return ExecutionBundle.message((String)"wsl.folding.placeholder", (Object[])new Object[]{distributionLine, userCL});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/execution/wsl/WslDistributionConsoleFolding$Companion;", "", "()V", "WSL_EXE_DISTRIBUTION", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

