/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.macro.MacroPathConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class WslMacroPathConverter
implements MacroPathConverter {
    private static final Logger LOG = Logger.getInstance(WslMacroPathConverter.class);
    private final WSLDistribution myWsl;

    public WslMacroPathConverter(@NotNull WSLDistribution wsl) {
        if (wsl == null) {
            WslMacroPathConverter.$$$reportNull$$$0(0);
        }
        this.myWsl = wsl;
    }

    @Override
    @NotNull
    public String convertPath(@NotNull String path2) {
        String string;
        if (path2 == null) {
            WslMacroPathConverter.$$$reportNull$$$0(1);
        }
        try {
            String converted = this.myWsl.getWslPath(path2);
            string = converted != null ? converted : path2;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to convert to path: " + path2, (Throwable)e);
            String string2 = path2;
            if (string2 == null) {
                WslMacroPathConverter.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (string == null) {
            WslMacroPathConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String convertPathList(@NotNull String pathList) {
        if (pathList == null) {
            WslMacroPathConverter.$$$reportNull$$$0(4);
        }
        List paths2 = StringUtil.split((String)pathList, (String)File.pathSeparator);
        String string = Strings.join((Collection)ContainerUtil.map((Collection)paths2, p -> this.convertPath((String)p)), (String)":");
        if (string == null) {
            WslMacroPathConverter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslMacroPathConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslMacroPathConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertPathList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

