/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u000201B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\f\u00a8\u00062"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment;", "Lcom/intellij/execution/target/TargetEnvironment;", "request", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;Lcom/intellij/execution/wsl/WSLDistribution;)V", "downloadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "getDownloadVolumes", "()Ljava/util/Map;", "localPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "Lcom/intellij/execution/target/ResolvedPortBinding;", "getLocalPortBindings", "myDownloadVolumes", "", "myLocalPortBindings", "myTargetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "", "myUploadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "getRequest", "()Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "targetPortBindings", "getTargetPortBindings", "uploadVolumes", "getUploadVolumes", "convertUncPathToLinux", "", "localPath", "createProcess", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "shutdown", "", "toLinuxPath", "Companion", "Volume", "intellij.platform.execution.impl"})
public final class WslTargetEnvironment
extends TargetEnvironment {
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> myLocalPortBindings;
    @NotNull
    private final WslTargetEnvironmentRequest request;
    private final WSLDistribution distribution;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map2 = Collections.unmodifiableMap(this.myUploadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myUploadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map2 = Collections.unmodifiableMap(this.myDownloadVolumes);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myDownloadVolumes)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map2 = Collections.unmodifiableMap(this.myTargetPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myTargetPortBindings)");
        return map2;
    }

    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, ResolvedPortBinding> map2 = Collections.unmodifiableMap(this.myLocalPortBindings);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(myLocalPortBindings)");
        return map2;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    private final String toLinuxPath(String localPath) {
        String linuxPath = this.distribution.getWslPath(localPath);
        if (linuxPath != null) {
            return linuxPath;
        }
        return this.convertUncPathToLinux(localPath);
    }

    private final String convertUncPathToLinux(String localPath) {
        String root2 = "\\\\wsl$\\" + this.distribution.getMsId();
        String string = FileUtil.toSystemDependentName((String)localPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDependentName(localPath)");
        String winLocalPath = string;
        if (StringsKt.startsWith$default((String)winLocalPath, (String)root2, (boolean)false, (int)2, null)) {
            CharSequence charSequence = winLocalPath;
            int n = root2.length();
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String linuxPath = string3;
            charSequence = linuxPath;
            n = 0;
            if (charSequence.length() == 0) {
                return "/";
            }
            if (StringsKt.startsWith$default((String)linuxPath, (String)"\\", (boolean)false, (int)2, null)) {
                return FileUtil.toSystemIndependentName((String)linuxPath);
            }
        }
        return null;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator2) throws ExecutionException {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        LocalPtyOptions ptyOptions = this.getRequest().getPtyOptions();
        if (ptyOptions != null) {
            PtyCommandLine ptyCommandLine = new PtyCommandLine(commandLine.collectCommandsSynchronously());
            boolean bl = false;
            boolean bl2 = false;
            PtyCommandLine it = ptyCommandLine;
            boolean bl3 = false;
            it.withOptions(ptyOptions);
            generalCommandLine = (GeneralCommandLine)ptyCommandLine;
        } else {
            generalCommandLine = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
        }
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        Map map2 = generalCommandLine2.getEnvironment();
        Map map3 = commandLine.getEnvironmentVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"commandLine.environmentVariables");
        map2.putAll(map3);
        this.getRequest().getWslOptions().setRemoteWorkingDirectory(commandLine.getWorkingDirectory());
        generalCommandLine2.withRedirectErrorStream(commandLine.isRedirectErrorStream());
        this.distribution.patchCommandLine(generalCommandLine2, null, this.getRequest().getWslOptions());
        Process process2 = generalCommandLine2.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"generalCommandLine.createProcess()");
        return process2;
    }

    public void shutdown() {
    }

    @NotNull
    public WslTargetEnvironmentRequest getRequest() {
        return this.request;
    }

    public WslTargetEnvironment(@NotNull WslTargetEnvironmentRequest request2, @NotNull WSLDistribution distribution2) {
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        Intrinsics.checkNotNullParameter((Object)distribution2, (String)"distribution");
        super((TargetEnvironmentRequest)request2);
        this.request = request2;
        this.distribution = distribution2;
        this.myUploadVolumes = new HashMap();
        this.myDownloadVolumes = new HashMap();
        this.myTargetPortBindings = new HashMap();
        this.myLocalPortBindings = new HashMap();
        for (TargetEnvironment.UploadRoot uploadRoot : this.getRequest().getUploadVolumes()) {
            String targetRoot = this.toLinuxPath(((Object)uploadRoot.getLocalRootPath().toAbsolutePath()).toString());
            if (targetRoot != null) {
                this.myUploadVolumes.put(uploadRoot, new Volume(uploadRoot.getLocalRootPath(), targetRoot));
                continue;
            }
            LOG.error("Cannot register upload volume: WSL path not found for local path: " + uploadRoot.getLocalRootPath());
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : this.getRequest().getDownloadVolumes()) {
            Path localRootPath;
            String targetRoot;
            Path path2 = downloadRoot.getLocalRootPath();
            if (path2 == null) {
                path2 = FileUtil.createTempDirectory((String)"intellij-target.", (String)"").toPath();
            }
            if ((targetRoot = this.toLinuxPath(((Object)(localRootPath = path2).toAbsolutePath()).toString())) == null) continue;
            Path path3 = localRootPath;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"localRootPath");
            this.myDownloadVolumes.put(downloadRoot, new Volume(path3, targetRoot));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : this.getRequest().getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null) {
                Integer n = targetPortBinding.getLocal();
                if (n == null || n != theOnlyPort) {
                    throw (Throwable)new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
                }
            }
            this.myTargetPortBindings.put(targetPortBinding, theOnlyPort);
        }
        for (TargetEnvironment.LocalPortBinding localPortBinding : this.getRequest().getLocalPortBindings()) {
            String host;
            String string = host = this.distribution.getVersion() == 1 ? "127.0.0.1" : this.distribution.getHostIp();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
            HostPort hostPort = new HostPort(string, localPortBinding.getLocal());
            this.myLocalPortBindings.put(localPortBinding, new ResolvedPortBinding(hostPort, hostPort));
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslTargetEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Volume;", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "Lcom/intellij/execution/target/TargetEnvironment$DownloadableVolume;", "localRoot", "Ljava/nio/file/Path;", "targetRoot", "", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironment;Ljava/nio/file/Path;Ljava/lang/String;)V", "getLocalRoot", "()Ljava/nio/file/Path;", "getTargetRoot", "()Ljava/lang/String;", "download", "", "relativePath", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resolveTargetPath", "upload", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "intellij.platform.execution.impl"})
    private final class Volume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        @NotNull
        private final Path localRoot;
        @NotNull
        private final String targetRoot;

        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            String localPath;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            String string = localPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{((Object)this.getLocalRoot()).toString(), relativePath}));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localPath");
            String string2 = WslTargetEnvironment.this.toLinuxPath(string);
            if (string2 == null) {
                throw (Throwable)new RuntimeException("Cannot find Linux path for " + localPath + " (" + WslTargetEnvironment.this.distribution.getMsId() + ')');
            }
            return string2;
        }

        public void upload(@NotNull String relativePath, @NotNull TargetProgressIndicator targetProgressIndicator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        }

        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Path path2 = this.getLocalRoot().resolve(relativePath);
            long previousSize = -2L;
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            long newSize = PathKt.sizeOrNull((Path)path3);
            while (previousSize < newSize) {
                Thread.sleep(100L);
                previousSize = newSize;
                newSize = PathKt.sizeOrNull((Path)path2);
            }
            if (newSize == -1L) {
                Companion.getLOG().warn("Path " + path2 + " was not found on local filesystem");
            }
        }

        @NotNull
        public Path getLocalRoot() {
            return this.localRoot;
        }

        @NotNull
        public String getTargetRoot() {
            return this.targetRoot;
        }

        public Volume(@NotNull Path localRoot, String targetRoot) {
            Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
            Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
            this.localRoot = localRoot;
            this.targetRoot = targetRoot;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironment$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

