/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.target;

import com.intellij.execution.Platform;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.target.BaseTargetEnvironmentRequest;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.target.WslTargetEnvironment;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.ide.IdeBundle;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BG\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020(0%2\u0006\u0010*\u001a\u00020(H\u0016J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u001a\u0010/\u001a\u00020\u00132\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0000H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016R\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lcom/intellij/execution/wsl/target/WslTargetEnvironmentRequest;", "Lcom/intellij/execution/target/BaseTargetEnvironmentRequest;", "config", "Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;)V", "uploadVolumes", "", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "downloadVolumes", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "targetPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "localPortBindings", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "(Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "configuration", "getConfiguration", "()Lcom/intellij/execution/wsl/target/WslTargetEnvironmentConfiguration;", "defaultVolume", "Lcom/intellij/execution/target/TargetEnvironmentRequest$Volume;", "getDefaultVolume", "()Lcom/intellij/execution/target/TargetEnvironmentRequest$Volume;", "ptyOptions", "Lcom/intellij/execution/process/LocalPtyOptions;", "getPtyOptions", "()Lcom/intellij/execution/process/LocalPtyOptions;", "setPtyOptions", "(Lcom/intellij/execution/process/LocalPtyOptions;)V", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "getTargetPlatform", "()Lcom/intellij/execution/target/TargetPlatform;", "wslOptions", "Lcom/intellij/execution/wsl/WSLCommandLineOptions;", "getWslOptions", "()Lcom/intellij/execution/wsl/WSLCommandLineOptions;", "bindLocalPort", "Lcom/intellij/execution/target/value/TargetValue;", "Lcom/intellij/execution/target/HostPort;", "localPort", "", "bindTargetPort", "targetPort", "createDownloadRoot", "Lcom/intellij/execution/target/TargetEnvironmentRequest$DownloadableVolume;", "remoteRootPath", "", "createUploadRoot", "temporary", "", "duplicate", "prepareEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "progressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "intellij.platform.execution.impl"})
public final class WslTargetEnvironmentRequest
extends BaseTargetEnvironmentRequest {
    @NotNull
    private final WslTargetEnvironmentConfiguration configuration;
    @Nullable
    private LocalPtyOptions ptyOptions;
    @NotNull
    private final WSLCommandLineOptions wslOptions;

    @NotNull
    public WslTargetEnvironmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final LocalPtyOptions getPtyOptions() {
        return this.ptyOptions;
    }

    public final void setPtyOptions(@Nullable LocalPtyOptions localPtyOptions) {
        this.ptyOptions = localPtyOptions;
    }

    @NotNull
    public final WSLCommandLineOptions getWslOptions() {
        return this.wslOptions;
    }

    @NotNull
    public WslTargetEnvironmentRequest duplicate() {
        return new WslTargetEnvironmentRequest(this.getConfiguration(), new HashSet(this.getUploadVolumes()), new HashSet(this.getDownloadVolumes()), new HashSet(this.getTargetPortBindings()), new HashSet(this.getLocalPortBindings()));
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        throw (Throwable)new UnsupportedOperationException("defaultVolume is not implemented");
    }

    @NotNull
    public TargetEnvironmentRequest.Volume createUploadRoot(@Nullable String remoteRootPath, boolean temporary) {
        throw (Throwable)new UnsupportedOperationException("createUploadRoot is not implemented");
    }

    @NotNull
    public TargetEnvironmentRequest.DownloadableVolume createDownloadRoot(@Nullable String remoteRootPath) {
        throw (Throwable)new UnsupportedOperationException("createDownloadRoot is not implemented");
    }

    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        TargetValue targetValue = TargetValue.fixed((Object)targetPort);
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"TargetValue.fixed(targetPort)");
        return targetValue;
    }

    @NotNull
    public TargetValue<HostPort> bindLocalPort(int localPort) {
        TargetValue targetValue = TargetValue.fixed((Object)new HostPort("localhost", localPort));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"TargetValue.fixed(HostPo\u2026(\"localhost\", localPort))");
        return targetValue;
    }

    @NotNull
    public TargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        WSLDistribution distribution2 = this.getConfiguration().getDistribution();
        if (distribution2 == null) {
            String string = IdeBundle.message((String)"wsl.no.distribution.found.error", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"wsl.n\u2026istribution.found.error\")");
            String string2 = string;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        WslTargetEnvironment wslTargetEnvironment = new WslTargetEnvironment(this, distribution2);
        boolean bl = false;
        boolean bl2 = false;
        WslTargetEnvironment it = wslTargetEnvironment;
        boolean bl3 = false;
        this.environmentPrepared(it, progressIndicator);
        return wslTargetEnvironment;
    }

    public WslTargetEnvironmentRequest(@NotNull WslTargetEnvironmentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        super(null, null, null, null, null, 31, null);
        this.wslOptions = new WSLCommandLineOptions();
        this.configuration = config2;
    }

    private WslTargetEnvironmentRequest(WslTargetEnvironmentConfiguration config2, Set<TargetEnvironment.UploadRoot> uploadVolumes, Set<TargetEnvironment.DownloadRoot> downloadVolumes, Set<TargetEnvironment.TargetPortBinding> targetPortBindings, Set<TargetEnvironment.LocalPortBinding> localPortBindings) {
        super(uploadVolumes, downloadVolumes, targetPortBindings, localPortBindings, null, 16, null);
        this.wslOptions = new WSLCommandLineOptions();
        this.configuration = config2;
    }
}

