/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.RegisterToolWindowTaskProvider;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FacetDependentToolWindowManager
implements RegisterToolWindowTaskProvider {
    FacetDependentToolWindowManager() {
    }

    @Override
    @NotNull
    public Collection<ToolWindowEP> getTasks(@NotNull Project project) {
        List facetDependentToolWindows;
        if (project == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        if ((facetDependentToolWindows = FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList()).isEmpty()) {
            List<ToolWindowEP> list2 = Collections.emptyList();
            if (list2 == null) {
                FacetDependentToolWindowManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<ToolWindowEP> result2 = new ArrayList<ToolWindowEP>();
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance((Project)project);
        block0: for (FacetDependentToolWindow extension2 : facetDependentToolWindows) {
            for (FacetType type : extension2.getFacetTypes()) {
                if (!projectFacetManager.hasFacets(type.getId())) continue;
                result2.add((ToolWindowEP)extension2);
                continue block0;
            }
        }
        FacetDependentToolWindowManager.projectOpened(project);
        ArrayList<ToolWindowEP> arrayList = result2;
        if (arrayList == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void projectOpened(final @NotNull Project project) {
        if (project == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(3);
        }
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (FacetDependentToolWindow extension2 : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    FacetDependentToolWindowManager.ensureToolWindowExists(extension2, project);
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                ProjectFacetManager facetManager;
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((facetManager = ProjectFacetManager.getInstance((Project)project)).hasFacets(facet.getTypeId())) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                for (FacetDependentToolWindow extension2 : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    ToolWindow toolWindow2 = toolWindowManager.getToolWindow(extension2.id);
                    if (toolWindow2 == null) continue;
                    for (FacetType facetType : extension2.getFacetTypes()) {
                        if (!facetManager.hasFacets(facetType.getId())) continue;
                        return;
                    }
                    toolWindow2.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
        FacetDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetDependentToolWindow>(){

            public void extensionAdded(@NotNull FacetDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FacetDependentToolWindowManager.initToolWindowIfNeeded(extension2, project);
            }

            public void extensionRemoved(@NotNull FacetDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window;
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow(extension2.id)) != null) {
                    window.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private static void initToolWindowIfNeeded(@NotNull FacetDependentToolWindow extension2, @NotNull Project project) {
        if (extension2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(5);
        }
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance((Project)project);
        for (FacetType type : extension2.getFacetTypes()) {
            if (!projectFacetManager.hasFacets(type.getId())) continue;
            FacetDependentToolWindowManager.ensureToolWindowExists(extension2, project);
            return;
        }
    }

    private static void ensureToolWindowExists(@NotNull FacetDependentToolWindow extension2, @NotNull Project project) {
        ToolWindowManagerEx toolWindowManager;
        ToolWindow toolWindow2;
        if (extension2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(7);
        }
        if ((toolWindow2 = (toolWindowManager = ToolWindowManagerEx.getInstanceEx(project)).getToolWindow(extension2.id)) == null) {
            WindowInfoImpl windowInfo;
            toolWindowManager.initToolWindow((ToolWindowEP)extension2);
            if (!extension2.showOnStripeByDefault && (toolWindow2 = toolWindowManager.getToolWindow(extension2.id)) != null && (windowInfo = toolWindowManager.getLayout().getInfo(extension2.id)) != null && !windowInfo.isFromPersistentSettings()) {
                toolWindow2.setShowStripeButton(false);
            }
        }
    }

    @NotNull
    private static List<FacetDependentToolWindow> getDependentExtensions(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.filter((Collection)FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList(), toolWindowEP -> {
            for (String id2 : toolWindowEP.getFacetIds()) {
                if (!facet.getType().getStringId().equals(id2)) continue;
                return true;
            }
            return false;
        });
        if (list2 == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindowIfNeeded";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowExists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependentExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

