/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.NextFileProbability;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "", "byFile", "", "", "", "(Ljava/util/Map;)V", "maxProbability", "minProbability", "calculateFileFeatures", "Lcom/intellij/filePrediction/features/history/NextFileProbability;", "fileUrl", "intellij.platform.ml.impl"})
public final class FilePredictionNGramFeatures {
    private final double minProbability;
    private final double maxProbability;
    private final Map<String, Double> byFile;

    @Nullable
    public final NextFileProbability calculateFileFeatures(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Double probability = this.byFile.get(fileUrl);
        if (probability == null) {
            return null;
        }
        double mleToMin = this.minProbability != 0.0 ? probability / this.minProbability : 0.0;
        double mleToMax = this.maxProbability != 0.0 ? probability / this.maxProbability : 0.0;
        return new NextFileProbability(probability, this.minProbability, this.maxProbability, mleToMin, mleToMax);
    }

    public FilePredictionNGramFeatures(@NotNull Map<String, Double> byFile) {
        Intrinsics.checkNotNullParameter(byFile, (String)"byFile");
        this.byFile = byFile;
        double minProb = 1.0;
        double maxProb = 0.0;
        Iterator<Double> iterator2 = this.byFile.values().iterator();
        while (iterator2.hasNext()) {
            double nGram = ((Number)iterator2.next()).doubleValue();
            boolean bl = false;
            minProb = Math.min(minProb, nGram);
            bl = false;
            maxProb = Math.max(maxProb, nGram);
        }
        double d = 1.0E-4;
        boolean bl = false;
        this.minProbability = Math.max(minProb, d);
        d = 1.0E-4;
        bl = false;
        this.maxProbability = Math.max(maxProb, d);
    }
}

