/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction
implements UpdateInBackground {
    @ApiStatus.Experimental
    public static final DataKey<Collection<SearchTarget>> SEARCH_TARGETS = DataKey.create("search.targets");

    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    protected boolean toShowDialog() {
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            FindUsagesAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final DataContext dataContext = e.getDataContext();
        ResolverKt.findShowUsages(project, dataContext, ResolverKt.allTargets(dataContext), FindBundle.message("find.usages.ambiguous.title", new Object[0]), new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
                FindUsagesKt.findUsages(FindUsagesAction.this.toShowDialog(), project, searchScope2, target2);
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FindUsagesAction.this.startFindUsages(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/FindUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void startFindUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesAction.$$$reportNull$$$0(1);
        }
        FindManager.getInstance((Project)element2.getProject()).findUsages(element2);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesAction.$$$reportNull$$$0(2);
        }
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/actions/FindUsagesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element2) {
            if (element2 == null) {
                ShowSettingsAndFindUsages.$$$reportNull$$$0(0);
            }
            FindManager.getInstance((Project)element2.getProject()).findUsages(element2, true);
        }

        @Override
        protected boolean toShowDialog() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/FindUsagesAction$ShowSettingsAndFindUsages", "startFindUsages"));
        }
    }
}

