/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.LastSearchData;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.findUsages.UsageHistory;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindUsagesManager {
    private static final Logger LOG = Logger.getInstance(FindUsagesManager.class);
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private LastSearchData myLastSearchInFileData;
    private final UsageHistory myHistory;

    public FindUsagesManager(@NotNull Project project) {
        if (project == null) {
            FindUsagesManager.$$$reportNull$$$0(0);
        }
        this.myHistory = new UsageHistory();
        this.myProject = project;
    }

    public boolean canFindUsages(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(1);
        }
        for (FindUsagesHandlerFactory factory2 : (FindUsagesHandlerFactory[])FindUsagesHandlerFactory.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            try {
                if (!factory2.canFindUsages(element2)) continue;
                return true;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = null;
    }

    public boolean findNextUsageInFile(@NotNull Editor editor2) {
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(2);
        }
        return this.findUsageInFile(editor2, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(@NotNull Editor editor2) {
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(3);
        }
        return this.findUsageInFile(editor2, FileSearchScope.BEFORE_CARET);
    }

    private boolean findUsageInFile(@NotNull Editor editor2, @NotNull FileSearchScope direction) {
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(4);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLastSearchInFileData == null) {
            return false;
        }
        PsiElement[] primaryElements = this.myLastSearchInFileData.getPrimaryElements();
        PsiElement[] secondaryElements = this.myLastSearchInFileData.getSecondaryElements();
        if (primaryElements.length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return false;
        }
        Document document = editor2.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(primaryElements[0], false);
        if (handler2 == null) {
            return false;
        }
        this.findUsagesInEditor(primaryElements, secondaryElements, handler2, psiFile, direction, this.myLastSearchInFileData.getOptions(), editor2);
        return true;
    }

    private void initLastSearchElement(@NotNull FindUsagesOptions findUsagesOptions, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements) {
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(6);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(7);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = new LastSearchData(primaryElements, secondaryElements, findUsagesOptions);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(9);
        }
        return this.getFindUsagesHandler(element2, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.DEFAULT);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element2, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(10);
        }
        if (operationMode == null) {
            FindUsagesManager.$$$reportNull$$$0(11);
        }
        for (FindUsagesHandlerFactory factory2 : (FindUsagesHandlerFactory[])FindUsagesHandlerFactory.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!factory2.canFindUsages(element2)) continue;
            FindUsagesHandler handler2 = factory2.createFindUsagesHandler(element2, operationMode);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    public FindUsagesHandler getNewFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(12);
        }
        for (FindUsagesHandlerFactory factory2 : FindUsagesHandlerFactory.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            if (!factory2.canFindUsages(element2)) continue;
            Class<?> aClass = factory2.getClass();
            FindUsagesHandlerFactory copy2 = (FindUsagesHandlerFactory)this.myProject.instantiateClass(aClass, factory2.pluginDescriptor.getPluginId());
            FindUsagesHandler handler2 = copy2.createFindUsagesHandler(element2, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, @Nullable PsiFile scopeFile, FileEditor editor2, boolean showDialog, @Nullable(value="null means default (stored in options)") @Nullable(value="null means default (stored in options)") SearchScope searchScope2) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, showDialog ? FindUsagesHandlerFactory.OperationMode.DEFAULT : FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
        if (handler2 == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog2 = handler2.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (showDialog) {
            if (!dialog2.showAndGet()) {
                return;
            }
        } else {
            dialog2.close(0);
        }
        this.setOpenInNewTab(dialog2.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog2.calcFindUsagesOptions();
        if (searchScope2 != null) {
            findUsagesOptions.searchScope = searchScope2;
        }
        this.clearFindingNextUsageInFile();
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor2);
    }

    void startFindUsages(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findUsagesOptions) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(14);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        this.startFindUsages(findUsagesOptions, handler2, null, null);
    }

    private void startFindUsages(@NotNull FindUsagesOptions findUsagesOptions, @NotNull FindUsagesHandler handler2, PsiFile scopeFile, FileEditor fileEditor) {
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(16);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageViewStatisticsCollector.logSearchStarted((Project)this.myProject);
        boolean singleFile = scopeFile != null;
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler2.getPsiElement().isValid());
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        FindUsagesManager.checkNotNull(primaryElements, handler2, "getPrimaryElements()");
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        FindUsagesManager.checkNotNull(secondaryElements, handler2, "getSecondaryElements()");
        if (singleFile && fileEditor instanceof TextEditor) {
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            editor2.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(primaryElements, secondaryElements, handler2, scopeFile, FileSearchScope.FROM_START, findUsagesOptions.clone(), editor2);
        } else {
            boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
            this.findUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, skipResultsWithOneUsage);
        }
    }

    public static void showSettingsAndFindUsages(NavigationItem @NotNull [] targets2) {
        if (targets2 == null) {
            FindUsagesManager.$$$reportNull$$$0(18);
        }
        if (targets2.length == 0) {
            return;
        }
        NavigationItem target2 = targets2[0];
        if (!(target2 instanceof ConfigurableUsageTarget)) {
            return;
        }
        ((ConfigurableUsageTarget)target2).showSettings();
    }

    private static void checkNotNull(PsiElement @NotNull [] elements, @NotNull FindUsagesHandler handler2, @NonNls @NotNull String methodName) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            FindUsagesManager.$$$reportNull$$$0(20);
        }
        if (elements == null) {
            FindUsagesManager.$$$reportNull$$$0(21);
        }
        for (PsiElement element2 : elements) {
            if (element2 != null) continue;
            LOG.error(handler2 + "." + methodName + " has returned array with null elements: " + Arrays.asList(elements));
        }
    }

    @NotNull
    public static ProgressIndicator startProcessUsages(@NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull Processor<? super Usage> processor2, @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(23);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(24);
        }
        if (onComplete == null) {
            FindUsagesManager.$$$reportNull$$$0(25);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(26);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(27);
        }
        ProgressIndicatorBase indicator2 = new ProgressIndicatorBase();
        FindUsagesManager.startProcessUsages(indicator2, handler2, primaryElements, secondaryElements, processor2, findUsagesOptions, onComplete);
        ProgressIndicatorBase progressIndicatorBase = indicator2;
        if (progressIndicatorBase == null) {
            FindUsagesManager.$$$reportNull$$$0(28);
        }
        return progressIndicatorBase;
    }

    private static void startProcessUsages(@NotNull ProgressIndicator indicator2, @NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull Processor<? super Usage> processor2, @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        if (indicator2 == null) {
            FindUsagesManager.$$$reportNull$$$0(29);
        }
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(30);
        }
        if (processor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(31);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(32);
        }
        if (onComplete == null) {
            FindUsagesManager.$$$reportNull$$$0(33);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(34);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(35);
        }
        FindUsagesManager.startProcessUsages(indicator2, handler2.getProject(), FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, findUsagesOptions), processor2, onComplete);
    }

    @ApiStatus.Internal
    public static UsageSearcher createUsageSearcher(@NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(36);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(37);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(38);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(39);
        }
        return (UsageSearcher)ReadAction.compute(() -> {
            PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements, false);
            PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(secondaryElements, false);
            return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
        });
    }

    public static void startProcessUsages(@NotNull ProgressIndicator indicator2, @NotNull Project project, final @NotNull UsageSearcher usageSearcher, final @NotNull Processor<? super Usage> processor2, @NotNull Runnable onComplete) {
        if (indicator2 == null) {
            FindUsagesManager.$$$reportNull$$$0(40);
        }
        if (project == null) {
            FindUsagesManager.$$$reportNull$$$0(41);
        }
        if (usageSearcher == null) {
            FindUsagesManager.$$$reportNull$$$0(42);
        }
        if (processor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(43);
        }
        if (onComplete == null) {
            FindUsagesManager.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Task.Backgroundable task2 = new Task.Backgroundable(project, FindBundle.message("progress.title.finding.usages", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                usageSearcher.generate(processor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/findUsages/FindUsagesManager$1", "run"));
            }
        };
        ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, indicator2, onComplete);
    }

    @NotNull
    public UsageViewPresentation createPresentation(@NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(45);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(46);
        }
        PsiElement element2 = handler2.getPsiElement();
        LOG.assertTrue(element2.isValid());
        return FindUsagesManager.createPresentation(element2, findUsagesOptions, FindSettings.getInstance().isShowResultsInSeparateView());
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            FindSettings.getInstance().setShowResultsInSeparateView(toOpenInNewTab);
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || FindSettings.getInstance().isShowResultsInSeparateView();
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = UsageViewContentManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    @NotNull
    private static UsageSearcher createUsageSearcher(PsiElement2UsageTargetAdapter @NotNull [] primaryTargets, PsiElement2UsageTargetAdapter @NotNull [] secondaryTargets, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions options2, PsiFile scopeFile) throws PsiInvalidElementAccessException {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(47);
        }
        if (options2 == null) {
            FindUsagesManager.$$$reportNull$$$0(48);
        }
        if (primaryTargets == null) {
            FindUsagesManager.$$$reportNull$$$0(49);
        }
        if (secondaryTargets == null) {
            FindUsagesManager.$$$reportNull$$$0(50);
        }
        ReadAction.run(() -> {
            PsiElement[] primaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            PsiElement[] secondaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements}).forEach(psi -> {
                if (psi == null || !psi.isValid()) {
                    throw new PsiInvalidElementAccessException(psi);
                }
            });
        });
        FindUsagesOptions optionsClone = options2.clone();
        UsageSearcher usageSearcher = processor2 -> {
            Project project = (Project)ReadAction.compute(() -> scopeFile != null ? scopeFile.getProject() : primaryTargets[0].getProject());
            ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
            FindUsagesManager.runUpdate(primaryTargets, indicator2);
            FindUsagesManager.runUpdate(secondaryTargets, indicator2);
            Object[] primaryElements = (PsiElement[])ReadAction.compute(() -> PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets));
            Object[] secondaryElements = (PsiElement[])ReadAction.compute(() -> PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets));
            LOG.assertTrue(indicator2 != null, (Object)"Must run under progress. see ProgressManager.run*");
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).dropResolveCacheRegularly(indicator2);
            if (scopeFile != null) {
                optionsClone.searchScope = new LocalSearchScope((PsiElement)scopeFile);
            }
            CommonProcessors.UniqueProcessor usageInfoProcessor = new CommonProcessors.UniqueProcessor(arg_0 -> FindUsagesManager.lambda$createUsageSearcher$7((PsiElement[])primaryElements, processor2, arg_0));
            PsiElement[] elements = (PsiElement[])ArrayUtil.mergeArrays((Object[])primaryElements, (Object[])secondaryElements, (ArrayFactory)PsiElement.ARRAY_FACTORY);
            optionsClone.fastTrack = new SearchRequestCollector(new SearchSession(elements));
            if (optionsClone.searchScope instanceof GlobalSearchScope) {
                optionsClone.searchScope = optionsClone.searchScope.union((SearchScope)GlobalSearchScope.projectScope((Project)project));
            }
            try {
                for (PsiElement element2 : elements) {
                    if (!handler2.processElementUsages(element2, (Processor<? super UsageInfo>)usageInfoProcessor, optionsClone)) {
                        return;
                    }
                    for (CustomUsageSearcher searcher2 : CustomUsageSearcher.EP_NAME.getExtensionList()) {
                        try {
                            searcher2.processElementUsages(element2, (Processor<? super Usage>)processor2, optionsClone);
                        }
                        catch (IndexNotReadyException e) {
                            DumbService.getInstance((Project)element2.getProject()).showDumbModeNotification(FindBundle.message("notification.find.usages.is.not.available.during.indexing", new Object[0]));
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                PsiSearchHelper.getInstance((Project)project).processRequests(optionsClone.fastTrack, arg_0 -> FindUsagesManager.lambda$createUsageSearcher$9((Processor)usageInfoProcessor, arg_0));
            }
            finally {
                optionsClone.fastTrack = null;
            }
        };
        if (usageSearcher == null) {
            FindUsagesManager.$$$reportNull$$$0(51);
        }
        return usageSearcher;
    }

    private static void runUpdate(PsiElement2UsageTargetAdapter @NotNull [] targets2, @NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            FindUsagesManager.$$$reportNull$$$0(52);
        }
        if (targets2 == null) {
            FindUsagesManager.$$$reportNull$$$0(53);
        }
        for (PsiElement2UsageTargetAdapter target2 : targets2) {
            indicator2.checkCanceled();
            ReadAction.run(() -> target2.update());
        }
    }

    private static PsiElement2UsageTargetAdapter @NotNull [] convertToUsageTargets(@NotNull Iterable<? extends PsiElement> elementsToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementsToSearch == null) {
            FindUsagesManager.$$$reportNull$$$0(54);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(55);
        }
        List targets2 = ContainerUtil.map(elementsToSearch, element2 -> FindUsagesManager.convertToUsageTarget(element2, findUsagesOptions));
        PsiElement2UsageTargetAdapter[] psiElement2UsageTargetAdapterArray = targets2.toArray(new PsiElement2UsageTargetAdapter[0]);
        if (psiElement2UsageTargetAdapterArray == null) {
            FindUsagesManager.$$$reportNull$$$0(56);
        }
        return psiElement2UsageTargetAdapterArray;
    }

    public void findUsages(PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(57);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(58);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(59);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(60);
        }
        this.doFindUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, toSkipUsagePanelWhenOneUsage);
    }

    public UsageView doFindUsages(PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(61);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(62);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(63);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(64);
        }
        if (primaryElements.length == 0) {
            throw new AssertionError((Object)(handler2 + " " + findUsagesOptions));
        }
        Object[] primaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(primaryElements), findUsagesOptions);
        Object[] secondaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(secondaryElements), findUsagesOptions);
        PsiElement2UsageTargetAdapter[] targets2 = (PsiElement2UsageTargetAdapter[])ArrayUtil.mergeArrays((Object[])primaryTargets, (Object[])secondaryTargets);
        Factory factory2 = () -> FindUsagesManager.lambda$doFindUsages$13((PsiElement2UsageTargetAdapter[])primaryTargets, (PsiElement2UsageTargetAdapter[])secondaryTargets, handler2, findUsagesOptions);
        UsageView usageView = UsageViewManager.getInstance((Project)this.myProject).searchAndShowUsages((UsageTarget[])targets2, factory2, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation(primaryElements[0], findUsagesOptions, this.shouldOpenInNewTab()), null);
        this.myHistory.add(targets2[0]);
        return usageView;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions options2, boolean toOpenInNewTab) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(65);
        }
        if (options2 == null) {
            FindUsagesManager.$$$reportNull$$$0(66);
        }
        String usagesString = options2.generateUsagesString();
        String longName = UsageViewUtil.getLongName(psiElement);
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        String scopeString = options2.searchScope.getDisplayName();
        presentation2.setCodeUsagesString(options2.generateUsagesString());
        presentation2.setScopeText(scopeString);
        presentation2.setSearchString(FindBundle.message("find.usages.of.element.tab.name", usagesString, longName));
        presentation2.setTabText(FindBundle.message("find.usages.of.element.in.scope.panel.title", longName, scopeString));
        presentation2.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation2.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation2.setOpenInNewTab(toOpenInNewTab);
        UsageViewPresentation usageViewPresentation = presentation2;
        if (usageViewPresentation == null) {
            FindUsagesManager.$$$reportNull$$$0(67);
        }
        return usageViewPresentation;
    }

    private void findUsagesInEditor(final PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandler handler2, final @NotNull PsiFile scopeFile, final @NotNull FileSearchScope direction, @NotNull FindUsagesOptions findUsagesOptions, final @NotNull Editor editor2) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(68);
        }
        if (scopeFile == null) {
            FindUsagesManager.$$$reportNull$$$0(69);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(70);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(71);
        }
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(72);
        }
        if (primaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(73);
        }
        if (secondaryElements == null) {
            FindUsagesManager.$$$reportNull$$$0(74);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.initLastSearchElement(findUsagesOptions, primaryElements, secondaryElements);
        this.clearStatusBar();
        PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements, false);
        PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements, false);
        final UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, scopeFile);
        final AtomicBoolean usagesWereFound = new AtomicBoolean();
        final int startOffset = editor2.getCaretModel().getOffset();
        new Task.Backgroundable(this.myProject, FindBundle.message("find.progress.searching.message", "editor")){
            private Usage myUsage;

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myUsage = FindUsagesManager.findSiblingUsage(usageSearcher, direction, startOffset, usagesWereFound, editor2);
            }

            public void onFinished() {
                if (FindUsagesManager.this.myProject.isDisposed() || editor2.isDisposed()) {
                    return;
                }
                if (this.myUsage != null) {
                    this.myUsage.navigate(true);
                    this.myUsage.selectInEditor();
                } else if (!usagesWereFound.get()) {
                    String message2 = FindUsagesManager.getNoUsagesFoundMessage(primaryElements[0], scopeFile.getName());
                    FindUsagesManager.showEditorHint(message2, editor2);
                } else {
                    editor2.putUserData(KEY_START_USAGE_AGAIN, (Object)FindUsagesManager.VALUE_START_USAGE_AGAIN);
                    FindUsagesManager.showEditorHint(FindUsagesManager.getSearchAgainMessage(primaryElements[0], direction), editor2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/findUsages/FindUsagesManager$2", "run"));
            }
        }.queue();
    }

    @NotNull
    @NlsContexts.HintText
    private static String getNoUsagesFoundMessage(@NotNull PsiElement psiElement, @NotNull String fileName) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(75);
        }
        if (fileName == null) {
            FindUsagesManager.$$$reportNull$$$0(76);
        }
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        String string = FindBundle.message("find.usages.of.element_type.element_name.not.found.in.scope.message", elementType, elementName, fileName);
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    @NlsContexts.HintText
    private static String getNoUsagesFoundMessage(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            FindUsagesManager.$$$reportNull$$$0(78);
        }
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        String string = FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(79);
        }
        return string;
    }

    private void clearStatusBar() {
        StatusBar.Info.set((String)"", (Project)this.myProject);
    }

    @NotNull
    @NlsContexts.HintText
    private static String getSearchAgainMessage(@NotNull PsiElement element2, @NotNull FileSearchScope direction) {
        String shortcutsText;
        AnAction action2;
        String shortcutsText2;
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(80);
        }
        if (direction == null) {
            FindUsagesManager.$$$reportNull$$$0(81);
        }
        String message2 = FindUsagesManager.getNoUsagesFoundMessage(element2);
        message2 = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message2) : FindBundle.message("find.search.again.from.top.hotkey.message", message2, shortcutsText2)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message2) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message2, shortcutsText));
        String string = message2;
        if (string == null) {
            FindUsagesManager.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static Usage findSiblingUsage(@NotNull UsageSearcher usageSearcher, @NotNull FileSearchScope dir, int startOffset, @NotNull AtomicBoolean usagesWereFound, @NotNull Editor editor2) {
        if (usageSearcher == null) {
            FindUsagesManager.$$$reportNull$$$0(83);
        }
        if (dir == null) {
            FindUsagesManager.$$$reportNull$$$0(84);
        }
        if (usagesWereFound == null) {
            FindUsagesManager.$$$reportNull$$$0(85);
        }
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(86);
        }
        if (editor2.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        FileSearchScope direction = dir;
        AtomicReference foundUsage = new AtomicReference();
        usageSearcher.generate(usage -> {
            usagesWereFound.set(true);
            int usageOffset = usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getNavigationRange().getStartOffset() : 0;
            switch (direction) {
                case FROM_START: {
                    foundUsage.compareAndSet(null, usage);
                    return false;
                }
                case FROM_END: {
                    foundUsage.set(usage);
                    break;
                }
                case AFTER_CARET: {
                    if (usageOffset <= startOffset) break;
                    foundUsage.set(usage);
                    return false;
                }
                case BEFORE_CARET: {
                    int foundOffset;
                    Usage found;
                    if (usageOffset >= startOffset) {
                        return false;
                    }
                    while (!((found = (Usage)foundUsage.get()) == null ? foundUsage.compareAndSet(null, usage) : (foundOffset = found instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)found).getNavigationRange().getStartOffset() : 0) < usageOffset && foundUsage.compareAndSet(found, usage))) {
                    }
                    break;
                }
            }
            return true;
        });
        editor2.putUserData(KEY_START_USAGE_AGAIN, null);
        return (Usage)foundUsage.get();
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter convertToUsageTarget(@NotNull PsiElement elementToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementToSearch == null) {
            FindUsagesManager.$$$reportNull$$$0(87);
        }
        if (findUsagesOptions == null) {
            FindUsagesManager.$$$reportNull$$$0(88);
        }
        if (elementToSearch instanceof NavigationItem) {
            return new PsiElement2UsageTargetAdapter(elementToSearch, findUsagesOptions, false);
        }
        throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
    }

    private static void showEditorHint(@NotNull @NlsContexts.HintText String message2, @NotNull Editor editor2) {
        if (message2 == null) {
            FindUsagesManager.$$$reportNull$$$0(89);
        }
        if (editor2 == null) {
            FindUsagesManager.$$$reportNull$$$0(90);
        }
        JComponent component2 = HintUtil.createInformationLabel(message2);
        LightweightHint hint = new LightweightHint(component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, 42, 0, false);
    }

    public static String getHelpID(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesManager.$$$reportNull$$$0(91);
        }
        return LanguageFindUsages.getHelpId((PsiElement)element2);
    }

    public void rerunAndRecallFromHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            FindUsagesManager.$$$reportNull$$$0(92);
        }
        usageTarget.findUsages();
        this.addToHistory(usageTarget);
    }

    public void addToHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            FindUsagesManager.$$$reportNull$$$0(93);
        }
        this.myHistory.add(usageTarget);
    }

    @NotNull
    public UsageHistory getHistory() {
        UsageHistory usageHistory = this.myHistory;
        if (usageHistory == null) {
            FindUsagesManager.$$$reportNull$$$0(94);
        }
        return usageHistory;
    }

    @NotNull
    public static GlobalSearchScope getMaximalScope(@NotNull FindUsagesHandlerBase handler2) {
        if (handler2 == null) {
            FindUsagesManager.$$$reportNull$$$0(95);
        }
        PsiElement element2 = handler2.getPsiElement();
        Project project = element2.getProject();
        PsiFile file2 = element2.getContainingFile();
        if (file2 != null && ProjectFileIndex.SERVICE.getInstance((Project)project).isInContent(file2.getViewProvider().getVirtualFile())) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            if (globalSearchScope == null) {
                FindUsagesManager.$$$reportNull$$$0(96);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        if (globalSearchScope == null) {
            FindUsagesManager.$$$reportNull$$$0(97);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ UsageSearcher lambda$doFindUsages$13(PsiElement2UsageTargetAdapter[] primaryTargets, PsiElement2UsageTargetAdapter[] secondaryTargets, FindUsagesHandlerBase handler2, FindUsagesOptions findUsagesOptions) {
        return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
    }

    private static /* synthetic */ boolean lambda$createUsageSearcher$9(Processor usageInfoProcessor, PsiReference ref) {
        UsageInfo info2 = (UsageInfo)ReadAction.compute(() -> {
            if (!ref.getElement().isValid()) {
                return null;
            }
            return new UsageInfo(ref);
        });
        return info2 == null || usageInfoProcessor.process((Object)info2);
    }

    private static /* synthetic */ boolean lambda$createUsageSearcher$7(PsiElement[] primaryElements, Processor processor2, UsageInfo usageInfo) {
        Usage usage = (Usage)ReadAction.compute(() -> UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo)usageInfo));
        return processor2.process((Object)usage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 51: 
            case 56: 
            case 67: 
            case 77: 
            case 79: 
            case 82: 
            case 94: 
            case 96: 
            case 97: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 51: 
            case 56: 
            case 67: 
            case 77: 
            case 79: 
            case 82: 
            case 94: 
            case 96: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 80: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 72: 
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 70: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 6: 
            case 15: 
            case 16: 
            case 24: 
            case 32: 
            case 37: 
            case 46: 
            case 55: 
            case 58: 
            case 62: 
            case 71: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesOptions";
                break;
            }
            case 7: 
            case 26: 
            case 34: 
            case 38: 
            case 59: 
            case 63: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 8: 
            case 27: 
            case 35: 
            case 39: 
            case 60: 
            case 64: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationMode";
                break;
            }
            case 13: 
            case 14: 
            case 65: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 30: 
            case 36: 
            case 45: 
            case 47: 
            case 57: 
            case 61: 
            case 68: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: 
            case 31: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 25: 
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onComplete";
                break;
            }
            case 28: 
            case 51: 
            case 56: 
            case 67: 
            case 77: 
            case 79: 
            case 82: 
            case 94: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesManager";
                break;
            }
            case 29: 
            case 40: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 42: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageSearcher";
                break;
            }
            case 48: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryTargets";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryTargets";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSearch";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesWereFound";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesManager";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessUsages";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageSearcher";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToUsageTargets";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 77: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoUsagesFoundMessage";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchAgainMessage";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaximalScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findNextUsageInFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousUsageInFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsageInFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initLastSearchElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNewFindUsagesHandler";
                break;
            }
            case 13: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsAndFindUsages";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNull";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "startProcessUsages";
                break;
            }
            case 28: 
            case 51: 
            case 56: 
            case 67: 
            case 77: 
            case 79: 
            case 82: 
            case 94: 
            case 96: 
            case 97: {
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createUsageSearcher";
                break;
            }
            case 45: 
            case 46: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "runUpdate";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "convertToUsageTargets";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "doFindUsages";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 75: 
            case 76: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getNoUsagesFoundMessage";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getSearchAgainMessage";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingUsage";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "convertToUsageTarget";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "showEditorHint";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getHelpID";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "rerunAndRecallFromHistory";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getMaximalScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 51: 
            case 56: 
            case 67: 
            case 77: 
            case 79: 
            case 82: 
            case 94: 
            case 96: 
            case 97: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

