/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.impl.FindInProjectSettingsBase;
import com.intellij.find.impl.FindSettingsImpl;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class LangFindSettingsImpl
extends FindSettingsImpl {
    LangFindSettingsImpl() {
    }

    public void noStateLoaded() {
        Collection extensions2 = IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages().stream().map(Language::getAssociatedFileType).filter(Objects::nonNull).flatMap(fileType -> Stream.concat(Stream.of(fileType.getDefaultExtension()), LangFindSettingsImpl.getAssociatedExtensions(fileType))).collect(Collectors.toCollection(LinkedHashSet::new));
        if (extensions2.contains("java")) {
            extensions2.add("properties");
            extensions2.add("jsp");
        }
        if (!extensions2.contains("sql")) {
            extensions2.add("xml");
            extensions2.add("html");
            extensions2.add("css");
        }
        String[] extensionsArray = ArrayUtil.toStringArray((Collection)extensions2);
        for (int i2 = extensionsArray.length - 1; i2 >= 0; --i2) {
            FindInProjectSettingsBase.addRecentStringToList("*." + extensionsArray[i2], this.recentFileMasks);
        }
    }

    @NotNull
    private static Stream<String> getAssociatedExtensions(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            LangFindSettingsImpl.$$$reportNull$$$0(0);
        }
        Stream<String> stream = FileTypeManager.getInstance().getAssociations((FileType)fileType).stream().filter(ExtensionFileNameMatcher.class::isInstance).map(ExtensionFileNameMatcher.class::cast).map(ExtensionFileNameMatcher::getExtension);
        if (stream == null) {
            LangFindSettingsImpl.$$$reportNull$$$0(1);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/LangFindSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/LangFindSettingsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

