/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FormatterTagHandler {
    private final CodeStyleSettings mySettings;

    public FormatterTagHandler(CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    protected FormatterTag getFormatterTag(@NotNull PsiComment comment) {
        if (comment == null) {
            FormatterTagHandler.$$$reportNull$$$0(0);
        }
        CharSequence nodeChars = comment.getNode().getChars();
        return this.extractFormatterTag(nodeChars, 0, nodeChars.length());
    }

    private FormatterTag extractFormatterTag(@NotNull CharSequence chars, int startOffset, int endOffset) {
        if (chars == null) {
            FormatterTagHandler.$$$reportNull$$$0(1);
        }
        if (this.mySettings.FORMATTER_TAGS_ACCEPT_REGEXP) {
            Pattern onPattern = this.mySettings.getFormatterOnPattern();
            Pattern offPattern = this.mySettings.getFormatterOffPattern();
            if (onPattern != null && onPattern.matcher(chars.subSequence(startOffset, endOffset)).find()) {
                return FormatterTag.ON;
            }
            if (offPattern != null && offPattern.matcher(chars.subSequence(startOffset, endOffset)).find()) {
                return FormatterTag.OFF;
            }
        } else {
            for (int i2 = startOffset; i2 < endOffset; ++i2) {
                if (FormatterTagHandler.isFormatterTagAt(chars, i2, this.mySettings.FORMATTER_ON_TAG)) {
                    return FormatterTag.ON;
                }
                if (!FormatterTagHandler.isFormatterTagAt(chars, i2, this.mySettings.FORMATTER_OFF_TAG)) continue;
                return FormatterTag.OFF;
            }
        }
        return FormatterTag.NONE;
    }

    private static boolean isFormatterTagAt(@NotNull CharSequence s, int pos, @NotNull String tagName) {
        int end;
        if (s == null) {
            FormatterTagHandler.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            FormatterTagHandler.$$$reportNull$$$0(3);
        }
        if (!tagName.isEmpty() && tagName.charAt(0) == s.charAt(pos) && (end = pos + tagName.length()) <= s.length()) {
            return StringUtil.equalsIgnoreCase((CharSequence)s.subSequence(pos, end), (CharSequence)tagName);
        }
        return false;
    }

    public List<TextRange> getEnabledRanges(ASTNode rootNode, TextRange initialRange) {
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            return Collections.singletonList(initialRange);
        }
        EnabledRangesCollector collector = new EnabledRangesCollector(initialRange);
        collector.processText(rootNode.getChars());
        return collector.getRanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatterTagHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatterTag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFormatterTag";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormatterTagAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class EnabledRangesCollector {
        private final List<FormatterTagInfo> myTagInfoList = new ArrayList<FormatterTagInfo>();
        private final TextRange myInitialRange;

        private EnabledRangesCollector(TextRange initialRange) {
            this.myInitialRange = initialRange;
        }

        private void processText(@NotNull CharSequence chars) {
            if (chars == null) {
                EnabledRangesCollector.$$$reportNull$$$0(0);
            }
            int lineStart = 0;
            for (int currPos = 0; currPos < chars.length(); ++currPos) {
                char c = chars.charAt(currPos);
                if (c != '\n') continue;
                FormatterTag formatterTag = FormatterTagHandler.this.extractFormatterTag(chars, lineStart, currPos);
                switch (formatterTag) {
                    case OFF: {
                        this.myTagInfoList.add(new FormatterTagInfo(lineStart, FormatterTag.OFF));
                        break;
                    }
                    case ON: {
                        this.myTagInfoList.add(new FormatterTagInfo(lineStart, FormatterTag.ON));
                    }
                }
                lineStart = currPos + 1;
            }
        }

        private List<TextRange> getRanges() {
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            this.myTagInfoList.sort(Comparator.comparingInt(info2 -> info2.offset));
            int start2 = this.myInitialRange.getStartOffset();
            boolean formatterEnabled = true;
            for (FormatterTagInfo tagInfo : this.myTagInfoList) {
                if (tagInfo.tag == FormatterTag.OFF && formatterEnabled) {
                    if (tagInfo.offset > start2) {
                        TextRange range2 = new TextRange(start2, tagInfo.offset);
                        enabledRanges.add(range2);
                    }
                    formatterEnabled = false;
                    continue;
                }
                if (tagInfo.tag != FormatterTag.ON || formatterEnabled) continue;
                start2 = Math.max(tagInfo.offset, this.myInitialRange.getStartOffset());
                if (start2 >= this.myInitialRange.getEndOffset()) break;
                formatterEnabled = true;
            }
            if (start2 < this.myInitialRange.getEndOffset() && formatterEnabled) {
                enabledRanges.add(new TextRange(start2, this.myInitialRange.getEndOffset()));
            }
            return enabledRanges;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/formatting/FormatterTagHandler$EnabledRangesCollector", "processText"));
        }

        private final class FormatterTagInfo {
            public int offset;
            public FormatterTag tag;

            private FormatterTagInfo(int offset, FormatterTag tag2) {
                this.offset = offset;
                this.tag = tag2;
            }
        }
    }

    public static enum FormatterTag {
        ON,
        OFF,
        NONE;

    }
}

