/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.util.TextRange;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;

public final class BlockRangesMap {
    private final LeafBlockWrapper myLastBlock;
    private final Int2ObjectMap<LeafBlockWrapper> myTextRangeToWrapper;

    public BlockRangesMap(LeafBlockWrapper first, LeafBlockWrapper last) {
        this.myLastBlock = last;
        this.myTextRangeToWrapper = BlockRangesMap.buildTextRangeToInfoMap(first);
    }

    private static Int2ObjectMap<LeafBlockWrapper> buildTextRangeToInfoMap(LeafBlockWrapper first) {
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        for (LeafBlockWrapper current2 = first; current2 != null; current2 = current2.getNextBlock()) {
            result2.put(current2.getStartOffset(), (Object)current2);
        }
        return result2;
    }

    public boolean containsLineFeedsOrTooLong(TextRange dependency) {
        LeafBlockWrapper child2 = (LeafBlockWrapper)this.myTextRangeToWrapper.get(dependency.getStartOffset());
        if (child2 == null) {
            return false;
        }
        int endOffset = dependency.getEndOffset();
        int startOffset = child2.getStartOffset();
        while (child2 != null && child2.getEndOffset() < endOffset) {
            if (child2.containsLineFeeds() || child2.getStartOffset() - startOffset > 1000) {
                return true;
            }
            if ((child2 = child2.getNextBlock()) == null || child2.getWhiteSpace().getEndOffset() > endOffset || !child2.getWhiteSpace().containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LeafBlockWrapper getBlockAtOrAfter(int startOffset) {
        LeafBlockWrapper prevBlock;
        LeafBlockWrapper result2 = null;
        for (int current2 = startOffset; current2 < this.myLastBlock.getEndOffset(); ++current2) {
            LeafBlockWrapper currentValue = (LeafBlockWrapper)this.myTextRangeToWrapper.get(current2);
            if (currentValue == null) continue;
            result2 = currentValue;
            break;
        }
        if ((prevBlock = this.getPrevBlock(result2)) != null && prevBlock.contains(startOffset)) {
            return prevBlock;
        }
        return result2;
    }

    @Nullable
    private LeafBlockWrapper getPrevBlock(@Nullable LeafBlockWrapper result2) {
        if (result2 != null) {
            return result2.getPreviousBlock();
        }
        return this.myLastBlock;
    }
}

