/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class DependentSpacingEngine {
    private final BlockRangesMap myBlockRangesMap;
    private final SortedMap<TextRange, DependantSpacingImpl> myPreviousDependencies = new TreeMap<TextRange, DependantSpacingImpl>((o1, o2) -> {
        int offsetsDelta = o1.getEndOffset() - o2.getEndOffset();
        if (offsetsDelta == 0) {
            offsetsDelta = o2.getStartOffset() - o1.getStartOffset();
        }
        return offsetsDelta;
    });

    DependentSpacingEngine(BlockRangesMap helper2) {
        this.myBlockRangesMap = helper2;
    }

    boolean shouldReformatPreviouslyLocatedDependentSpacing(WhiteSpace space) {
        TextRange changed2 = space.getTextRange();
        SortedMap<TextRange, DependantSpacingImpl> sortedHeadMap = this.myPreviousDependencies.tailMap(changed2);
        for (Map.Entry<TextRange, DependantSpacingImpl> entry2 : sortedHeadMap.entrySet()) {
            boolean containsLineFeeds;
            boolean containedLineFeeds;
            DependantSpacingImpl spacing;
            TextRange textRange = entry2.getKey();
            if (!textRange.contains(changed2) || (spacing = entry2.getValue()).isDependentRegionLinefeedStatusChanged() || (containedLineFeeds = spacing.getMinLineFeeds() > 0) == (containsLineFeeds = this.myBlockRangesMap.containsLineFeedsOrTooLong(textRange))) continue;
            spacing.setDependentRegionLinefeedStatusChanged();
            return true;
        }
        return false;
    }

    void registerUnresolvedDependentSpacingRanges(SpacingImpl spaceProperty, List<? extends TextRange> unprocessedRanges) {
        DependantSpacingImpl dependantSpaceProperty = (DependantSpacingImpl)spaceProperty;
        if (dependantSpaceProperty.isDependentRegionLinefeedStatusChanged()) {
            return;
        }
        for (TextRange textRange : unprocessedRanges) {
            this.myPreviousDependencies.put(textRange, dependantSpaceProperty);
        }
    }

    void clear() {
        this.myPreviousDependencies.clear();
    }
}

