/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CoreFormattingService
implements FormattingService {
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.of(FormattingService.Feature.AD_HOC_FORMATTING, FormattingService.Feature.FORMAT_FRAGMENTS, FormattingService.Feature.OPTIMIZE_IMPORTS);

    public boolean canFormat(@NotNull PsiFile file2) {
        if (file2 == null) {
            CoreFormattingService.$$$reportNull$$$0(0);
        }
        return true;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set2 = FEATURES;
        if (set2 == null) {
            CoreFormattingService.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element2, boolean canChangeWhiteSpacesOnly) {
        if (element2 == null) {
            CoreFormattingService.$$$reportNull$$$0(2);
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        PsiElement formatted = new CodeFormatterFacade(CoreFormattingService.getSettings(file2), element2.getLanguage(), canChangeWhiteSpacesOnly).processElement(treeElement).getPsi();
        if (!canChangeWhiteSpacesOnly) {
            PsiElement psiElement = CoreCodeStyleUtil.postProcessElement(file2, formatted);
            if (psiElement == null) {
                CoreFormattingService.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement psiElement = formatted;
        if (psiElement == null) {
            CoreFormattingService.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element2, @NotNull TextRange range2, boolean canChangeWhiteSpacesOnly) {
        if (element2 == null) {
            CoreFormattingService.$$$reportNull$$$0(5);
        }
        if (range2 == null) {
            CoreFormattingService.$$$reportNull$$$0(6);
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CoreFormattingService.getSettings(file2), element2.getLanguage());
        PsiElement formatted = codeFormatter.processRange(treeElement, range2.getStartOffset(), range2.getEndOffset()).getPsi();
        PsiElement psiElement = canChangeWhiteSpacesOnly ? formatted : CoreCodeStyleUtil.postProcessElement(file2, formatted);
        if (psiElement == null) {
            CoreFormattingService.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    public void formatRanges(@NotNull PsiFile file2, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file2 == null) {
            CoreFormattingService.$$$reportNull$$$0(8);
        }
        List<CoreCodeStyleUtil.RangeFormatInfo> infos = canChangeWhiteSpaceOnly ? null : CoreCodeStyleUtil.getRangeFormatInfoList(file2, rangesInfo);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CoreFormattingService.getSettings(file2), file2.getLanguage());
        codeFormatter.processText(file2, (FormatTextRanges)rangesInfo, !canChangeWhiteSpaceOnly);
        if (infos != null) {
            CoreCodeStyleUtil.postProcessRanges(file2, infos, range2 -> CoreCodeStyleUtil.postProcessText(file2, range2));
        }
    }

    @NotNull
    public Set<ImportOptimizer> getImportOptimizers(@NotNull PsiFile file2) {
        if (file2 == null) {
            CoreFormattingService.$$$reportNull$$$0(9);
        }
        Set<ImportOptimizer> set2 = LanguageImportStatements.INSTANCE.forFile(file2);
        if (set2 == null) {
            CoreFormattingService.$$$reportNull$$$0(10);
        }
        return set2;
    }

    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CoreFormattingService.$$$reportNull$$$0(11);
        }
        return CodeStyle.getSettings((PsiFile)file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/CoreFormattingService";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/CoreFormattingService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptimizers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptimizers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

