/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Paths {
    public static final char DELIM = '/';
    private static boolean myIsCaseSensitive;

    public static String getNameOf(String path2) {
        int i2 = path2.lastIndexOf(47);
        if (i2 == -1 || path2.length() == 1) {
            return path2;
        }
        return path2.substring(i2 + 1);
    }

    public static String getParentOf(String path2) {
        int i2 = path2.lastIndexOf(47);
        if (i2 == -1) {
            return "";
        }
        if (i2 == 0) {
            i2 = 1;
        }
        return path2.substring(0, i2);
    }

    public static String appended(String path2, String child2) {
        path2 = Paths.appendParent(path2);
        return path2 + child2;
    }

    public static String renamed(String path2, String newName2) {
        return Paths.appended(Paths.getParentOf(path2), newName2);
    }

    public static String reparented(String path2, String newParentPath) {
        return Paths.appended(newParentPath, Paths.getNameOf(path2));
    }

    public static String relativeIfUnder(String path2, String root2) {
        if (!Paths.isParent(root2, path2)) {
            return null;
        }
        if ((path2 = path2.substring(root2.length())).length() == 0) {
            return "";
        }
        if (path2.charAt(0) != '/') {
            return null;
        }
        return path2.substring(1);
    }

    public static Iterable<String> split(String path2) {
        String root2 = FileUtil.extractRootPath((String)path2);
        if (root2 == null) {
            return Paths.splitInner(path2);
        }
        if (root2.length() + 1 == path2.length() && path2.endsWith(":///")) {
            return Collections.singleton(root2);
        }
        List<String> tail = Paths.splitInner(path2.substring(root2.length()));
        return ContainerUtil.concat(Collections.singleton(root2), tail);
    }

    @NotNull
    private static List<String> splitInner(String path2) {
        if (path2.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                Paths.$$$reportNull$$$0(0);
            }
            return list2;
        }
        int s = 0;
        int e = path2.length();
        if (path2.charAt(0) == '/') {
            ++s;
        }
        if (e > s && path2.charAt(e - 1) == '/') {
            --e;
        }
        List list3 = StringUtil.split((String)path2.substring(s, e), (String)String.valueOf('/'), (boolean)true, (boolean)false);
        if (list3 == null) {
            Paths.$$$reportNull$$$0(1);
        }
        return list3;
    }

    public static boolean isParent(String parent, String path2) {
        if (Paths.equals(parent, path2)) {
            return true;
        }
        parent = Paths.appendParent(parent);
        return myIsCaseSensitive ? path2.startsWith(parent) : StringUtil.startsWithIgnoreCase((String)path2, (String)parent);
    }

    private static String appendParent(String parent) {
        if (((String)parent).isEmpty()) {
            return parent;
        }
        if (((String)parent).charAt(((String)parent).length() - 1) != '/') {
            parent = (String)parent + "/";
        }
        return parent;
    }

    public static boolean isParentOrChild(String p1, String p2) {
        return Paths.isParent(p1, p2) || Paths.isParent(p2, p1);
    }

    public static boolean equals(String p1, String p2) {
        return myIsCaseSensitive ? p1.equals(p2) : p1.equalsIgnoreCase(p2);
    }

    public static void setCaseSensitive(boolean b) {
        myIsCaseSensitive = b;
    }

    public static boolean isCaseSensitive() {
        return myIsCaseSensitive;
    }

    public static void useSystemCaseSensitivity() {
        myIsCaseSensitive = SystemInfo.isFileSystemCaseSensitive;
    }

    static {
        Paths.useSystemCaseSensitivity();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/Paths", "splitInner"));
    }
}

