/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ContentChange
extends StructuralChange {
    private final Content myOldContent;
    private final long myOldTimestamp;

    public ContentChange(long id2, String path2, Content oldContent, long oldTimestamp) {
        super(id2, path2);
        this.myOldContent = oldContent;
        this.myOldTimestamp = oldTimestamp;
    }

    public ContentChange(DataInput in) throws IOException {
        super(in);
        this.myOldContent = new StoredContent(in);
        this.myOldTimestamp = DataInputOutputUtil.readTIME((DataInput)in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.myOldContent.write(out);
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)this.myOldTimestamp);
    }

    public Content getOldContent() {
        return this.myOldContent;
    }

    public long getOldTimestamp() {
        return this.myOldTimestamp;
    }

    @Override
    public void revertOn(RootEntry root2, boolean warnOnFileNotFound) {
        Entry e = root2.findEntry(this.myPath);
        if (e == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        e.setContent(this.myOldContent, this.myOldTimestamp);
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.singletonList(this.myOldContent);
    }

    @Override
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

