/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.diff.DiffDialogHints;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.views.DirectoryChange;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DirectoryHistoryDialog
extends HistoryDialog<DirectoryHistoryDialogModel> {
    private ChangesTreeImpl<Change> myChangesTree;
    private JScrollPane myChangesTreeScrollPane;
    private ActionToolbar myToolBar;

    public DirectoryHistoryDialog(Project p, IdeaGateway gw, VirtualFile f) {
        this(p, gw, f, true);
    }

    protected DirectoryHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f, boolean doInit2) {
        if (p == null) {
            DirectoryHistoryDialog.$$$reportNull$$$0(0);
        }
        super(p, gw, f, doInit2);
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new DirectoryHistoryDialogModel(this.myProject, this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Pair<JComponent, Dimension> createDiffPanel(JPanel root2, ExcludingTraversalPolicy traversalPolicy) {
        this.initChangesTree(root2);
        JPanel p = new JPanel(new BorderLayout());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("DirectoryHistoryDiffPanel", this.createChangesTreeActions(), true);
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(this.myToolBar, this.myChangesTree);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)toolbarPanel, "Center");
        if (this.showSearchField()) {
            SearchTextField search2 = this.createSearchBox(root2);
            topPanel.add((Component)search2, "East");
            traversalPolicy.exclude((Component)search2.getTextEditor());
        }
        p.add((Component)topPanel, "North");
        this.myChangesTreeScrollPane = ScrollPaneFactory.createScrollPane(this.myChangesTree);
        p.add((Component)this.myChangesTreeScrollPane, "Center");
        return Pair.create((Object)p, (Object)topPanel.getPreferredSize());
    }

    protected boolean showSearchField() {
        return true;
    }

    @Override
    protected void setDiffBorder(Border border) {
        this.myChangesTreeScrollPane.setBorder(border);
    }

    private SearchTextField createSearchBox(JPanel root2) {
        final SearchTextField field = new SearchTextField(this.getDimensionKey() + ".searchHistory");
        field.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryHistoryDialog.this.scheduleRevisionsUpdate(m -> {
                    m.setFilter(field.getText());
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!DirectoryHistoryDialog.this.isDisposed()) {
                            field.addCurrentTextToHistory();
                        }
                    });
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/DirectoryHistoryDialog$1", "textChanged"));
            }
        });
        DumbAwareAction.create(e -> field.requestFocusInWindow()).registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)root2, (Disposable)this);
        return field;
    }

    private void initChangesTree(JComponent root2) {
        this.myChangesTree = new ChangesTreeImpl.Changes(this.myProject, false, false);
        this.myChangesTree.setDoubleClickAndEnterKeyHandler(() -> new ShowDifferenceAction().performIfEnabled());
        new ShowDifferenceAction().registerCustomShortcutSet(root2, null);
        this.myChangesTree.installPopupHandler(this.createChangesTreeActions());
    }

    private ActionGroup createChangesTreeActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.add((AnAction)new ShowDifferenceAction());
        result2.add((AnAction)new RevertSelectionAction());
        result2.add((AnAction)Separator.getInstance());
        result2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        return result2;
    }

    @Override
    protected void updateActions() {
        super.updateActions();
        this.myToolBar.updateActionsImmediately();
    }

    @Override
    protected Runnable doUpdateDiffs(DirectoryHistoryDialogModel model2) {
        List<Change> changes = model2.getChanges();
        return () -> this.myChangesTree.setChangesToDisplay(changes);
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.localHistory.show.folder";
    }

    private List<DirectoryChange> getChanges() {
        return this.myChangesTree.getChanges();
    }

    private List<DirectoryChange> getSelectedChanges() {
        return this.myChangesTree.getSelectedChanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/history/integration/ui/views/DirectoryHistoryDialog", "<init>"));
    }

    private abstract class ActionOnSelection
    extends HistoryDialog.MyAction {
        ActionOnSelection(String name2, Icon icon2) {
            super(name2, null, icon2);
        }

        protected void doPerform(DirectoryHistoryDialogModel model2) {
            this.doPerform(model2, DirectoryHistoryDialog.this.getSelectedChanges());
        }

        protected abstract void doPerform(DirectoryHistoryDialogModel var1, List<? extends DirectoryChange> var2);

        protected boolean isEnabled(DirectoryHistoryDialogModel model2) {
            List<DirectoryChange> changes = DirectoryHistoryDialog.this.getSelectedChanges();
            if (changes.isEmpty()) {
                return false;
            }
            return this.isEnabledFor(model2, changes);
        }

        protected boolean isEnabledFor(DirectoryHistoryDialogModel model2, List<? extends DirectoryChange> changes) {
            return true;
        }
    }

    private class RevertSelectionAction
    extends ActionOnSelection {
        RevertSelectionAction() {
            super(LocalHistoryBundle.message("action.revert.selection", new Object[0]), AllIcons.Actions.Rollback);
        }

        @Override
        protected void doPerform(DirectoryHistoryDialogModel model2, List<? extends DirectoryChange> selected2) {
            ArrayList<Difference> diffs = new ArrayList<Difference>();
            for (DirectoryChange directoryChange : selected2) {
                diffs.add(directoryChange.getModel().getDifference());
            }
            DirectoryHistoryDialog.this.revert(model2.createRevisionReverter(diffs));
        }

        @Override
        protected boolean isEnabledFor(DirectoryHistoryDialogModel model2, List<? extends DirectoryChange> changes) {
            return model2.isRevertEnabled();
        }
    }

    private class ShowDifferenceAction
    extends ActionOnSelection {
        ShowDifferenceAction() {
            super(LocalHistoryBundle.message("action.show.difference", new Object[0]), AllIcons.Actions.Diff);
            this.setShortcutSet(CommonShortcuts.getDiff());
        }

        @Override
        protected void doPerform(DirectoryHistoryDialogModel model2, List<? extends DirectoryChange> selected2) {
            HashSet<? extends DirectoryChange> selectedSet = new HashSet<DirectoryChange>(selected2);
            int index2 = 0;
            ArrayList<DirectoryChange> changes = new ArrayList<DirectoryChange>();
            for (DirectoryChange change : this.iterFileChanges()) {
                if (selectedSet.contains((Object)change)) {
                    index2 = changes.size();
                }
                changes.add(change);
            }
            ShowDiffAction.showDiffForChange(DirectoryHistoryDialog.this.myProject, changes, index2, new ShowDiffContext(DiffDialogHints.FRAME));
        }

        private Iterable<DirectoryChange> iterFileChanges() {
            return ContainerUtil.iterate(DirectoryHistoryDialog.this.getChanges(), each -> each.canShowFileDifference());
        }

        @Override
        protected boolean isEnabledFor(DirectoryHistoryDialogModel model2, List<? extends DirectoryChange> changes) {
            return this.iterFileChanges().iterator().hasNext();
        }
    }
}

