/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ApplicationActivationStateManagerState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationActivationStateManager {
    private static final Logger LOG = Logger.getInstance(ApplicationActivationStateManager.class);
    private static final AtomicLong requestToDeactivateTime = new AtomicLong(System.currentTimeMillis());
    private static ApplicationActivationStateManagerState state = ApplicationActivationStateManagerState.DEACTIVATED;

    private ApplicationActivationStateManager() {
    }

    public static boolean isInactive() {
        return state.isInactive();
    }

    public static boolean isActive() {
        return state.isActive();
    }

    public static boolean updateState(final @NotNull WindowEvent windowEvent) {
        Application app2;
        if (windowEvent == null) {
            ApplicationActivationStateManager.$$$reportNull$$$0(0);
        }
        if (!((app2 = ApplicationManager.getApplication()) instanceof ApplicationImpl)) {
            return false;
        }
        if (windowEvent.getID() == 205 || windowEvent.getID() == 207) {
            if (state.isInactive()) {
                return ApplicationActivationStateManager.setActive(app2, windowEvent.getWindow());
            }
        } else if (windowEvent.getID() == 206 && windowEvent.getOppositeWindow() == null) {
            IdeFrame ideFrame;
            requestToDeactivateTime.getAndSet(System.currentTimeMillis());
            if (state.isActive() && !app2.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow())) != null) {
                ((ApplicationActivationListener)app2.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationDeactivated(ideFrame);
            }
            state = ApplicationActivationStateManagerState.DEACTIVATING;
            LOG.debug("The app is in the deactivating state");
            Timer timer2 = TimerUtil.createNamedTimer((String)"ApplicationDeactivation", (int)Registry.intValue((String)"application.deactivation.timeout", (int)1500), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (state == ApplicationActivationStateManagerState.DEACTIVATING) {
                        IdeFrame ideFrame;
                        state = ApplicationActivationStateManagerState.DEACTIVATED;
                        LOG.debug("The app is in the deactivated state");
                        if (!app2.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow())) != null) {
                            ((ApplicationActivationListener)app2.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).delayedApplicationDeactivated((Window)ideFrame);
                        }
                    }
                }
            });
            timer2.setRepeats(false);
            timer2.start();
            return true;
        }
        return false;
    }

    private static boolean setActive(@NotNull Application app2, @Nullable Window window) {
        IdeFrame ideFrame;
        if (app2 == null) {
            ApplicationActivationStateManager.$$$reportNull$$$0(1);
        }
        state = ApplicationActivationStateManagerState.ACTIVE;
        LOG.debug("The app is in the active state");
        if (!app2.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(window)) != null) {
            ((ApplicationActivationListener)app2.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationActivated(ideFrame);
            return true;
        }
        return false;
    }

    public static void updateState(@NotNull ApplicationImpl app2, @NotNull Window window) {
        if (app2 == null) {
            ApplicationActivationStateManager.$$$reportNull$$$0(2);
        }
        if (window == null) {
            ApplicationActivationStateManager.$$$reportNull$$$0(3);
        }
        if (state.isInactive()) {
            ApplicationActivationStateManager.setActive(app2, window);
        }
    }

    @Nullable
    private static IdeFrame getIdeFrameFromWindow(@Nullable Window window) {
        Component frame = window == null ? null : ComponentUtil.findUltimateParent((Component)window);
        return frame instanceof IdeFrame ? (IdeFrame)frame : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowEvent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ApplicationActivationStateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setActive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

