/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.actions.InvalidateCachesDialog;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InvalidateCacheService {
    private static final Logger LOG = Logger.getInstance(InvalidateCacheService.class);

    public static void invalidateCachesAndRestart(@Nullable Project project) {
        ApplicationEx app2 = ApplicationManagerEx.getApplicationEx();
        boolean canRestart = app2.isRestartCapable();
        InvalidateCachesDialog dialog2 = new InvalidateCachesDialog(project, canRestart, CachesInvalidator.EP_NAME.getExtensionList());
        dialog2.show();
        List<CachesInvalidator> invalidators = dialog2.getSelectedInvalidators();
        if (dialog2.isOK()) {
            for (CachesInvalidator invalidator : invalidators) {
                try {
                    invalidator.invalidateCaches();
                }
                catch (Throwable t) {
                    LOG.warn("Failed to invalidate caches with " + invalidator.getClass().getName() + ". " + t.getMessage(), t);
                }
            }
        }
        if (dialog2.isOK() || dialog2.isRestartOnly()) {
            app2.restart(true);
        }
    }
}

