/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TypeIconEP;
import com.intellij.ide.TypeNameEP;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypePresentationServiceImpl
extends TypePresentationService {
    private static final ExtensionPointName<TypeIconEP> TYPE_ICON_EP_NAME = new ExtensionPointName("com.intellij.typeIcon");
    private static final ExtensionPointName<PresentationProvider<?>> PROVIDER_EP = new ExtensionPointName("com.intellij.presentationProvider");
    private static final ClassExtension<PresentationProvider<?>> PROVIDERS = new ClassExtension(PROVIDER_EP.getName());
    private final Map<String, NullableLazyValue<Icon>> myIcons = new HashMap<String, NullableLazyValue<Icon>>();
    private final Map<String, NullableLazyValue<String>> myNames = new HashMap<String, NullableLazyValue<String>>();
    private final Map<Class<?>, Set<PresentationTemplate>> mySuperClasses = ConcurrentFactoryMap.createMap(key -> {
        LinkedHashSet templates = new LinkedHashSet();
        this.walkSupers((Class<?>)key, new LinkedHashSet(), templates);
        return templates;
    });

    @Nullable
    public Icon getIcon(@NotNull Object o) {
        if (o == null) {
            TypePresentationServiceImpl.$$$reportNull$$$0(0);
        }
        return this.getIcon(o.getClass(), o);
    }

    @Nullable
    public Icon getTypeIcon(Class type) {
        return this.getIcon(type, null);
    }

    @Nullable
    private Icon getIcon(Class<?> type, Object o) {
        return this.findFirst(type, template -> template.getIcon(o, 0));
    }

    @NotNull
    public String getTypePresentableName(Class type) {
        String typeName = this.findFirst(type, template -> template.getTypeName());
        String string = typeName != null ? typeName : TypePresentationServiceImpl.getDefaultTypeName((Class)type);
        if (string == null) {
            TypePresentationServiceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getTypeName(@NotNull Object o) {
        if (o == null) {
            TypePresentationServiceImpl.$$$reportNull$$$0(2);
        }
        return this.findFirst(o.getClass(), template -> template.getTypeName(o));
    }

    @Nullable
    public String getObjectName(@NotNull Object o) {
        if (o == null) {
            TypePresentationServiceImpl.$$$reportNull$$$0(3);
        }
        return this.findFirst(o.getClass(), template -> template.getName(o));
    }

    @Nullable
    private <T> T findFirst(Class<?> clazz, @NotNull Function<? super PresentationTemplate, ? extends T> f) {
        if (f == null) {
            TypePresentationServiceImpl.$$$reportNull$$$0(4);
        }
        Set<PresentationTemplate> templates = this.mySuperClasses.get(clazz);
        for (PresentationTemplate template : templates) {
            T result2 = f.apply(template);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public TypePresentationServiceImpl() {
        for (TypeIconEP ep2 : TYPE_ICON_EP_NAME.getExtensionList()) {
            this.myIcons.put(ep2.className, (NullableLazyValue<Icon>)ep2.lazyIcon);
        }
        TYPE_ICON_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<TypeIconEP>(){

            public void extensionAdded(@NotNull TypeIconEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                TypePresentationServiceImpl.this.myIcons.put(extension2.className, (NullableLazyValue<Icon>)extension2.lazyIcon);
            }

            public void extensionRemoved(@NotNull TypeIconEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                TypePresentationServiceImpl.this.myIcons.remove(extension2.className);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/TypePresentationServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
        for (TypeIconEP ep2 : TypeNameEP.EP_NAME.getExtensionList()) {
            this.myNames.put(ep2.className, (NullableLazyValue<String>)ep2.getTypeName());
        }
        TypeNameEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<TypeNameEP>(){

            public void extensionAdded(@NotNull TypeNameEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                TypePresentationServiceImpl.this.myNames.put(extension2.className, (NullableLazyValue<String>)extension2.getTypeName());
            }

            public void extensionRemoved(@NotNull TypeNameEP extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                TypePresentationServiceImpl.this.myNames.remove(extension2.className);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/TypePresentationServiceImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                TypePresentationServiceImpl.this.mySuperClasses.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/TypePresentationServiceImpl$3", "beforePluginUnload"));
            }
        });
    }

    @Nullable
    private PresentationTemplate createPresentationTemplate(Class<?> type) {
        Presentation presentation2 = type.getAnnotation(Presentation.class);
        if (presentation2 != null) {
            return new AnnotationBasedTemplate(presentation2, type);
        }
        PresentationProvider provider2 = (PresentationProvider)PROVIDERS.forClass(type);
        if (provider2 != null) {
            return new ProviderBasedTemplate(provider2);
        }
        final NullableLazyValue<Icon> icon2 = this.myIcons.get(type.getName());
        final NullableLazyValue<String> typeName = this.myNames.get(type.getName());
        if (icon2 == null && typeName == null) {
            return null;
        }
        return new PresentationTemplate(){

            @Override
            @Nullable
            public Icon getIcon(Object o, int flags) {
                return icon2 == null ? null : (Icon)icon2.getValue();
            }

            @Override
            @Nullable
            public String getName(Object o) {
                return null;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return typeName == null ? null : (String)typeName.getValue();
            }

            @Override
            @Nullable
            public String getTypeName(Object o) {
                return this.getTypeName();
            }
        };
    }

    private void walkSupers(Class<?> aClass, Set<? super Class<?>> classes, Set<? super PresentationTemplate> templates) {
        if (!classes.add(aClass)) {
            return;
        }
        ContainerUtil.addIfNotNull(templates, (Object)this.createPresentationTemplate(aClass));
        Class<?> superClass = aClass.getSuperclass();
        if (superClass != null) {
            this.walkSupers(superClass, classes, templates);
        }
        for (Class<?> intf : aClass.getInterfaces()) {
            this.walkSupers(intf, classes, templates);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/TypePresentationServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/TypePresentationServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjectName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PresentationTemplate {
        @Nullable
        public Icon getIcon(Object var1, int var2);

        @Nullable
        public String getName(Object var1);

        @Nullable
        public String getTypeName();

        @Nullable
        public String getTypeName(Object var1);
    }

    private static final class AnnotationBasedTemplate
    extends PresentationProvider<Object>
    implements PresentationTemplate {
        private final Presentation myPresentation;
        private final Class<?> myClass;
        private final NullableLazyValue<Icon> myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                if (myPresentation.icon().isEmpty()) {
                    return null;
                }
                return IconLoader.getIcon((String)myPresentation.icon(), myClass);
            }
        };
        private final NullableLazyValue<PresentationProvider<?>> myPresentationProvider = new NullableLazyValue<PresentationProvider<?>>(){

            protected PresentationProvider<?> compute() {
                Class aClass = myPresentation.provider();
                try {
                    return aClass == PresentationProvider.class ? null : (PresentationProvider)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        };

        AnnotationBasedTemplate(Presentation presentation2, Class<?> aClass) {
            this.myPresentation = presentation2;
            this.myClass = aClass;
        }

        @Nullable
        public Icon getIcon(Object o) {
            return this.getIcon(o, 0);
        }

        @Override
        @Nullable
        public Icon getIcon(Object o, int flags) {
            if (o == null) {
                return (Icon)this.myIcon.getValue();
            }
            PresentationProvider provider2 = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider2 == null) {
                return (Icon)this.myIcon.getValue();
            }
            Icon icon2 = provider2.getIcon(o);
            return icon2 == null ? (Icon)this.myIcon.getValue() : icon2;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return StringUtil.isEmpty((String)this.myPresentation.typeName()) ? null : this.myPresentation.typeName();
        }

        @Override
        @Nullable
        public String getTypeName(Object o) {
            String typeName;
            PresentationProvider provider2 = (PresentationProvider)this.myPresentationProvider.getValue();
            if (provider2 != null && (typeName = provider2.getTypeName(o)) != null) {
                return typeName;
            }
            return this.getTypeName();
        }

        @Override
        @Nullable
        public String getName(Object o) {
            PresentationProvider namer = (PresentationProvider)this.myPresentationProvider.getValue();
            return namer == null ? null : namer.getName(o);
        }
    }

    public static class PresentationTemplateImpl
    extends ProviderBasedTemplate {
        public PresentationTemplateImpl(Presentation presentation2, Class<?> aClass) {
            super(new AnnotationBasedTemplate(presentation2, aClass));
        }
    }

    public static class ProviderBasedTemplate
    implements PresentationTemplate {
        private final PresentationProvider myProvider;

        public ProviderBasedTemplate(PresentationProvider<?> provider2) {
            this.myProvider = provider2;
        }

        @Override
        @Nullable
        public Icon getIcon(Object o, int flags) {
            return this.myProvider instanceof PresentationTemplate ? ((PresentationTemplate)this.myProvider).getIcon(o, flags) : this.myProvider.getIcon(o);
        }

        @Override
        @Nullable
        public String getName(Object o) {
            return this.myProvider.getName(o);
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myProvider instanceof PresentationTemplate ? ((PresentationTemplate)this.myProvider).getTypeName() : null;
        }

        @Override
        @Nullable
        public String getTypeName(Object o) {
            return this.myProvider.getTypeName(o);
        }
    }
}

