/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherActionsKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/actions/BaseSwitcherAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "forward", "", "(Ljava/lang/Boolean;)V", "getForward", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isControlTab", "Ljava/awt/event/KeyEvent;", "isControlTabDisabled", "update", "intellij.platform.ide.impl"})
public abstract class BaseSwitcherAction
extends DumbAwareAction {
    @Nullable
    private final Boolean forward;

    private final boolean isControlTab(KeyEvent event) {
        boolean bl;
        KeyEvent keyEvent = event;
        if (keyEvent != null) {
            KeyEvent keyEvent2 = keyEvent;
            boolean bl2 = false;
            boolean bl3 = false;
            KeyEvent $this$run = keyEvent2;
            boolean bl4 = false;
            bl = $this$run.isControlDown() && $this$run.getKeyCode() == 9;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isControlTabDisabled(AnActionEvent event) {
        if (!ScreenReader.isActive()) return false;
        InputEvent inputEvent = event.getInputEvent();
        if (!(inputEvent instanceof KeyEvent)) {
            inputEvent = null;
        }
        if (!this.isControlTab((KeyEvent)inputEvent)) return false;
        return true;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
        presentation2.setEnabled(event.getProject() != null && !this.isControlTabDisabled(event));
        Presentation presentation3 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"event.presentation");
        presentation3.setVisible(this.forward == null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.project ?: return");
        Project project2 = project;
        Switcher.SwitcherPanel switcher = (Switcher.SwitcherPanel)Switcher.SWITCHER_KEY.get((UserDataHolder)project2);
        if (!(switcher == null || switcher.recent && this.forward == null)) {
            Boolean bl = this.forward;
            switcher.go(bl != null ? bl : SwitcherActionsKt.access$forward(event));
        } else {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("switcher");
            Boolean bl = this.forward;
            new Switcher.SwitcherPanel(project2, IdeBundle.message((String)"window.title.switcher", (Object[])new Object[0]), event.getInputEvent(), null, bl != null ? bl : SwitcherActionsKt.access$forward(event));
        }
    }

    @Nullable
    public final Boolean getForward() {
        return this.forward;
    }

    public BaseSwitcherAction(@Nullable Boolean forward) {
        this.forward = forward;
    }
}

