/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateDesktopEntryAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(CreateDesktopEntryAction.class);

    public static boolean isAvailable() {
        return SystemInfo.isXWindow && !ExternalUpdateManager.isRoaming() && SystemInfo.hasXdgOpen();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(0);
        }
        boolean enabled = CreateDesktopEntryAction.isAvailable();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(1);
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Project project = event.getProject();
        CreateDesktopEntryDialog dialog2 = new CreateDesktopEntryDialog(project);
        if (!dialog2.showAndGet()) {
            return;
        }
        final boolean globalEntry = dialog2.myGlobalEntryCheckBox.isSelected();
        new Task.Backgroundable(project, ApplicationBundle.message((String)"desktop.entry.progress", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CreateDesktopEntryAction.createDesktopEntry(globalEntry);
                    String message2 = ApplicationBundle.message((String)"desktop.entry.success", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.desktop.entry.created", (Object[])new Object[0]), message2, NotificationType.INFORMATION), (Project)this.getProject());
                }
                catch (Exception e) {
                    CreateDesktopEntryAction.reportFailure(e, this.getProject());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction$1", "run"));
            }
        }.queue();
    }

    public static void createDesktopEntry(boolean globalEntry) throws Exception {
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Path entry2 = null;
        try {
            CreateDesktopEntryAction.check();
            entry2 = CreateDesktopEntryAction.prepare();
            CreateDesktopEntryAction.install(entry2, globalEntry);
        }
        finally {
            if (entry2 != null) {
                Files.delete(entry2);
            }
        }
    }

    public static void reportFailure(@NotNull Exception e, @Nullable Project project) {
        if (e == null) {
            CreateDesktopEntryAction.$$$reportNull$$$0(2);
        }
        LOG.warn((Throwable)e);
        String message2 = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)IdeBundle.message((String)"notification.content.internal error", (Object[])new Object[0]));
        Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.desktop.entry.creation.failed", (Object[])new Object[0]), message2, NotificationType.ERROR), (Project)project);
    }

    private static void check() throws ExecutionException, InterruptedException {
        int result2 = new GeneralCommandLine(new String[]{"which", "xdg-desktop-menu"}).createProcess().waitFor();
        if (result2 != 0) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.xdg.missing", (Object[])new Object[0]));
        }
    }

    private static Path prepare() throws IOException {
        String binPath = PathManager.getBinPath();
        assert (new File(binPath).isDirectory()) : "Invalid bin path: '" + binPath + "'";
        String iconPath = AppUIUtil.findIcon();
        if (iconPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.icon.missing", (Object[])new Object[]{binPath}));
        }
        File starter2 = Restarter.getIdeStarter();
        if (starter2 == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{binPath}));
        }
        String execPath = StringUtil.wrapWithDoubleQuote((String)starter2.getPath());
        ApplicationNamesInfo names2 = ApplicationNamesInfo.getInstance();
        String name2 = names2.getFullProductNameWithEdition();
        String comment = StringUtil.notNullize((String)names2.getMotto(), (String)name2);
        String wmClass = AppUIUtil.getFrameClass();
        Map vars = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"$NAME$", (Object)name2), (Pair[])new Pair[]{Pair.pair((Object)"$SCRIPT$", (Object)execPath), Pair.pair((Object)"$ICON$", (Object)iconPath), Pair.pair((Object)"$COMMENT$", (Object)comment), Pair.pair((Object)"$WM_CLASS$", (Object)wmClass)});
        String content2 = ExecUtil.loadTemplate((ClassLoader)CreateDesktopEntryAction.class.getClassLoader(), (String)"entry.desktop", (Map)vars);
        Path entryFile = Paths.get(PathManager.getTempPath(), wmClass + ".desktop");
        Files.write(entryFile, content2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return entryFile;
    }

    private static void install(Path entryFile, boolean globalEntry) throws IOException, ExecutionException {
        if (globalEntry) {
            File script = ExecUtil.createTempExecutableScript((String)"create_desktop_entry_", (String)".sh", (String)("#!/bin/sh\nxdg-desktop-menu install --mode system '" + entryFile + "' && xdg-desktop-menu forceupdate --mode system\n"));
            try {
                CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{script.getPath()}), ApplicationBundle.message((String)"desktop.entry.sudo.prompt", (Object[])new Object[0]));
            }
            finally {
                Files.delete(script.toPath());
            }
        } else {
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "user", entryFile.toString()}), null);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "user"}), null);
        }
    }

    private static void exec(GeneralCommandLine command, @Nls @Nullable String prompt) throws IOException, ExecutionException {
        command.setRedirectErrorStream(true);
        ProcessOutput result2 = prompt != null ? CreateDesktopEntryAction.execAndGetOutputWithWizardSupport(ExecUtil.sudoCommand((GeneralCommandLine)command, (String)prompt)) : CreateDesktopEntryAction.execAndGetOutputWithWizardSupport(command);
        int exitCode = result2.getExitCode();
        if (exitCode != 0) {
            String message2 = "Command '" + (prompt != null ? "sudo " : "") + command.getCommandLineString() + "' returned " + exitCode;
            String output2 = result2.getStdout();
            if (!StringUtil.isEmptyOrSpaces((String)output2)) {
                message2 = message2 + "\nOutput: " + output2.trim();
            }
            throw new RuntimeException(message2);
        }
    }

    private static ProcessOutput execAndGetOutputWithWizardSupport(GeneralCommandLine cmd) throws ExecutionException {
        return new CapturingProcessHandler(cmd){

            public boolean hasPty() {
                if (ApplicationManager.getApplication() == null) {
                    return false;
                }
                return super.hasPty();
            }
        }.runProcess();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateDesktopEntryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportFailure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CreateDesktopEntryDialog
    extends DialogWrapper {
        @NlsSafe
        private static final String APP_NAME_PLACEHOLDER = "$APP_NAME$";
        private JPanel myContentPane;
        private JLabel myLabel;
        private JCheckBox myGlobalEntryCheckBox;

        public CreateDesktopEntryDialog(Project project) {
            super(project);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0]));
            this.myLabel.setText(this.myLabel.getText().replace(APP_NAME_PLACEHOLDER, ApplicationNamesInfo.getInstance().getProductName()));
        }

        protected JComponent createCenterPanel() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JCheckBox jCheckBox;
            JPanel jPanel2;
            this.myContentPane = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
            this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateDesktopEntryDialog.class).getString("checkbox.create.the.entry.for.all.users.requires.superuser.privileges"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", CreateDesktopEntryDialog.class).getString("label.you.can.create.a.desktop.entry"));
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

