/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OccurenceNavigatorActionBase
extends DumbAwareAction
implements UpdateInBackground {
    OccurenceNavigatorActionBase() {
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(e.getDataContext());
        if (navigator == null || !this.hasOccurenceToGo(navigator)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(navigator);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor2 = occurenceInfo.getNavigateable();
        if (descriptor2 != null && descriptor2.canNavigate()) {
            descriptor2.navigate(true);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}));
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        OccurenceNavigator navigator = this.getNavigator(event.getDataContext());
        if (navigator == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(!ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()));
            return;
        }
        presentation2.setVisible(true);
        try {
            presentation2.setEnabled(this.hasOccurenceToGo(navigator));
            presentation2.setText(this.getDescription(navigator));
        }
        catch (IndexNotReadyException e) {
            presentation2.setEnabled(false);
        }
    }

    protected abstract OccurenceNavigator.OccurenceInfo go(OccurenceNavigator var1);

    protected abstract boolean hasOccurenceToGo(OccurenceNavigator var1);

    @NlsActions.ActionText
    protected abstract String getDescription(OccurenceNavigator var1);

    @Nullable
    protected OccurenceNavigator getNavigator(DataContext dataContext) {
        ContentManager contentManager2 = ContentManagerUtil.getContentManagerFromContext(dataContext, false);
        if (contentManager2 != null) {
            OccurenceNavigator navigator;
            Content content2 = contentManager2.getSelectedContent();
            OccurenceNavigator occurenceNavigator = navigator = content2 != null ? OccurenceNavigatorActionBase.findNavigator(content2.getComponent()) : null;
            if (navigator != null) {
                return navigator;
            }
        }
        return OccurenceNavigatorActionBase.getOccurenceNavigatorFromContext(dataContext);
    }

    @Nullable
    private static OccurenceNavigator findNavigator(JComponent parent) {
        LinkedList<JComponent> queue2 = new LinkedList<JComponent>();
        queue2.addLast(parent);
        while (!queue2.isEmpty()) {
            JComponent component2 = (JComponent)queue2.removeFirst();
            if (component2 instanceof OccurenceNavigator) {
                return (OccurenceNavigator)component2;
            }
            if (component2 instanceof JTabbedPane) {
                JComponent selectedComponent = (JComponent)((JTabbedPane)component2).getSelectedComponent();
                if (selectedComponent == null) continue;
                queue2.addLast(selectedComponent);
                continue;
            }
            if (component2 == null) continue;
            for (int i2 = 0; i2 < component2.getComponentCount(); ++i2) {
                Component child2 = component2.getComponent(i2);
                if (!(child2 instanceof JComponent)) continue;
                queue2.addLast((JComponent)child2);
            }
        }
        return null;
    }

    @Nullable
    private static OccurenceNavigator getOccurenceNavigatorFromContext(@NotNull DataContext dataContext) {
        Component component2;
        if (dataContext == null) {
            OccurenceNavigatorActionBase.$$$reportNull$$$0(2);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        for (Component c = component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext); c != null; c = c.getParent()) {
            if (!(c instanceof OccurenceNavigator)) continue;
            return (OccurenceNavigator)c;
        }
        if (project == null) {
            return null;
        }
        for (ToolWindow toolWindow2 : JBIterable.of((Object[])((ToolWindow[])PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS.getData(dataContext)))) {
            OccurenceNavigator navigator = OccurenceNavigatorActionBase.findNavigator(toolWindow2.getComponent());
            if (navigator == null) continue;
            return navigator;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/OccurenceNavigatorActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOccurenceNavigatorFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

