/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.actions.RecentLocationsDataModel$collectBreadcrumbs$1;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005\u0012\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00070\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0006H\u0002J/\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\bH\u0003J\u001f\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r2\u0006\u0010\"\u001a\u00020\u0006J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\"\u001a\u00020\u0006J#\u00100\u001a\b\u0012\u0004\u0012\u00020*012\u0006\u0010+\u001a\u00020,2\u0006\u00102\u001a\u00020.H\u0002\u00a2\u0006\u0002\u00103J\u0012\u00104\u001a\u0004\u0018\u00010\u00162\u0006\u00105\u001a\u00020\bH\u0002J$\u00106\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007R,\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u0019\u0010\u0011R\u001f\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR%\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lcom/intellij/ide/actions/RecentLocationsDataModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "placesSupplier", "Ljava/util/function/Function;", "", "", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "placesRemover", "Ljava/util/function/Consumer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Function;Ljava/util/function/Consumer;)V", "changedPlacedBreadcrumbsMap", "", "", "Lorg/jetbrains/annotations/Nls;", "getChangedPlacedBreadcrumbsMap", "()Ljava/util/Map;", "changedPlacedBreadcrumbsMap$delegate", "Lkotlin/Lazy;", "changedPlaces", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/ide/actions/RecentLocationItem;", "navigationPlaces", "navigationPlacesBreadcrumbsMap", "getNavigationPlacesBreadcrumbsMap", "navigationPlacesBreadcrumbsMap$delegate", "getPlacesRemover", "()Ljava/util/function/Consumer;", "getPlacesSupplier", "()Ljava/util/function/Function;", "getProject", "()Lcom/intellij/openapi/project/Project;", "calculateItems", "changed", "collectBreadcrumbs", "items", "createPlaceLinePairs", "getBreadcrumbs", "placeInfo", "getBreadcrumbsMap", "getLinesRange", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "line", "", "getPlaces", "getTrimmedRange", "", "lineNumber", "(Lcom/intellij/openapi/editor/Document;I)[Lcom/intellij/openapi/util/TextRange;", "newLocationItem", "place", "removeItems", "", "isChanged", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class RecentLocationsDataModel {
    private final SynchronizedClearableLazy<List<RecentLocationItem>> navigationPlaces;
    private final SynchronizedClearableLazy<List<RecentLocationItem>> changedPlaces;
    private final Lazy navigationPlacesBreadcrumbsMap$delegate;
    private final Lazy changedPlacedBreadcrumbsMap$delegate;
    @NotNull
    private final Project project;
    @Nullable
    private final Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> placesSupplier;
    @Nullable
    private final Consumer<List<IdeDocumentHistoryImpl.PlaceInfo>> placesRemover;

    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getNavigationPlacesBreadcrumbsMap() {
        Lazy lazy = this.navigationPlacesBreadcrumbsMap$delegate;
        RecentLocationsDataModel recentLocationsDataModel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getChangedPlacedBreadcrumbsMap() {
        Lazy lazy = this.changedPlacedBreadcrumbsMap$delegate;
        RecentLocationsDataModel recentLocationsDataModel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<RecentLocationItem> getPlaces(boolean changed2) {
        return changed2 ? (List)this.changedPlaces.getValue() : (List)this.navigationPlaces.getValue();
    }

    @NotNull
    public final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getBreadcrumbsMap(boolean changed2) {
        return changed2 ? this.getChangedPlacedBreadcrumbsMap() : this.getNavigationPlacesBreadcrumbsMap();
    }

    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> collectBreadcrumbs(Project project, List<RecentLocationItem> items) {
        Stream stream = items.stream();
        Object object = (Function1)RecentLocationsDataModel$collectBreadcrumbs$1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Map<IdeDocumentHistoryImpl.PlaceInfo, String> map2 = stream.map((Function)object).collect(Collectors.toMap(collectBreadcrumbs.2.INSTANCE, new Function(this, project){
            final /* synthetic */ RecentLocationsDataModel this$0;
            final /* synthetic */ Project $project;

            public final String apply(IdeDocumentHistoryImpl.PlaceInfo it) {
                IdeDocumentHistoryImpl.PlaceInfo placeInfo = it;
                Intrinsics.checkNotNullExpressionValue((Object)placeInfo, (String)"it");
                return RecentLocationsDataModel.access$getBreadcrumbs(this.this$0, this.$project, placeInfo);
            }
            {
                this.this$0 = recentLocationsDataModel;
                this.$project = project;
            }
        }));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"items.stream()\n      .ma\u2026adcrumbs(project, it) }))");
        return map2;
    }

    @Nls
    private final String getBreadcrumbs(Project project, IdeDocumentHistoryImpl.PlaceInfo placeInfo) {
        RangeMarker rangeMarker = placeInfo.getCaretPosition();
        VirtualFile virtualFile2 = placeInfo.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"placeInfo.file");
        String string = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"placeInfo.file.name");
        String fileName = string;
        if (rangeMarker == null) {
            return fileName;
        }
        FileBreadcrumbsCollector fileBreadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)project, (VirtualFile)placeInfo.getFile());
        if (fileBreadcrumbsCollector == null) {
            return fileName;
        }
        FileBreadcrumbsCollector collector = fileBreadcrumbsCollector;
        Iterable iterable = collector.computeCrumbs(placeInfo.getFile(), rangeMarker.getDocument(), rangeMarker.getStartOffset(), Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"collector.computeCrumbs(\u2026Marker.startOffset, true)");
        Iterable crumbs = iterable;
        if (!crumbs.iterator().hasNext()) {
            return fileName;
        }
        String separator2 = " > ";
        String result2 = CollectionsKt.joinToString$default((Iterable)crumbs, (CharSequence)separator2, null, null, (int)0, null, (Function1)getBreadcrumbs.result.1.INSTANCE, (int)30, null);
        return result2;
    }

    private final SynchronizedClearableLazy<List<RecentLocationItem>> calculateItems(Project project, boolean changed2) {
        return new SynchronizedClearableLazy((Function0)new Function0<List<? extends RecentLocationItem>>(this, project, changed2){
            final /* synthetic */ RecentLocationsDataModel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $changed;

            @NotNull
            public final List<RecentLocationItem> invoke() {
                return RecentLocationsDataModel.access$createPlaceLinePairs(this.this$0, this.$project, this.$changed);
            }
            {
                this.this$0 = recentLocationsDataModel;
                this.$project = project;
                this.$changed = bl;
                super(0);
            }
        });
    }

    private final List<RecentLocationItem> createPlaceLinePairs(Project project, boolean changed2) {
        boolean bl = false;
        ArrayList<RecentLocationItem> result2 = new ArrayList<RecentLocationItem>();
        if (this.placesSupplier != null) {
            for (IdeDocumentHistoryImpl.PlaceInfo place : this.placesSupplier.apply(changed2)) {
                RecentLocationItem recentLocationItem = this.newLocationItem(place);
                if (recentLocationItem == null) {
                    continue;
                }
                result2.add(recentLocationItem);
            }
        } else {
            List<IdeDocumentHistoryImpl.PlaceInfo> list2;
            int maxPlaces = UISettings.Companion.getInstance().getRecentLocationsLimit();
            if (changed2) {
                IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)ideDocumentHistory, (String)"IdeDocumentHistory.getInstance(project)");
                list2 = ideDocumentHistory.getChangePlaces();
            } else {
                IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)ideDocumentHistory, (String)"IdeDocumentHistory.getInstance(project)");
                list2 = ideDocumentHistory.getBackPlaces();
            }
            List list3 = ContainerUtil.reverse(list2);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ContainerUtil.reverse(if\u2026ance(project).backPlaces)");
            List places = list3;
            for (IdeDocumentHistoryImpl.PlaceInfo place : places) {
                if (result2.stream().noneMatch(new Predicate(place){
                    final /* synthetic */ IdeDocumentHistoryImpl.PlaceInfo $place;

                    public final boolean test(RecentLocationItem it) {
                        return IdeDocumentHistoryImpl.isSame(this.$place, it.info);
                    }
                    {
                        this.$place = placeInfo;
                    }
                })) {
                    IdeDocumentHistoryImpl.PlaceInfo placeInfo = place;
                    Intrinsics.checkNotNullExpressionValue((Object)placeInfo, (String)"place");
                    RecentLocationItem recentLocationItem = this.newLocationItem(placeInfo);
                    if (recentLocationItem == null) {
                        continue;
                    }
                    result2.add(recentLocationItem);
                }
                if (result2.size() < maxPlaces) continue;
                break;
            }
        }
        return result2;
    }

    private final RecentLocationItem newLocationItem(IdeDocumentHistoryImpl.PlaceInfo place) {
        CharSequence charSequence;
        RangeMarker positionOffset = place.getCaretPosition();
        if (positionOffset == null || !positionOffset.isValid()) {
            return null;
        }
        boolean bl = positionOffset.getStartOffset() == positionOffset.getEndOffset();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Document document = positionOffset.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"positionOffset.document");
        Document fileDocument = document;
        int lineNumber = fileDocument.getLineNumber(positionOffset.getStartOffset());
        Object[] ranges = this.getTrimmedRange(fileDocument, lineNumber);
        CharSequence charSequence2 = ArraysKt.joinToString$default((Object[])ranges, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<TextRange, CharSequence>(fileDocument){
            final /* synthetic */ Document $fileDocument;

            @NotNull
            public final CharSequence invoke(@NotNull TextRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$fileDocument.getText(it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileDocument.getText(it)");
                return string;
            }
            {
                this.$fileDocument = document;
                super(1);
            }
        }), (int)30, null);
        boolean bl5 = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl6 = false;
        if (charSequence3.length() == 0) {
            boolean bl7 = false;
            charSequence = RecentLocationsAction.getEmptyFileText();
        } else {
            charSequence = charSequence2;
        }
        String documentText2 = (String)charSequence;
        Object[] objectArray = ranges;
        boolean bl8 = false;
        Object[] objectArray2 = objectArray;
        boolean bl9 = false;
        int linesShift = !(objectArray2.length == 0) ? fileDocument.getLineNumber(ranges[0].getStartOffset()) : 0;
        String string = documentText2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"documentText");
        return new RecentLocationItem(place, string, linesShift, (TextRange[])ranges);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeItems(@NotNull Project project, boolean isChanged, @NotNull List<RecentLocationItem> items) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (isChanged) {
            this.changedPlaces.drop();
        } else {
            this.navigationPlaces.drop();
        }
        if (this.placesRemover != null) {
            this.placesRemover.accept(ContainerUtil.map((Collection)items, (com.intellij.util.Function)removeItems.1.INSTANCE));
            return;
        }
        IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project);
        for (RecentLocationItem item : items) {
            void $this$forEach$iv;
            List<IdeDocumentHistoryImpl.PlaceInfo> list2;
            if (isChanged) {
                IdeDocumentHistory ideDocumentHistory2 = ideDocumentHistory;
                Intrinsics.checkNotNullExpressionValue((Object)ideDocumentHistory2, (String)"ideDocumentHistory");
                list2 = ideDocumentHistory2.getChangePlaces();
            } else {
                IdeDocumentHistory ideDocumentHistory3 = ideDocumentHistory;
                Intrinsics.checkNotNullExpressionValue((Object)ideDocumentHistory3, (String)"ideDocumentHistory");
                list2 = ideDocumentHistory3.getBackPlaces();
            }
            List list3 = ContainerUtil.filter((Collection)list2, (Condition)new Condition(item){
                final /* synthetic */ RecentLocationItem $item;

                public final boolean value(IdeDocumentHistoryImpl.PlaceInfo it) {
                    return IdeDocumentHistoryImpl.isSame(it, this.$item.info);
                }
                {
                    this.$item = recentLocationItem;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ContainerUtil.filter(if \u2026me(it, item.info)\n      }");
            Iterable iterable = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeDocumentHistoryImpl.PlaceInfo it = (IdeDocumentHistoryImpl.PlaceInfo)element$iv;
                boolean bl = false;
                if (isChanged) {
                    ideDocumentHistory.removeChangePlace(it);
                    continue;
                }
                ideDocumentHistory.removeBackPlace(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange[] getTrimmedRange(Document document, int lineNumber) {
        TextRange range2 = this.getLinesRange(document, lineNumber);
        String string = document.getText(TextRange.create((int)range2.getStartOffset(), (int)range2.getEndOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026Offset, range.endOffset))");
        String text2 = string;
        int newLinesBefore = StringUtil.countNewLines((CharSequence)Objects.requireNonNull(StringUtil.substringBefore((String)text2, (String)StringUtil.trimLeading((String)text2))));
        int newLinesAfter = StringUtil.countNewLines((CharSequence)Objects.requireNonNull(StringUtil.substringAfter((String)text2, (String)StringUtil.trimTrailing((String)text2))));
        int firstLine = document.getLineNumber(range2.getStartOffset());
        int firstLineAdjusted = firstLine + newLinesBefore;
        int lastLine = document.getLineNumber(range2.getEndOffset());
        int lastLineAdjusted = lastLine - newLinesAfter;
        int n = lastLineAdjusted - firstLineAdjusted + 1;
        TextRange[] textRangeArray = new TextRange[n];
        int n2 = 0;
        while (n2 < n) {
            TextRange textRange;
            void it;
            int n3 = n2;
            int n4 = n2++;
            TextRange[] textRangeArray2 = textRangeArray;
            boolean bl = false;
            int startOffset = document.getLineStartOffset(firstLineAdjusted + it);
            int endOffset = document.getLineEndOffset(firstLineAdjusted + it);
            int n5 = endOffset - startOffset;
            int n6 = 1000;
            boolean bl2 = false;
            textRangeArray2[n4] = textRange = TextRange.create((int)startOffset, (int)(startOffset + Math.min(n5, n6)));
        }
        TextRange[] result2 = textRangeArray;
        return result2;
    }

    private final TextRange getLinesRange(Document document, int line) {
        TextRange textRange;
        int endOffset;
        int lineCount = document.getLineCount();
        if (lineCount == 0) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"TextRange.EMPTY_RANGE");
            return textRange2;
        }
        int beforeAfterLinesCount = Registry.intValue((String)"recent.locations.lines.before.and.after", (int)2);
        boolean bl = false;
        int before = Math.min(beforeAfterLinesCount, line);
        int n = lineCount - line;
        boolean bl2 = false;
        int after2 = Math.min(beforeAfterLinesCount, n);
        int linesBefore = before + beforeAfterLinesCount - after2;
        int linesAfter = after2 + beforeAfterLinesCount - before;
        int n2 = line - linesBefore;
        int n3 = 0;
        int n4 = 0;
        int startLine = Math.max(n2, n3);
        n3 = line + linesAfter;
        n4 = lineCount - 1;
        boolean bl3 = false;
        int endLine = Math.min(n3, n4);
        int startOffset = document.getLineStartOffset(startLine);
        if (startOffset <= (endOffset = document.getLineEndOffset(endLine))) {
            TextRange textRange3 = TextRange.create((int)startOffset, (int)endOffset);
            textRange = textRange3;
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"TextRange.create(startOffset, endOffset)");
        } else {
            TextRange textRange4 = TextRange.create((Segment)((Segment)DocumentUtil.getLineTextRange(document, line)));
            textRange = textRange4;
            Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"TextRange.create(Documen\u2026extRange(document, line))");
        }
        return textRange;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> getPlacesSupplier() {
        return this.placesSupplier;
    }

    @Nullable
    public final Consumer<List<IdeDocumentHistoryImpl.PlaceInfo>> getPlacesRemover() {
        return this.placesRemover;
    }

    public RecentLocationsDataModel(@NotNull Project project, @Nullable Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> placesSupplier, @Nullable Consumer<List<IdeDocumentHistoryImpl.PlaceInfo>> placesRemover) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.placesSupplier = placesSupplier;
        this.placesRemover = placesRemover;
        this.navigationPlaces = this.calculateItems(this.project, false);
        this.changedPlaces = this.calculateItems(this.project, true);
        this.navigationPlacesBreadcrumbsMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<IdeDocumentHistoryImpl.PlaceInfo, ? extends String>>(this){
            final /* synthetic */ RecentLocationsDataModel this$0;

            @NotNull
            public final Map<IdeDocumentHistoryImpl.PlaceInfo, String> invoke() {
                return RecentLocationsDataModel.access$collectBreadcrumbs(this.this$0, this.this$0.getProject(), (List)RecentLocationsDataModel.access$getNavigationPlaces$p(this.this$0).getValue());
            }
            {
                this.this$0 = recentLocationsDataModel;
                super(0);
            }
        }));
        this.changedPlacedBreadcrumbsMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<IdeDocumentHistoryImpl.PlaceInfo, ? extends String>>(this){
            final /* synthetic */ RecentLocationsDataModel this$0;

            @NotNull
            public final Map<IdeDocumentHistoryImpl.PlaceInfo, String> invoke() {
                return RecentLocationsDataModel.access$collectBreadcrumbs(this.this$0, this.this$0.getProject(), (List)RecentLocationsDataModel.access$getChangedPlaces$p(this.this$0).getValue());
            }
            {
                this.this$0 = recentLocationsDataModel;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$getBreadcrumbs(RecentLocationsDataModel $this, Project project, IdeDocumentHistoryImpl.PlaceInfo placeInfo) {
        return $this.getBreadcrumbs(project, placeInfo);
    }

    public static final /* synthetic */ List access$createPlaceLinePairs(RecentLocationsDataModel $this, Project project, boolean changed2) {
        return $this.createPlaceLinePairs(project, changed2);
    }

    public static final /* synthetic */ Map access$collectBreadcrumbs(RecentLocationsDataModel $this, Project project, List items) {
        return $this.collectBreadcrumbs(project, items);
    }

    public static final /* synthetic */ SynchronizedClearableLazy access$getNavigationPlaces$p(RecentLocationsDataModel $this) {
        return $this.navigationPlaces;
    }

    public static final /* synthetic */ SynchronizedClearableLazy access$getChangedPlaces$p(RecentLocationsDataModel $this) {
        return $this.changedPlaces;
    }
}

