/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsEntryPointAction
extends DumbAwareAction
implements RightAlignedToolbarAction,
TooltipDescriptionProvider {
    private final PopupState<JBPopup> myPopupState = PopupState.forPopup();
    private static boolean ourShowPlatformUpdateIcon;
    private static boolean ourShowPluginsUpdateIcon;
    private static UISettingsListener mySettingsListener;
    private static final String WIDGET_ID = "settingsEntryPointWidget";

    public SettingsEntryPointAction() {
        super(IdeBundle.messagePointer((String)"settings.entry.point.tooltip", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(0);
        }
        SettingsEntryPointAction.resetActionIcon();
        if (this.myPopupState.isHidden() && !this.myPopupState.isRecentlyHidden()) {
            ListPopup popup2 = SettingsEntryPointAction.createMainPopup(e.getDataContext());
            this.myPopupState.prepareToShow((Object)popup2);
            PopupUtil.showForActionButtonEvent((JBPopup)popup2, (AnActionEvent)e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        if (e.isFromActionToolbar()) {
            presentation2.setText("");
        }
        presentation2.setDescription(SettingsEntryPointAction.getActionTooltip());
        presentation2.setIcon(SettingsEntryPointAction.getActionIcon());
    }

    private static AnAction @NotNull [] getTemplateActions() {
        ActionGroup templateGroup = (ActionGroup)ActionManager.getInstance().getAction("SettingsEntryPointGroup");
        AnAction[] anActionArray = templateGroup == null ? EMPTY_ARRAY : templateGroup.getChildren(null);
        if (anActionArray == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    @NotNull
    private static ListPopup createMainPopup(@NotNull DataContext context2) {
        if (context2 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(3);
        }
        ArrayList<UpdateAction> appActions = new ArrayList<UpdateAction>();
        ArrayList<UpdateAction> pluginActions = new ArrayList<UpdateAction>();
        for (ActionProvider provider2 : ActionProvider.EP_NAME.getExtensionList()) {
            for (UpdateAction action2 : provider2.getUpdateActions(context2)) {
                Presentation presentation2 = action2.getTemplatePresentation();
                if (action2.isIdeUpdate()) {
                    presentation2.setIcon(AllIcons.Ide.Notification.IdeUpdate);
                    appActions.add(action2);
                } else {
                    presentation2.setIcon(AllIcons.Ide.Notification.PluginUpdate);
                    pluginActions.add(action2);
                }
                action2.markAsRead();
            }
        }
        DefaultActionGroup group2 = new DefaultActionGroup(appActions);
        group2.addAll(pluginActions);
        if (group2.getChildrenCount() == 0) {
            SettingsEntryPointAction.resetActionIcon();
        } else {
            group2.addSeparator();
        }
        for (AnAction child2 : SettingsEntryPointAction.getTemplateActions()) {
            if (child2 instanceof Separator) {
                group2.add(child2);
                continue;
            }
            String text2 = child2.getTemplateText();
            if (text2 != null && !text2.endsWith("...") && !text2.endsWith("\u2026")) {
                AnActionButton.AnActionButtonWrapper button4 = new AnActionButton.AnActionButtonWrapper(child2.getTemplatePresentation(), child2){

                    public void updateButton(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.getDelegate().update(e);
                        e.getPresentation().setText(e.getPresentation().getText() + "\u2026");
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.actionPerformed(new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), this.getDelegate().getTemplatePresentation(), e.getActionManager(), e.getModifiers()));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "updateButton";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                button4.setShortcut(child2.getShortcutSet());
                group2.add((AnAction)button4);
                continue;
            }
            group2.add(child2);
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, context2, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        if (listPopup == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(4);
        }
        return listPopup;
    }

    public static void updateState() {
        SettingsEntryPointAction.resetActionIcon();
        block0: for (ActionProvider provider2 : ActionProvider.EP_NAME.getExtensionList()) {
            for (UpdateAction action2 : provider2.getUpdateActions(DataContext.EMPTY_CONTEXT)) {
                if (!action2.isNewAction()) continue;
                if (action2.isIdeUpdate()) {
                    ourShowPlatformUpdateIcon = true;
                } else {
                    ourShowPluginsUpdateIcon = true;
                }
                if (!ourShowPlatformUpdateIcon || !ourShowPluginsUpdateIcon) continue;
                break block0;
            }
        }
        if (SettingsEntryPointAction.isAvailableInStatusBar()) {
            SettingsEntryPointAction.updateWidgets();
        }
    }

    @NotNull
    @Nls
    private static String getActionTooltip() {
        boolean updates2;
        boolean bl = updates2 = ourShowPlatformUpdateIcon || ourShowPluginsUpdateIcon;
        if (!updates2) {
            for (ActionProvider provider2 : ActionProvider.EP_NAME.getExtensionList()) {
                if (provider2.getUpdateActions(DataContext.EMPTY_CONTEXT).isEmpty()) continue;
                updates2 = true;
                break;
            }
        }
        String string = IdeBundle.message((String)(updates2 ? "settings.entry.point.with.updates.tooltip" : "settings.entry.point.tooltip"), (Object[])new Object[0]);
        if (string == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void resetActionIcon() {
        ourShowPluginsUpdateIcon = false;
        ourShowPlatformUpdateIcon = false;
    }

    @NotNull
    private static Icon getActionIcon() {
        if (ourShowPlatformUpdateIcon) {
            Icon icon2 = AllIcons.Ide.Notification.IdeUpdate;
            if (icon2 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(6);
            }
            return icon2;
        }
        if (ourShowPluginsUpdateIcon) {
            Icon icon3 = AllIcons.Ide.Notification.PluginUpdate;
            if (icon3 == null) {
                SettingsEntryPointAction.$$$reportNull$$$0(7);
            }
            return icon3;
        }
        Icon icon4 = AllIcons.General.GearPlain;
        if (icon4 == null) {
            SettingsEntryPointAction.$$$reportNull$$$0(8);
        }
        return icon4;
    }

    private static void initUISettingsListener() {
        if (mySettingsListener == null) {
            mySettingsListener = uiSettings -> SettingsEntryPointAction.updateWidgets();
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(UISettingsListener.TOPIC, (Object)mySettingsListener);
        }
    }

    private static void updateWidgets() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar2;
            ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(StatusBarManager.class);
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
            if (frame == null || (statusBar2 = frame.getStatusBar()) == null) continue;
            statusBar2.updateWidget(WIDGET_ID);
        }
    }

    private static boolean isAvailableInStatusBar() {
        SettingsEntryPointAction.initUISettingsListener();
        UISettings uiSettings = UISettings.getInstance();
        ToolbarSettings toolbarSettings = ToolbarSettings.getInstance();
        return !uiSettings.getShowMainToolbar() && !uiSettings.getShowNavigationBar() && (!toolbarSettings.isEnabled() || !toolbarSettings.isVisible());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTooltip";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMainPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class UpdateAction
    extends DumbAwareAction {
        private boolean myNewAction = true;

        protected UpdateAction() {
        }

        protected UpdateAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        public boolean isIdeUpdate() {
            return false;
        }

        public boolean isNewAction() {
            return this.myNewAction;
        }

        public void markAsRead() {
            this.myNewAction = false;
        }
    }

    public static interface ActionProvider {
        public static final ExtensionPointName<ActionProvider> EP_NAME = new ExtensionPointName("com.intellij.settingsEntryPointActionProvider");

        @NotNull
        public Collection<UpdateAction> getUpdateActions(@NotNull DataContext var1);
    }

    private static class MyStatusBarWidget
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation {
        private final PopupState<JBPopup> myPopupState = PopupState.forPopup();
        private StatusBar myStatusBar;

        private MyStatusBarWidget() {
        }

        @NotNull
        public String ID() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        public void install(@NotNull StatusBar statusBar2) {
            if (statusBar2 == null) {
                MyStatusBarWidget.$$$reportNull$$$0(0);
            }
            this.myStatusBar = statusBar2;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this;
        }

        @Nullable
        @NlsContexts.Tooltip
        public String getTooltipText() {
            return SettingsEntryPointAction.getActionTooltip();
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> {
                SettingsEntryPointAction.resetActionIcon();
                this.myStatusBar.updateWidget(SettingsEntryPointAction.WIDGET_ID);
                if (!this.myPopupState.isHidden() || this.myPopupState.isRecentlyHidden()) {
                    return;
                }
                final Component component2 = event.getComponent();
                final ListPopup popup2 = SettingsEntryPointAction.createMainPopup(DataManager.getInstance().getDataContext(component2));
                this.myPopupState.prepareToShow((Object)popup2);
                popup2.addListener(new JBPopupListener(){

                    public void beforeShown(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Point location = component2.getLocationOnScreen();
                        Dimension size = popup2.getSize();
                        popup2.setLocation(new Point(location.x + component2.getWidth() - size.width, location.y - size.height));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget$1", "beforeShown"));
                    }
                });
                popup2.show(component2);
            };
        }

        @Nullable
        public Icon getIcon() {
            return SettingsEntryPointAction.getActionIcon();
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/ide/actions/SettingsEntryPointAction$MyStatusBarWidget", "install"));
        }
    }

    public static class StatusBarManager
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return SettingsEntryPointAction.WIDGET_ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = IdeBundle.message((String)"settings.entry.point.widget.name", (Object[])new Object[0]);
            if (string == null) {
                StatusBarManager.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                StatusBarManager.$$$reportNull$$$0(1);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                StatusBarManager.$$$reportNull$$$0(2);
            }
            return new MyStatusBarWidget();
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            if (widget == null) {
                StatusBarManager.$$$reportNull$$$0(3);
            }
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar2) {
            if (statusBar2 == null) {
                StatusBarManager.$$$reportNull$$$0(4);
            }
            return SettingsEntryPointAction.isAvailableInStatusBar();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SettingsEntryPointAction$StatusBarManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeWidget";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

