/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SynchronizeCurrentFileAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && SynchronizeCurrentFileAction.getSupportedFiles(e).findAny().isPresent());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<VirtualFile> files2 = SynchronizeCurrentFileAction.getSupportedFiles(e).collect(Collectors.toList());
        SynchronizeCurrentFileAction.synchronizeFiles(files2, project, true);
    }

    public static void synchronizeFiles(Collection<VirtualFile> files2, Project project, boolean async) {
        if (files2.isEmpty()) {
            return;
        }
        for (VirtualFile file2 : files2) {
            VirtualFileSystem fs = file2.getFileSystem();
            if (fs instanceof ArchiveFileSystem) {
                ((ArchiveFileSystem)fs).clearArchiveCache(file2);
            }
            if (file2.isDirectory()) {
                file2.getChildren();
            }
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markClean();
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(async, true, () -> SynchronizeCurrentFileAction.postRefresh(project, files2), files2);
    }

    private static void postRefresh(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        StatusBar statusBar2;
        List localFiles;
        if (project == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(3);
        }
        if (!(localFiles = ContainerUtil.filter(files2, f -> f.isInLocalFileSystem())).isEmpty()) {
            VcsFacade.getInstance().markFilesDirty(project, localFiles);
        }
        if ((statusBar2 = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar2.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[0]));
        }
    }

    @NotNull
    private static Stream<VirtualFile> getSupportedFiles(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Stream<VirtualFile> stream = files2 != null ? Stream.of(files2).filter(f -> {
            if (!f.isValid()) {
                return false;
            }
            VirtualFileSystem fs = f.getFileSystem();
            return fs instanceof LocalFileSystem || fs instanceof ArchiveFileSystem;
        }) : Stream.empty();
        if (stream == null) {
            SynchronizeCurrentFileAction.$$$reportNull$$$0(4);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SynchronizeCurrentFileAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "postRefresh";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

