/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.cache;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.cache.CacheRecoveryUsageCollector;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.Saul;
import com.intellij.ide.actions.cache.SaulKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/actions/cache/RecoveryWorker;", "", "actions", "", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "(Ljava/util/Collection;)V", "actionSeq", "", "getActions", "()Ljava/util/Collection;", "next", "askUserToContinue", "", "project", "Lcom/intellij/openapi/project/Project;", "previousRecoveryAction", "idx", "", "hasNextRecoveryAction", "", "nextRecoveryAction", "perform", "recoveryAction", "reportStoppedToFus", "start", "Companion", "intellij.platform.ide.impl"})
final class RecoveryWorker {
    private final Iterator<RecoveryAction> actionSeq;
    private volatile RecoveryAction next;
    @NotNull
    private final Collection<RecoveryAction> actions;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void start(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.perform(this.nextRecoveryAction(project), project, 0);
    }

    public final void perform(@NotNull RecoveryAction recoveryAction, @NotNull Project project, int idx) {
        Intrinsics.checkNotNullParameter((Object)recoveryAction, (String)"recoveryAction");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SaulKt.performUnderProgress(recoveryAction, project, true, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(this, recoveryAction, idx){
            final /* synthetic */ RecoveryWorker this$0;
            final /* synthetic */ RecoveryAction $recoveryAction;
            final /* synthetic */ int $idx;

            public final void invoke(@NotNull Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (RecoveryWorker.access$hasNextRecoveryAction(this.this$0, p)) {
                    RecoveryWorker.access$askUserToContinue(this.this$0, p, this.$recoveryAction, this.$idx);
                }
            }
            {
                this.this$0 = recoveryWorker;
                this.$recoveryAction = recoveryAction;
                this.$idx = n;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void askUserToContinue(Project project, RecoveryAction previousRecoveryAction, int idx) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!this.hasNextRecoveryAction(project)) {
            return;
        }
        RecoveryAction recoveryAction = this.actionSeq.next();
        int next = idx + 1;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Cache Recovery");
        String string = IdeBundle.message((String)"notification.cache.diagnostic.helper.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"notif\u2026diagnostic.helper.title\")");
        Object[] objectArray = new Object[3];
        objectArray[0] = previousRecoveryAction.getPresentableName();
        objectArray[1] = next;
        boolean $i$f$service22 = false;
        Class<Saul> serviceClass$iv = Saul.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        Iterable $i$f$service22 = ((Saul)object).getSortedActions();
        int n = 2;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        String string2 = "notification.cache.diagnostic.helper.text";
        String string3 = string;
        NotificationGroup notificationGroup2 = notificationGroup;
        boolean $i$f$filter = false;
        void var9_16 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RecoveryAction it = (RecoveryAction)element$iv$iv;
            boolean bl = false;
            if (!it.canBeApplied(project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        objectArray2[n] = list2.size();
        String string4 = IdeBundle.message((String)string2, (Object[])objectArray3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IdeBundle.message(\"notif\u2026eApplied(project) }.size)");
        Notification notification = notificationGroup2.createNotification(string3, string4, NotificationType.WARNING);
        notification.addAction((AnAction)DumbAwareAction.create((String)IdeBundle.message((String)"notification.cache.diagnostic.stop.text", (Object[])new Object[0]), (Consumer)new Consumer(this, notification, project){
            final /* synthetic */ RecoveryWorker this$0;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ Project $project;

            public final void consume(AnActionEvent it) {
                this.$notification.expire();
                RecoveryWorker.access$reportStoppedToFus(this.this$0, this.$project);
            }
            {
                this.this$0 = recoveryWorker;
                this.$notification = notification;
                this.$project = project;
            }
        })).addAction((AnAction)DumbAwareAction.create((String)recoveryAction.getPresentableName(), (Consumer)new Consumer(this, notification, recoveryAction, project, next){
            final /* synthetic */ RecoveryWorker this$0;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ RecoveryAction $recoveryAction;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $next;

            public final void consume(AnActionEvent it) {
                this.$notification.expire();
                this.this$0.perform(this.$recoveryAction, this.$project, this.$next);
            }
            {
                this.this$0 = recoveryWorker;
                this.$notification = notification;
                this.$recoveryAction = recoveryAction;
                this.$project = project;
                this.$next = n;
            }
        })).setImportant(true).notify(project);
    }

    private final boolean hasNextRecoveryAction(Project project) {
        if (this.next != null) {
            return true;
        }
        while (this.actionSeq.hasNext()) {
            RecoveryAction recoveryAction = this.next = this.actionSeq.next();
            Intrinsics.checkNotNull((Object)recoveryAction);
            if (!recoveryAction.canBeApplied(project)) continue;
            return true;
        }
        this.next = null;
        return false;
    }

    private final RecoveryAction nextRecoveryAction(Project project) {
        boolean bl = this.hasNextRecoveryAction(project);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        RecoveryAction recoveryAction = this.next;
        Intrinsics.checkNotNull((Object)recoveryAction);
        return recoveryAction;
    }

    private final void reportStoppedToFus(Project project) {
        CacheRecoveryUsageCollector.Companion.recordGuideStoppedEvent(project);
    }

    @NotNull
    public final Collection<RecoveryAction> getActions() {
        return this.actions;
    }

    public RecoveryWorker(@NotNull Collection<? extends RecoveryAction> actions2) {
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.actions = actions2;
        this.actionSeq = this.actions.iterator();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecoveryWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$hasNextRecoveryAction(RecoveryWorker $this, Project project) {
        return $this.hasNextRecoveryAction(project);
    }

    public static final /* synthetic */ void access$askUserToContinue(RecoveryWorker $this, Project project, RecoveryAction previousRecoveryAction, int idx) {
        $this.askUserToContinue(project, previousRecoveryAction, idx);
    }

    public static final /* synthetic */ void access$reportStoppedToFus(RecoveryWorker $this, Project project) {
        $this.reportStoppedToFus(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/cache/RecoveryWorker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

