/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CommonActionsPanel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "Adapter", "Companion", "intellij.platform.lang.impl"})
public final class BookmarksListProviderService {
    private final AtomicReference<List<BookmarksListProvider>> reference;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BookmarksListProviderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.reference = new AtomicReference();
        BookmarksListProvider.EP.addChangeListener((AreaInstance)project, new Runnable(){

            @Override
            public final void run() {
                reference.set(null);
            }
        }, (Disposable)project);
        FavoritesListProvider.EP_NAME.getPoint((AreaInstance)project).addChangeListener(new Runnable(){

            @Override
            public final void run() {
                reference.set(null);
            }
        }, (Disposable)project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u000f\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0018\u00010\u0011\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0012H\u0016J\u0014\u0010\u0013\u001a\u000e\u0018\u00010\u0011\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService$Adapter;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/ide/favoritesTreeView/FavoritesListProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/favoritesTreeView/FavoritesListProvider;)V", "canDelete", "", "selection", "", "canEdit", "", "createNode", "Lcom/intellij/ide/favoritesTreeView/FavoritesListNode;", "Lorg/jetbrains/annotations/Nullable;", "getDeleteActionText", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "getEditActionText", "getProject", "getWeight", "", "performDelete", "", "parent", "Ljavax/swing/JComponent;", "performEdit", "intellij.platform.lang.impl"})
    private static final class Adapter
    implements BookmarksListProvider {
        private final Project project;
        private final FavoritesListProvider provider;

        @NotNull
        public Project getProject() {
            return this.project;
        }

        public int getWeight() {
            return this.provider.getWeight();
        }

        @Nullable
        public FavoritesListNode createNode() {
            return this.provider.createFavoriteListNode(this.project);
        }

        @Nullable
        public String getEditActionText() {
            return this.provider.getCustomName(CommonActionsPanel.Buttons.EDIT);
        }

        public boolean canEdit(@NotNull Object selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return this.provider.willHandle(CommonActionsPanel.Buttons.EDIT, this.project, SetsKt.setOf((Object)selection));
        }

        public void performEdit(@NotNull Object selection, @NotNull JComponent parent) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.provider.handle(CommonActionsPanel.Buttons.EDIT, this.project, SetsKt.setOf((Object)selection), parent);
        }

        @Nullable
        public String getDeleteActionText() {
            return this.provider.getCustomName(CommonActionsPanel.Buttons.REMOVE);
        }

        public boolean canDelete(@NotNull List<?> selection) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            return this.provider.willHandle(CommonActionsPanel.Buttons.REMOVE, this.project, CollectionsKt.toSet((Iterable)selection));
        }

        public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.provider.handle(CommonActionsPanel.Buttons.REMOVE, this.project, CollectionsKt.toSet((Iterable)selection), parent);
        }

        public Adapter(@NotNull Project project, @NotNull FavoritesListProvider provider2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            this.project = project;
            this.provider = provider2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/bookmark/BookmarksListProviderService$Companion;", "", "()V", "createProviders", "", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "findProvider", "predicate", "Lkotlin/Function1;", "", "getProviders", "intellij.platform.lang.impl"})
    public static final class Companion {
        @Nullable
        public final BookmarksListProvider findProvider(@NotNull Project project, @NotNull Function1<? super BookmarksListProvider, Boolean> predicate2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
                Iterable iterable = this.getProviders(project);
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    if (!((Boolean)predicate2.invoke(t)).booleanValue()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final List<BookmarksListProvider> getProviders(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDisposed()) {
                return CollectionsKt.emptyList();
            }
            Object object = (BookmarksListProviderService)project.getService(BookmarksListProviderService.class);
            if (object == null || (object = ((BookmarksListProviderService)object).reference) == null) {
                return CollectionsKt.emptyList();
            }
            Object reference2 = object;
            List<BookmarksListProvider> list2 = (List<BookmarksListProvider>)((AtomicReference)reference2).get();
            if (list2 == null) {
                List<BookmarksListProvider> list3 = this.createProviders(project);
                boolean bl = false;
                boolean bl2 = false;
                List<BookmarksListProvider> it = list3;
                boolean bl3 = false;
                ((AtomicReference)reference2).set(it);
                list2 = list3;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<BookmarksListProvider> createProviders(Project project) {
            List list2 = BookmarksListProvider.EP.getExtensions((AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"BookmarksListProvider.EP.getExtensions(project)");
            List providers = CollectionsKt.toMutableList((Collection)list2);
            List list3 = FavoritesListProvider.EP_NAME.getExtensionList((AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"FavoritesListProvider.EP\u2026getExtensionList(project)");
            Iterable $this$mapTo$iv = list3;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FavoritesListProvider favoritesListProvider = (FavoritesListProvider)item$iv;
                Collection collection = providers;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                Adapter adapter = new Adapter(project, (FavoritesListProvider)v2);
                collection.add(adapter);
            }
            List $this$sortByDescending$iv = providers;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                boolean bl = false;
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BookmarksListProvider it = (BookmarksListProvider)b;
                        boolean bl2 = false;
                        BookmarksListProvider bookmarksListProvider = it;
                        Intrinsics.checkNotNullExpressionValue((Object)bookmarksListProvider, (String)"it");
                        it = (BookmarksListProvider)a;
                        Comparable comparable = Integer.valueOf(bookmarksListProvider.getWeight());
                        bl2 = false;
                        BookmarksListProvider bookmarksListProvider2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)bookmarksListProvider2, (String)"it");
                        Integer n = bookmarksListProvider2.getWeight();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                    }
                });
            }
            List<BookmarksListProvider> list4 = Collections.unmodifiableList(providers);
            Intrinsics.checkNotNullExpressionValue(list4, (String)"unmodifiableList(providers)");
            return list4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

