/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0012\u0010\u0014\u001a\f0\f\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksSelectInTarget;", "Lcom/intellij/ide/SelectInTarget;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "canSelect", "", "context", "Lcom/intellij/ide/SelectInContext;", "getToolWindowId", "", "getWeight", "", "selectIn", "", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "requestFocus", "toString", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
public final class BookmarksSelectInTarget
implements SelectInTarget {
    @NotNull
    private final Project project;

    @NotNull
    public String toString() {
        String string = BookmarkBundle.message("select.in.target.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"select.in.target.name\")");
        return string;
    }

    @NotNull
    public String getToolWindowId() {
        return "Bookmarks";
    }

    public float getWeight() {
        return 1.001f;
    }

    public boolean canSelect(@Nullable SelectInContext context2) {
        boolean bl;
        block5: {
            SelectInContext selectInContext = context2;
            if (selectInContext == null || (selectInContext = selectInContext.getVirtualFile()) == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)selectInContext, (String)"context?.virtualFile ?: return false");
            SelectInContext file2 = selectInContext;
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
            if (bookmarksManager == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInst\u2026(project) ?: return false");
            BookmarksManager manager2 = bookmarksManager;
            List list2 = manager2.getBookmarks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manager.bookmarks");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile ancestor;
                    Bookmark it = (Bookmark)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = it instanceof FileBookmark ? ((ancestor = ((FileBookmark)it).getFile()).isDirectory() ? VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false) : Intrinsics.areEqual((Object)ancestor, (Object)file2)) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void selectIn(@NotNull SelectInContext context2, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Bookmarks");
        if (toolWindow2 == null) {
            return;
        }
        ToolWindow window = toolWindow2;
        ContentManager contentManager2 = window.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"window.contentManager");
        Content content2 = contentManager2.getSelectedContent();
        JComponent jComponent = content2 != null ? content2.getComponent() : null;
        if (!(jComponent instanceof BookmarksView)) {
            jComponent = null;
        }
        BookmarksView bookmarksView = (BookmarksView)((Object)jComponent);
        if (bookmarksView == null) {
            return;
        }
        BookmarksView view = bookmarksView;
        boolean bl = requestFocus;
        if (bl) {
            window.activate(new Runnable(this, context2, view){
                final /* synthetic */ BookmarksSelectInTarget this$0;
                final /* synthetic */ SelectInContext $context;
                final /* synthetic */ BookmarksView $view;

                public final void run() {
                    BookmarksSelectInTarget.access$selectIn(this.this$0, this.$context, this.$view);
                }
                {
                    this.this$0 = bookmarksSelectInTarget;
                    this.$context = selectInContext;
                    this.$view = bookmarksView;
                }
            });
        } else {
            window.show(new Runnable(this, context2, view){
                final /* synthetic */ BookmarksSelectInTarget this$0;
                final /* synthetic */ SelectInContext $context;
                final /* synthetic */ BookmarksView $view;

                public final void run() {
                    BookmarksSelectInTarget.access$selectIn(this.this$0, this.$context, this.$view);
                }
                {
                    this.this$0 = bookmarksSelectInTarget;
                    this.$context = selectInContext;
                    this.$view = bookmarksView;
                }
            });
        }
    }

    private final void selectIn(SelectInContext context2, BookmarksView view) {
        VirtualFile virtualFile2 = context2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"context.virtualFile");
        view.select(virtualFile2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public BookmarksSelectInTarget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ void access$selectIn(BookmarksSelectInTarget $this, SelectInContext context2, BookmarksView view) {
        $this.selectIn(context2, view);
    }
}

