/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.ContextMenuActionGroup;
import com.intellij.ide.bookmark.ui.DragAndDropHandler;
import com.intellij.ide.bookmark.ui.ExtensionsKt;
import com.intellij.ide.bookmark.ui.GroupBookmarkVisitor;
import com.intellij.ide.bookmark.ui.IdeViewForBookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarksTreeStructure;
import com.intellij.ide.bookmark.ui.tree.FolderNodeComparator;
import com.intellij.ide.bookmark.ui.tree.FolderNodeUpdater;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.preview.DescriptorPreview;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.Function;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010D\u001a\u00020EH\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020IH\u0016J\u0012\u0010J\u001a\f0I\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\bLH\u0016J\u0012\u0010M\u001a\f0I\u00a2\u0006\u0002\bK\u00a2\u0006\u0002\bLH\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020\u001cH\u0002J\n\u0010Q\u001a\u0004\u0018\u00010OH\u0016J\n\u0010R\u001a\u0004\u0018\u00010OH\u0016J\b\u0010S\u001a\u00020\bH\u0016J\b\u0010T\u001a\u00020\bH\u0016J\b\u0010U\u001a\u00020EH\u0014J\u0010\u0010V\u001a\u00020E2\u0006\u0010W\u001a\u00020\bH\u0002J\b\u0010X\u001a\u00020EH\u0014J!\u0010Y\u001a\u0015\u0012\f\u0012\n \\*\u0004\u0018\u00010[0[0Z\u00a2\u0006\u0002\bL2\u0006\u0010]\u001a\u00020^J)\u0010Y\u001a\u0015\u0012\f\u0012\n \\*\u0004\u0018\u00010[0[0Z\u00a2\u0006\u0002\bL2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`J\u000e\u0010Y\u001a\u00020E2\u0006\u0010a\u001a\u00020+J+\u0010Y\u001a\u0015\u0012\f\u0012\n \\*\u0004\u0018\u00010[0[0Z\u00a2\u0006\u0002\bL2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\bH\u0002J\u0012\u0010e\u001a\u00020E2\b\b\u0002\u0010f\u001a\u00020\bH\u0002J\u0010\u0010g\u001a\u00020E2\u0006\u0010h\u001a\u00020\bH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\r\u0012\u0002\b\u0003\u0018\u00010/\u00a2\u0006\u0002\b08F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\"\u00103\u001a\u0013\u0012\r\u0012\u000b\u0012\u0002\b\u00030/\u00a2\u0006\u0002\b0\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010-R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\rR\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ui/OnePixelSplitter;", "project", "Lcom/intellij/openapi/project/Project;", "showToolbar", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)V", "autoScrollFromSource", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getAutoScrollFromSource", "()Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "autoScrollToSource", "getAutoScrollToSource", "groupLineBookmarks", "getGroupLineBookmarks", "ideView", "Lcom/intellij/ide/bookmark/ui/IdeViewForBookmarksView;", "isPopup", "()Z", "model", "Lcom/intellij/ui/tree/StructureTreeModel;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarksTreeStructure;", "getModel", "()Lcom/intellij/ui/tree/StructureTreeModel;", "nextOccurrence", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getNextOccurrence", "()Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "openInPreviewTab", "getOpenInPreviewTab", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "preview", "Lcom/intellij/ui/preview/DescriptorPreview;", "previousOccurrence", "getPreviousOccurrence", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSelectedFiles", "()Ljava/util/List;", "selectedNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Lorg/jetbrains/annotations/Nullable;", "getSelectedNode", "()Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "selectedNodes", "getSelectedNodes", "selectionAlarm", "Lcom/intellij/util/SingleAlarm;", "showPreview", "getShowPreview", "state", "Lcom/intellij/ide/bookmark/ui/BookmarksViewState;", "structure", "tree", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "getTree", "()Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "updater", "Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "dispose", "", "getData", "", "dataId", "", "getNextOccurenceActionName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getPreviousOccurenceActionName", "go", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "occurrence", "goNextOccurence", "goPreviousOccurence", "hasNextOccurence", "hasPreviousOccurence", "loadProportion", "navigateToSource", "requestFocus", "saveProportion", "select", "Lorg/jetbrains/concurrency/Promise;", "Ljavax/swing/tree/TreePath;", "kotlin.jvm.PlatformType", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "file", "visitor", "Lcom/intellij/ui/tree/TreeVisitor;", "centered", "selectionChanged", "autoScroll", "setOrientation", "vertical", "intellij.platform.lang.impl"})
public final class BookmarksView
extends OnePixelSplitter
implements Disposable,
DataProvider,
OccurenceNavigator {
    private final boolean isPopup;
    private final BookmarksViewState state;
    private final DescriptorPreview preview;
    private final SingleAlarm selectionAlarm;
    private final BookmarksTreeStructure structure;
    @NotNull
    private final StructureTreeModel<BookmarksTreeStructure> model;
    @NotNull
    private final DnDAwareTree tree;
    private final DefaultTreeExpander treeExpander;
    private final BorderLayoutPanel panel;
    private final FolderNodeUpdater updater;
    private final IdeViewForBookmarksView ideView;
    @NotNull
    private final ToggleOptionAction.Option groupLineBookmarks;
    @NotNull
    private final ToggleOptionAction.Option autoScrollFromSource;
    @NotNull
    private final ToggleOptionAction.Option autoScrollToSource;
    @NotNull
    private final ToggleOptionAction.Option openInPreviewTab;
    @NotNull
    private final ToggleOptionAction.Option showPreview;
    @NotNull
    private final Project project;

    public final boolean isPopup() {
        return this.isPopup;
    }

    @NotNull
    public final StructureTreeModel<BookmarksTreeStructure> getModel() {
        return this.model;
    }

    @NotNull
    public final DnDAwareTree getTree() {
        return this.tree;
    }

    @Nullable
    public final AbstractTreeNode<?> getSelectedNode() {
        return TreeUtil.getAbstractTreeNode((TreePath)TreeUtil.getSelectedPathIfOne((JTree)((JTree)((Object)this.tree))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<AbstractTreeNode<?>> getSelectedNodes() {
        List list2;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            TreePath[] $this$mapNotNull$iv = treePathArray;
            boolean $i$f$mapNotNull = false;
            TreePath[] treePathArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var8_9 = $this$forEach$iv$iv$iv;
            int n = ((void)var8_9).length;
            for (int j = 0; j < n; ++j) {
                AbstractTreeNode abstractTreeNode;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var8_9[j];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (TreeUtil.getAbstractTreeNode((TreePath)it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AbstractTreeNode it$iv$iv = abstractTreeNode;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            boolean bl = false;
            if (collection2.isEmpty()) {
                boolean bl6 = false;
                collection = null;
            } else {
                collection = collection2;
            }
            list2 = (List)collection;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> getSelectedFiles() {
        void $this$mapNotNullTo$iv$iv;
        List<AbstractTreeNode<?>> list2 = this.getSelectedNodes();
        if (list2 == null) {
            return null;
        }
        List<AbstractTreeNode<?>> nodes = list2;
        Iterable $this$mapNotNull$iv = nodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl2 = false;
            AbstractTreeNode abstractTreeNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)abstractTreeNode, (String)"it");
            if (ExtensionsKt.getAsVirtualFile(abstractTreeNode) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        return files2.size() == nodes.size() ? files2 : null;
    }

    private final BookmarkOccurrence getPreviousOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.lastLineBookmark(this.project) : occurrence.previousLineBookmark();
    }

    private final BookmarkOccurrence getNextOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.firstLineBookmark(this.project) : occurrence.nextLineBookmark();
    }

    public void dispose() {
        this.preview.close();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            object = this.ideView;
        } else if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            object = this.treeExpander;
        } else if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            List<AbstractTreeNode<?>> list2 = this.getSelectedNodes();
            object = list2 != null ? UtilKt.toArray((Collection)list2, (Object[])new Object[0]) : null;
        } else if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            List<AbstractTreeNode<?>> list3 = this.getSelectedNodes();
            object = list3 != null ? (VirtualFile[])CollectionsKt.firstOrNull(list3) : null;
        } else if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            object = abstractTreeNode != null ? ExtensionsKt.getAsVirtualFile(abstractTreeNode) : null;
        } else if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            List<VirtualFile> list4 = this.getSelectedFiles();
            if (list4 != null) {
                Collection $this$toTypedArray$iv = list4;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
                if (virtualFileArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object = virtualFileArray;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = BookmarkBundle.message("bookmark.go.to.next.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BookmarkBundle.message(\"\u2026t.occurence.action.text\")");
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = BookmarkBundle.message("bookmark.go.to.previous.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BookmarkBundle.message(\"\u2026s.occurence.action.text\")");
        return string;
    }

    public boolean hasNextOccurence() {
        return this.getNextOccurrence() != null;
    }

    public boolean hasPreviousOccurence() {
        return this.getPreviousOccurrence() != null;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getNextOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence bookmarkOccurrence2 = bookmarkOccurrence;
            boolean bl = false;
            boolean bl2 = false;
            BookmarkOccurrence it = bookmarkOccurrence2;
            boolean bl3 = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getPreviousOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence bookmarkOccurrence2 = bookmarkOccurrence;
            boolean bl = false;
            boolean bl2 = false;
            BookmarkOccurrence it = bookmarkOccurrence2;
            boolean bl3 = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    private final OccurenceNavigator.OccurenceInfo go(BookmarkOccurrence occurrence) {
        this.select(occurrence.getGroup(), occurrence.getBookmark()).onSuccess(new Consumer(this){
            final /* synthetic */ BookmarksView this$0;

            public final void accept(TreePath it) {
                BookmarksView.access$navigateToSource(this.this$0, true);
            }
            {
                this.this$0 = bookmarksView;
            }
        });
        return null;
    }

    public final void select(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updater.updateImmediately(new Runnable(this, file2){
            final /* synthetic */ BookmarksView this$0;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                BookmarksView.access$select(this.this$0, new VirtualFileVisitor(this.$file, null), true);
            }
            {
                this.this$0 = bookmarksView;
                this.$file = virtualFile2;
            }
        });
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return this.select(new GroupBookmarkVisitor(group2, null, 2, null), true);
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return this.select(new GroupBookmarkVisitor(group2, bookmark), false);
    }

    private final Promise<TreePath> select(TreeVisitor visitor, boolean centered) {
        Promise promise = TreeUtil.promiseMakeVisible((JTree)((JTree)((Object)this.tree)), (TreeVisitor)visitor).onSuccess(new Consumer(this, centered){
            final /* synthetic */ BookmarksView this$0;
            final /* synthetic */ boolean $centered;

            public final void accept(TreePath it) {
                this.this$0.getTree().setSelectionPath(it);
                TreeUtil.scrollToVisible((JTree)((JTree)((Object)this.this$0.getTree())), (TreePath)it, (boolean)this.$centered);
                if (!this.this$0.getTree().hasFocus()) {
                    BookmarksView.selectionChanged$default(this.this$0, false, 1, null);
                }
            }
            {
                this.this$0 = bookmarksView;
                this.$centered = bl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"TreeUtil.promiseMakeVisi\u2026)) selectionChanged()\n  }");
        return promise;
    }

    protected void saveProportion() {
        block1: {
            block0: {
                boolean bl = this.isPopup;
                if (!bl) break block0;
                BookmarksViewState bookmarksViewState = this.state;
                if (bookmarksViewState == null) break block1;
                bookmarksViewState.setProportionPopup(this.getProportion());
                break block1;
            }
            BookmarksViewState bookmarksViewState = this.state;
            if (bookmarksViewState == null) break block1;
            bookmarksViewState.setProportionView(this.getProportion());
        }
    }

    protected void loadProportion() {
        boolean bl = this.isPopup;
        if (bl) {
            this.setProportion(this.state.getProportionPopup());
        } else {
            this.setProportion(this.state.getProportionView());
        }
    }

    public void setOrientation(boolean vertical) {
        super.setOrientation(vertical);
        this.selectionChanged(false);
    }

    @NotNull
    public final ToggleOptionAction.Option getGroupLineBookmarks() {
        return this.groupLineBookmarks;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollFromSource() {
        return this.autoScrollFromSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollToSource() {
        return this.autoScrollToSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getOpenInPreviewTab() {
        return this.openInPreviewTab;
    }

    @NotNull
    public final ToggleOptionAction.Option getShowPreview() {
        return this.showPreview;
    }

    private final void selectionChanged(boolean autoScroll) {
        if (this.isPopup || !this.openInPreviewTab.isEnabled()) {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            this.preview.open((OpenFileDescriptor)(abstractTreeNode != null ? ExtensionsKt.getAsDescriptor(abstractTreeNode) : null));
        } else {
            this.preview.close();
            if (autoScroll && (this.autoScrollToSource.isSelected() || this.openInPreviewTab.isSelected())) {
                this.navigateToSource(false);
            }
        }
    }

    static /* synthetic */ void selectionChanged$default(BookmarksView bookmarksView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bookmarksView.tree.hasFocus();
        }
        bookmarksView.selectionChanged(bl);
    }

    private final void navigateToSource(boolean requestFocus) {
        block1: {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            if (abstractTreeNode == null) {
                return;
            }
            AbstractTreeNode<?> node2 = abstractTreeNode;
            Runnable task2 = new Runnable(requestFocus, node2){
                final /* synthetic */ boolean $requestFocus;
                final /* synthetic */ AbstractTreeNode $node;

                public final void run() {
                    OpenSourceUtil.navigateToSource((boolean)this.$requestFocus, (boolean)false, (Navigatable)((Navigatable)this.$node));
                }
                {
                    this.$requestFocus = bl;
                    this.$node = abstractTreeNode;
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application == null) break block1;
            application.invokeLater(task2, ModalityState.stateForComponent((Component)((Component)((Object)this.tree))), new Condition(this){
                final /* synthetic */ BookmarksView this$0;

                public final boolean value(Object it) {
                    return this.this$0.getProject().isDisposed();
                }
                {
                    this.this$0 = bookmarksView;
                }
            });
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public BookmarksView(@NotNull Project project, @Nullable Boolean showToolbar) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, 0.3f, 0.1f, 0.9f);
        this.project = project;
        this.isPopup = showToolbar == null;
        this.state = BookmarksViewState.Companion.getInstance(this.project);
        this.preview = new DescriptorPreview((Splitter)this, false, null);
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                BookmarksView.selectionChanged$default((BookmarksView)this.receiver, false, 1, null);
            }
        };
        Runnable runnable2 = new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        };
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(this)");
        this.selectionAlarm = new SingleAlarm(runnable2, 50, modalityState, (Disposable)this);
        this.structure = new BookmarksTreeStructure(this);
        this.model = new StructureTreeModel<AbstractTreeStructure>(this.structure, new FolderNodeComparator(this.project), this);
        this.tree = new DnDAwareTree((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.model), this)));
        this.treeExpander = new DefaultTreeExpander((JTree)((Object)this.tree));
        this.panel = new BorderLayoutPanel();
        this.updater = new FolderNodeUpdater(this);
        this.ideView = new IdeViewForBookmarksView(this);
        this.groupLineBookmarks = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;

            public boolean isEnabled() {
                return !this.this$0.isPopup();
            }

            public boolean isSelected() {
                return this.isEnabled() && BookmarksView.access$getState$p(this.this$0).getGroupLineBookmarks();
            }

            public void setSelected(boolean selected2) {
                BookmarksView.access$getState$p(this.this$0).setGroupLineBookmarks(selected2);
                this.this$0.getModel().invalidate();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.autoScrollFromSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;

            public boolean isEnabled() {
                return false;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollFromSource();
            }

            public void setSelected(boolean selected2) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollFromSource(selected2);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.autoScrollToSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;

            public boolean isEnabled() {
                return this.this$0.getOpenInPreviewTab().isEnabled();
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollToSource();
            }

            public void setSelected(boolean selected2) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollToSource(selected2);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.openInPreviewTab = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;

            public boolean isEnabled() {
                return this.this$0.isVertical() || !BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public boolean isSelected() {
                return UISettings.Companion.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected2) {
                UISettings.Companion.getInstance().setOpenInPreviewTabIfPossible(selected2);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.showPreview = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;

            public boolean isAlwaysVisible() {
                return !this.this$0.isVertical();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isEnabled() {
                if (this.this$0.isVertical()) return false;
                AbstractTreeNode<?> abstractTreeNode = this.this$0.getSelectedNode();
                if (abstractTreeNode == null) return false;
                boolean bl = abstractTreeNode.canNavigateToSource();
                if (!bl) return false;
                return true;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public void setSelected(boolean selected2) {
                BookmarksView.access$getState$p(this.this$0).setShowPreview(selected2);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.panel.addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree)), (boolean)true));
        this.panel.putClientProperty(FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, (Object)true);
        this.setFirstComponent((JComponent)this.panel);
        this.tree.setHorizontalAutoScrollingEnabled(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (!this.isPopup) {
            DragAndDropHandler handler2 = new DragAndDropHandler(this);
            Function1 function1 = (Function1)new Function1<DnDActionInfo, DnDDragStartBean>(handler2){

                @Nullable
                public final DnDDragStartBean invoke(@NotNull DnDActionInfo p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((DragAndDropHandler)this.receiver).createBean(p1);
                }
            };
            DnDSupport.createBuilder((JComponent)((JComponent)((Object)this.tree))).setDisposableParent((Disposable)this).setBeanProvider(new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object fun(Object p0) {
                    return this.function.invoke(p0);
                }
            }).setDropHandlerWithResult((DnDDropHandler.WithResult)handler2).setTargetChecker((DnDTargetChecker)handler2).enableAsNativeTarget().install();
        }
        StatusText statusText2 = this.tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"tree.emptyText");
        ExtensionsKt.initialize(statusText2, (Component)((Object)this.tree));
        this.tree.addTreeSelectionListener(new RestoreSelectionListener());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                if (this.getTree().hasFocus()) {
                    SingleAlarm.cancelAndRequest$default((SingleAlarm)selectionAlarm, (boolean)false, (int)1, null);
                }
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(@Nullable FocusEvent event) {
            }

            @Override
            public void focusGained(@Nullable FocusEvent event) {
                SingleAlarm.cancelAndRequest$default((SingleAlarm)selectionAlarm, (boolean)false, (int)1, null);
            }
        });
        new TreeSpeedSearch((JTree)((Object)this.tree));
        TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)this.tree)));
        EditSourceOnEnterKeyHandler.install((JTree)((JTree)((Object)this.tree)));
        EditSourceOnDoubleClickHandler.install((JTree)((JTree)((Object)this.tree)));
        new ContextMenuActionGroup((JTree)((Object)this.tree));
        this.project.getMessageBus().connect((Disposable)this).subscribe(BookmarksListener.TOPIC, (Object)new BookmarksListener(){

            public void groupsSorted() {
                this.getModel().invalidate();
            }

            public void groupAdded(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidate();
            }

            public void groupRemoved(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidate();
            }

            public void groupRenamed(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidate();
            }

            public void bookmarksSorted(@NotNull BookmarkGroup group2) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                this.getModel().invalidate();
            }

            public void bookmarkAdded(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidate();
            }

            public void bookmarkRemoved(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidate();
            }

            public void bookmarkChanged(@NotNull BookmarkGroup group2, @NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidate();
            }

            public void bookmarkTypeChanged(@NotNull Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel().invalidate();
            }

            public void defaultGroupChanged(@Nullable BookmarkGroup oldGroup, @Nullable BookmarkGroup newGroup) {
                this.getModel().invalidate();
            }

            public void structureChanged(@Nullable Object node2) {
                Object object = node2;
                if (object == null) {
                    Intrinsics.checkNotNullExpressionValue(this.getModel().invalidate(), (String)"model.invalidate()");
                } else {
                    Intrinsics.checkNotNullExpressionValue(this.getModel().invalidate(node2, true), (String)"model.invalidate(node, true)");
                }
            }
        });
    }

    public static final /* synthetic */ void access$navigateToSource(BookmarksView $this, boolean requestFocus) {
        $this.navigateToSource(requestFocus);
    }

    public static final /* synthetic */ Promise access$select(BookmarksView $this, TreeVisitor visitor, boolean centered) {
        return $this.select(visitor, centered);
    }

    public static final /* synthetic */ BookmarksViewState access$getState$p(BookmarksView $this) {
        return $this.state;
    }
}

