/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksViewFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "()V", "orientation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "stateChanged", "manager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.platform.lang.impl"})
public final class BookmarksViewFactory
implements DumbAware,
ToolWindowFactory,
ToolWindowManagerListener {
    private final AtomicBoolean orientation = new AtomicBoolean(true);

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow window) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        ContentManager contentManager2 = window.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"window.contentManager");
        ContentManager manager2 = contentManager2;
        BookmarksView bookmarksView = new BookmarksView(project, ToggleToolbarAction.isToolbarVisible(window, project));
        boolean bl = false;
        boolean bl2 = false;
        BookmarksView it = bookmarksView;
        boolean bl3 = false;
        it.setOrientation(this.orientation.get());
        BookmarksView panel2 = bookmarksView;
        bookmarksView = manager2.getFactory().createContent((JComponent)((Object)panel2), null, false);
        bl = false;
        bl2 = false;
        it = bookmarksView;
        ContentManager contentManager3 = manager2;
        boolean bl4 = false;
        $this$apply.setCloseable(false);
        Unit unit = Unit.INSTANCE;
        contentManager3.addContent((Content)bookmarksView);
        project.getMessageBus().connect((Disposable)manager2).subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
        window.setHelpId("bookmarks.tool.window.help");
        window.setTitleActions(CollectionsKt.listOfNotNull((Object)ActionUtil.getAction((String)"Bookmarks.ToolWindow.TitleActions")));
        if (window instanceof ToolWindowEx) {
            ((ToolWindowEx)window).setAdditionalGearActions(ActionUtil.getActionGroup((String)"Bookmarks.ToolWindow.GearActions"));
        }
    }

    @Override
    public void stateChanged(@NotNull ToolWindowManager manager2) {
        boolean vertical;
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        ToolWindow toolWindow2 = manager2.getToolWindow("Bookmarks");
        if (toolWindow2 == null) {
            return;
        }
        ToolWindow window = toolWindow2;
        if (window.isDisposed()) {
            return;
        }
        ToolWindowAnchor toolWindowAnchor = window.getAnchor();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"window.anchor");
        boolean bl = vertical = !toolWindowAnchor.isHorizontal();
        if (vertical != this.orientation.getAndSet(vertical)) {
            ContentManager contentManager2 = window.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"window.contentManager");
            Content[] contentArray = contentManager2.getContents();
            int n = contentArray.length;
            for (int j = 0; j < n; ++j) {
                Splittable splittable;
                Content content2;
                Content content3 = content2 = contentArray[j];
                JComponent jComponent = content3 != null ? content3.getComponent() : null;
                if (!(jComponent instanceof Splittable)) {
                    jComponent = null;
                }
                Splittable splittable2 = splittable = (Splittable)jComponent;
                if (splittable2 == null) continue;
                splittable2.setOrientation(vertical);
            }
        }
    }
}

