/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/ide/bookmark/FileBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/FileBookmark;)V", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class FolderNode
extends BookmarkNode<FileBookmark> {
    @NotNull
    public VirtualFile getVirtualFile() {
        return ((FileBookmark)this.getValue()).getFile();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        FileBookmark fileBookmark = (FileBookmark)this.getValue();
        PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)(fileBookmark != null ? fileBookmark.getFile() : null));
        if (!(psiFileSystemItem instanceof PsiDirectory)) {
            psiFileSystemItem = null;
        }
        PsiDirectory psiDirectory = (PsiDirectory)psiFileSystemItem;
        if (psiDirectory == null) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory directory = psiDirectory;
        Collection<AbstractTreeNode<?>> collection = ProjectViewDirectoryHelper.getInstance(this.getProject()).getDirectoryChildren(directory, this.getSettings(), true);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"ProjectViewDirectoryHelp\u2026irectory, settings, true)");
        return collection;
    }

    public FolderNode(@NotNull Project project, @NotNull FileBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project, (Bookmark)bookmark);
    }
}

