/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "Lcom/intellij/ui/tree/project/ProjectFileNodeUpdater;", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "(Lcom/intellij/ide/bookmark/ui/BookmarksView;)V", "getView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "forEachTreePath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Ljavax/swing/tree/TreePath;", "invalidate", "structure", "", "updateStructure", "fromRoot", "updatedFiles", "", "intellij.platform.lang.impl"})
public final class FolderNodeUpdater
extends ProjectFileNodeUpdater {
    @NotNull
    private final BookmarksView view;

    @Override
    protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
        Intrinsics.checkNotNullParameter(updatedFiles, (String)"updatedFiles");
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.view.getProject());
        if (bookmarksManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInst\u2026e(view.project) ?: return");
        BookmarksManager manager2 = bookmarksManager;
        boolean bl = false;
        Set bookmarkedFiles = new LinkedHashSet();
        List list2 = manager2.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manager.bookmarks");
        Iterable $this$mapNotNullTo$iv = list2;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv = iterator2.next();
            Object element$iv = element$iv$iv;
            boolean bl2 = false;
            Bookmark it = (Bookmark)element$iv;
            boolean bl3 = false;
            if ((it instanceof FileBookmark && ((FileBookmark)it).getFile().isValid() ? ((FileBookmark)it).getFile() : null) == null) continue;
            virtualFile2 = virtualFile2;
            boolean bl4 = false;
            boolean bl5 = false;
            VirtualFile it$iv = virtualFile2;
            boolean bl6 = false;
            ((Collection)bookmarkedFiles).add(it$iv);
        }
        if (bookmarkedFiles.isEmpty()) {
            return;
        }
        $i$f$mapNotNullTo = false;
        Set roots2 = new LinkedHashSet();
        for (VirtualFile bookmarkedFile : bookmarkedFiles) {
            TreeCollector collector;
            if (fromRoot || updatedFiles.contains(bookmarkedFile)) {
                roots2.add(bookmarkedFile);
                continue;
            }
            if (!bookmarkedFile.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)TreeCollector.VirtualFileRoots.create(), (String)"TreeCollector.VirtualFileRoots.create()");
            for (VirtualFile virtualFile3 : updatedFiles) {
                VirtualFile root2;
                VirtualFile virtualFile4;
                if (virtualFile3.isDirectory()) {
                    virtualFile4 = virtualFile3;
                } else {
                    virtualFile4 = virtualFile3.getParent();
                    if (virtualFile4 == null) {
                        continue;
                    }
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)bookmarkedFile, (VirtualFile)(root2 = virtualFile4), (boolean)false)) continue;
                collector.add((Object)virtualFile3);
            }
            List list3 = collector.get();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"collector.get()");
            roots2.addAll(list3);
        }
        Iterable $this$forEach$iv = roots2;
        boolean $i$f$forEach2 = false;
        for (Object t : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)t;
            boolean bl7 = false;
            this.invalidate(it, true);
        }
    }

    public final void invalidate(@NotNull VirtualFile file2, boolean structure) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.forEachTreePath(file2, (Function1<? super TreePath, Unit>)((Function1)new Function1<TreePath, Unit>(this, structure){
            final /* synthetic */ FolderNodeUpdater this$0;
            final /* synthetic */ boolean $structure;

            public final void invoke(@NotNull TreePath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getView().getModel().invalidate(it, this.$structure);
            }
            {
                this.this$0 = folderNodeUpdater;
                this.$structure = bl;
                super(1);
            }
        }));
    }

    private final void forEachTreePath(VirtualFile file2, Function1<? super TreePath, Unit> action2) {
        TreeModel treeModel = this.view.getTree().getModel();
        if (!(treeModel instanceof AsyncTreeModel)) {
            treeModel = null;
        }
        AsyncTreeModel asyncTreeModel = (AsyncTreeModel)((Object)treeModel);
        if (asyncTreeModel == null) {
            return;
        }
        AsyncTreeModel model2 = asyncTreeModel;
        boolean bl = false;
        List paths2 = new ArrayList();
        model2.accept(new VirtualFileVisitor(file2, paths2), false).onSuccess(new Consumer(paths2, action2){
            final /* synthetic */ List $paths;
            final /* synthetic */ Function1 $action;

            /*
             * WARNING - void declaration
             */
            public final void accept(TreePath it) {
                void $this$forEach$iv;
                Iterable iterable = this.$paths;
                Function1 action$iv = this.$action;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    action$iv.invoke(element$iv);
                }
            }
            {
                this.$paths = list2;
                this.$action = function1;
            }
        });
    }

    @NotNull
    public final BookmarksView getView() {
        return this.view;
    }

    public FolderNodeUpdater(@NotNull BookmarksView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view.getProject(), view.getModel().getInvoker());
        this.view = view;
    }
}

