/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSettingsPanel;
import com.intellij.ide.browsers.BrowserSettingsPanel$$special$;
import com.intellij.ide.browsers.BrowserSettingsPanel$WhenMappings;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellKt;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u000e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/ide/browsers/BrowserSettingsPanel;", "", "()V", "alternativeBrowserPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "browsersEditor", "Lcom/intellij/util/ui/table/TableModelEditor;", "Lcom/intellij/ide/browsers/ConfigurableWebBrowser;", "browsersTable", "Ljavax/swing/JComponent;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "customPathValue", "", "defaultBrowser", "Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "getDefaultBrowser", "()Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "defaultBrowserPolicyComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "isModified", "", "()Z", "previewReloadModeComboBox", "Lcom/intellij/ide/browsers/ReloadMode;", "root", "serverReloadModeComboBox", "showBrowserHover", "Lcom/intellij/ui/components/JBCheckBox;", "showBrowserHoverXml", "apply", "", "reset", "selectBrowser", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "setCustomPathToFirstListed", "updateCustomPathTextFieldValue", "Companion", "intellij.platform.ide.impl"})
public final class BrowserSettingsPanel {
    private JComponent browsersTable;
    private TableModelEditor<ConfigurableWebBrowser> browsersEditor;
    private TextFieldWithBrowseButton alternativeBrowserPathField;
    private ComboBox<DefaultBrowserPolicy> defaultBrowserPolicyComboBox;
    private ComboBox<ReloadMode> serverReloadModeComboBox;
    private ComboBox<ReloadMode> previewReloadModeComboBox;
    private JBCheckBox showBrowserHover;
    private JBCheckBox showBrowserHoverXml;
    private String customPathValue;
    private final JPanel root;
    private static final FileChooserDescriptor APP_FILE_CHOOSER_DESCRIPTOR;
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String> PATH_COLUMN_INFO;
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean> ACTIVE_COLUMN_INFO;
    private static final ColumnInfo<?, ?>[] COLUMNS;
    @NotNull
    public static final Companion Companion;

    private final void updateCustomPathTextFieldValue(DefaultBrowserPolicy browser2) {
        switch (BrowserSettingsPanel$WhenMappings.$EnumSwitchMapping$1[browser2.ordinal()]) {
            case 1: {
                TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
                if (textFieldWithBrowseButton2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                }
                textFieldWithBrowseButton2.setText(this.customPathValue);
                break;
            }
            case 2: {
                this.setCustomPathToFirstListed();
                break;
            }
            default: {
                TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.alternativeBrowserPathField;
                if (textFieldWithBrowseButton3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                }
                textFieldWithBrowseButton3.setText("");
            }
        }
    }

    private final void setCustomPathToFirstListed() {
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
        }
        ListTableModel<ConfigurableWebBrowser> listTableModel = tableModelEditor.getModel();
        Intrinsics.checkNotNullExpressionValue(listTableModel, (String)"browsersEditor.model");
        ListTableModel<ConfigurableWebBrowser> model2 = listTableModel;
        int n = model2.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            ConfigurableWebBrowser browser2;
            ConfigurableWebBrowser configurableWebBrowser = browser2 = (ConfigurableWebBrowser)((Object)model2.getRowValue(i2));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)configurableWebBrowser), (String)"browser");
            if (!configurableWebBrowser.isActive() || browser2.getPath() == null) continue;
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            }
            textFieldWithBrowseButton2.setText(browser2.getPath());
            return;
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
        }
        textFieldWithBrowseButton3.setText("");
    }

    @NotNull
    public final JPanel getComponent() {
        return this.root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        DefaultBrowserPolicy defaultBrowserPolicy = this.getDefaultBrowser();
        WebBrowserManager webBrowserManager = browserManager;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)webBrowserManager), (String)"browserManager");
        if (BrowserSettingsPanel.Companion.getDefaultBrowserPolicy(webBrowserManager) != defaultBrowserPolicy) return true;
        boolean bl = browserManager.isShowBrowserHover();
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
        }
        if (bl != jBCheckBox.isSelected()) return true;
        boolean bl2 = browserManager.isShowBrowserHoverXml();
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
        }
        if (bl2 != jBCheckBox2.isSelected()) return true;
        ReloadMode reloadMode = browserManager.getWebPreviewReloadMode();
        ComboBox<ReloadMode> comboBox2 = this.previewReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
        }
        if (reloadMode != (ReloadMode)comboBox2.getItem()) return true;
        ReloadMode reloadMode2 = browserManager.getWebServerReloadMode();
        ComboBox<ReloadMode> comboBox3 = this.serverReloadModeComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
        }
        if (reloadMode2 != (ReloadMode)comboBox3.getItem()) {
            return true;
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE) {
            GeneralSettings generalSettings2 = generalSettings;
            Intrinsics.checkNotNullExpressionValue((Object)generalSettings2, (String)"generalSettings");
            String string = generalSettings2.getBrowserPath();
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            }
            if (!Comparing.strEqual((String)string, (String)textFieldWithBrowseButton2.getText())) {
                return true;
            }
        }
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
        }
        boolean bl3 = tableModelEditor.isModified();
        return bl3;
    }

    public final void apply() {
        WebBrowserManager browserManager;
        GeneralSettings settings;
        GeneralSettings generalSettings = settings = GeneralSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)generalSettings, (String)"settings");
        generalSettings.setUseDefaultBrowser(this.getDefaultBrowser() == DefaultBrowserPolicy.SYSTEM);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
        }
        if (textFieldWithBrowseButton2.isEnabled()) {
            TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            }
            settings.setBrowserPath(textFieldWithBrowseButton3.getText());
        }
        WebBrowserManager webBrowserManager = browserManager = WebBrowserManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)webBrowserManager), (String)"browserManager");
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
        }
        webBrowserManager.setShowBrowserHover(jBCheckBox.isSelected());
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
        }
        browserManager.setShowBrowserHoverXml(jBCheckBox2.isSelected());
        browserManager.defaultBrowserPolicy = this.getDefaultBrowser();
        ComboBox<ReloadMode> comboBox2 = this.previewReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
        }
        browserManager.webPreviewReloadMode = (ReloadMode)comboBox2.getItem();
        ComboBox<ReloadMode> comboBox3 = this.serverReloadModeComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
        }
        browserManager.webServerReloadMode = (ReloadMode)comboBox3.getItem();
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
        }
        browserManager.setList(tableModelEditor.apply());
    }

    private final DefaultBrowserPolicy getDefaultBrowser() {
        ComboBox<DefaultBrowserPolicy> comboBox2 = this.defaultBrowserPolicyComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBrowserPolicyComboBox");
        }
        Object object = comboBox2.getSelectedItem();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.browsers.DefaultBrowserPolicy");
        }
        return (DefaultBrowserPolicy)((Object)object);
    }

    public final void reset() {
        WebBrowserManager browserManager;
        WebBrowserManager webBrowserManager = browserManager = WebBrowserManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)webBrowserManager), (String)"browserManager");
        DefaultBrowserPolicy effectiveDefaultBrowserPolicy = BrowserSettingsPanel.Companion.getDefaultBrowserPolicy(webBrowserManager);
        ComboBox<DefaultBrowserPolicy> comboBox2 = this.defaultBrowserPolicyComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBrowserPolicyComboBox");
        }
        comboBox2.setSelectedItem((Object)effectiveDefaultBrowserPolicy);
        ComboBox<ReloadMode> comboBox3 = this.previewReloadModeComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
        }
        comboBox3.setItem((Object)browserManager.getWebPreviewReloadMode());
        ComboBox<ReloadMode> comboBox4 = this.serverReloadModeComboBox;
        if (comboBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
        }
        comboBox4.setItem((Object)browserManager.getWebServerReloadMode());
        GeneralSettings settings = GeneralSettings.getInstance();
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
        }
        jBCheckBox.setSelected(browserManager.isShowBrowserHover());
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
        }
        jBCheckBox2.setSelected(browserManager.isShowBrowserHoverXml());
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
        }
        tableModelEditor.reset(browserManager.getList());
        GeneralSettings generalSettings = settings;
        Intrinsics.checkNotNullExpressionValue((Object)generalSettings, (String)"settings");
        this.customPathValue = generalSettings.getBrowserPath();
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
        }
        textFieldWithBrowseButton2.setEnabled(effectiveDefaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE);
        this.updateCustomPathTextFieldValue(effectiveDefaultBrowserPolicy);
    }

    public final void selectBrowser(@NotNull WebBrowser browser2) {
        Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
        if (browser2 instanceof ConfigurableWebBrowser) {
            TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
            if (tableModelEditor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            }
            tableModelEditor.selectItem((ConfigurableWebBrowser)browser2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BrowserSettingsPanel() {
        void $this$panel;
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        BrowserSettingsPanel browserSettingsPanel = this;
        boolean bl = false;
        TableModelEditor.DialogItemEditor itemEditor = new TableModelEditor.DialogItemEditor<ConfigurableWebBrowser>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
            }

            @NotNull
            public Class<ConfigurableWebBrowser> getItemClass() {
                return ConfigurableWebBrowser.class;
            }

            @NotNull
            public ConfigurableWebBrowser clone(@NotNull ConfigurableWebBrowser item, boolean forInPlaceEditing) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return new ConfigurableWebBrowser(forInPlaceEditing ? item.getId() : UUID.randomUUID(), item.getFamily(), item.getName(), item.getPath(), item.isActive(), forInPlaceEditing ? item.getSpecificSettings() : this.cloneSettings(item));
            }

            public void edit(@NotNull ConfigurableWebBrowser browser2, @NotNull Function<? super ConfigurableWebBrowser, ? extends ConfigurableWebBrowser> mutator, boolean isAdd) {
                Intrinsics.checkNotNullParameter((Object)((Object)browser2), (String)"browser");
                Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
                BrowserSpecificSettings settings = this.cloneSettings(browser2);
                if (settings != null && ShowSettingsUtil.getInstance().editConfigurable((Component)BrowserSettingsPanel.access$getBrowsersTable$p(this.this$0), settings.createConfigurable())) {
                    Object object = mutator.fun((Object)((Object)browser2));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mutator.`fun`(browser)");
                    ((ConfigurableWebBrowser)((Object)object)).setSpecificSettings(settings);
                }
            }

            private final BrowserSpecificSettings cloneSettings(ConfigurableWebBrowser browser2) {
                BrowserSpecificSettings browserSpecificSettings = browser2.getSpecificSettings();
                if (browserSpecificSettings == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)browserSpecificSettings, (String)"browser.specificSettings ?: return null");
                BrowserSpecificSettings settings = browserSpecificSettings;
                BrowserSpecificSettings browserSpecificSettings2 = browser2.getFamily().createBrowserSpecificSettings();
                Intrinsics.checkNotNull((Object)browserSpecificSettings2);
                Intrinsics.checkNotNullExpressionValue((Object)browserSpecificSettings2, (String)"browser.family.createBrowserSpecificSettings()!!");
                BrowserSpecificSettings newSettings = browserSpecificSettings2;
                TableModelEditor.cloneUsingXmlSerialization(settings, newSettings);
                return newSettings;
            }

            public void applyEdited(@NotNull ConfigurableWebBrowser oldItem, @NotNull ConfigurableWebBrowser newItem) {
                Intrinsics.checkNotNullParameter((Object)((Object)oldItem), (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)((Object)newItem), (String)"newItem");
                oldItem.setSpecificSettings(newItem.getSpecificSettings());
            }

            public boolean isEditable(@NotNull ConfigurableWebBrowser browser2) {
                Intrinsics.checkNotNullParameter((Object)((Object)browser2), (String)"browser");
                return browser2.getSpecificSettings() != null;
            }

            public boolean isRemovable(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        };
        TableModelEditor tableModelEditor = new TableModelEditor(COLUMNS, itemEditor, IdeBundle.message((String)"settings.browsers.no.web.browsers.configured", (Object[])new Object[0])).modelListener(new TableModelEditor.DataChangedListener<ConfigurableWebBrowser>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
            }

            public void tableChanged(@NotNull TableModelEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.update();
            }

            public void dataChanged(@NotNull ColumnInfo<ConfigurableWebBrowser, ?> columnInfo, int rowIndex) {
                Intrinsics.checkNotNullParameter(columnInfo, (String)"columnInfo");
                if (columnInfo == BrowserSettingsPanel.access$getPATH_COLUMN_INFO$cp() || columnInfo == BrowserSettingsPanel.access$getACTIVE_COLUMN_INFO$cp()) {
                    this.update();
                }
            }

            private final void update() {
                if (BrowserSettingsPanel.access$getDefaultBrowser$p(this.this$0) == DefaultBrowserPolicy.FIRST) {
                    BrowserSettingsPanel.access$setCustomPathToFirstListed(this.this$0);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue(tableModelEditor, (String)"TableModelEditor(COLUMNS\u2026     }\n        }\n      })");
        this.browsersEditor = tableModelEditor;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row row2 = $this$row;
                boolean isFullWidth$iv = true;
                boolean isVerticalFlow$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                CellKt.applyToComponent($this$cell.component(BrowserSettingsPanel.access$getBrowsersEditor$p(this.this$0).createComponent()).constraints($this$cell.getGrow(), $this$cell.getPushY()), (Function1)new Function1<JComponent, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull JComponent $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$receiver");
                        BrowserSettingsPanel.access$setBrowsersTable$p(this.this$0.this$0, $this$applyToComponent);
                    }
                });
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }, 3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, null, false, (Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Row row2 = $this$row;
                boolean isFullWidth$iv = true;
                boolean isVerticalFlow$iv = false;
                boolean $i$f$cell = false;
                this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                boolean bl = false;
                ArrayList<DefaultBrowserPolicy> defaultBrowserPolicies = new ArrayList<DefaultBrowserPolicy>();
                if (BrowserLauncherAppless.Companion.canUseSystemDefaultBrowserPolicy()) {
                    defaultBrowserPolicies.add(DefaultBrowserPolicy.SYSTEM);
                }
                defaultBrowserPolicies.add(DefaultBrowserPolicy.FIRST);
                defaultBrowserPolicies.add(DefaultBrowserPolicy.ALTERNATIVE);
                Cell cell2 = $this$cell;
                String string = IdeBundle.message((String)"settings.browsers.default.browser", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"setti\u2026rowsers.default.browser\")");
                Cell.label$default(cell2, string, null, null, false, 14, null);
                CellKt.applyToComponent($this$cell.component((JComponent)new ComboBox((ComboBoxModel)new CollectionComboBoxModel((List)defaultBrowserPolicies))), (Function1)new Function1<ComboBox<DefaultBrowserPolicy>, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$4 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull ComboBox<DefaultBrowserPolicy> $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$receiver");
                        $this$applyToComponent.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", (Function)root.1.3.1.1.INSTANCE));
                        $this$applyToComponent.addItemListener(new ItemListener(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$4$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void itemStateChanged(ItemEvent e) {
                                boolean customPathEnabled;
                                ItemEvent itemEvent = e;
                                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                                boolean bl = customPathEnabled = itemEvent.getItem() == DefaultBrowserPolicy.ALTERNATIVE;
                                if (e.getStateChange() == 2) {
                                    if (customPathEnabled) {
                                        BrowserSettingsPanel.access$setCustomPathValue$p(this.this$0.this$0.this$0, BrowserSettingsPanel.access$getAlternativeBrowserPathField$p(this.this$0.this$0.this$0).getText());
                                    }
                                } else if (e.getStateChange() == 1) {
                                    BrowserSettingsPanel.access$getAlternativeBrowserPathField$p(this.this$0.this$0.this$0).setEnabled(customPathEnabled);
                                    Object object = e.getItem();
                                    if (object == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.browsers.DefaultBrowserPolicy");
                                    }
                                    BrowserSettingsPanel.access$updateCustomPathTextFieldValue(this.this$0.this$0.this$0, (DefaultBrowserPolicy)((Object)object));
                                }
                            }
                        });
                        BrowserSettingsPanel.access$setDefaultBrowserPolicyComboBox$p(this.this$0.this$0, $this$applyToComponent);
                    }
                });
                CellKt.applyToComponent($this$cell.component((JComponent)new TextFieldWithBrowseButton()), (Function1)new Function1<TextFieldWithBrowseButton, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$4 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull TextFieldWithBrowseButton $this$applyToComponent) {
                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$receiver");
                        $this$applyToComponent.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, BrowserSettingsPanel.access$getAPP_FILE_CHOOSER_DESCRIPTOR$cp());
                        BrowserSettingsPanel.access$setAlternativeBrowserPathField$p(this.this$0.this$0, $this$applyToComponent);
                    }
                });
                this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }, 3, null);
        String string = IdeBundle.message((String)"settings.browsers.show.browser.popup.in.the.editor", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"setti\u2026ser.popup.in.the.editor\")");
        $this$panel.titledRow(string, (Function1<? super Row, Unit>)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$titledRow) {
                Intrinsics.checkNotNullParameter((Object)$this$titledRow, (String)"$receiver");
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$titledRow, null, false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$5 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        Cell cell2 = $this$row;
                        String string = IdeBundle.message((String)"settings.browsers.show.browser.popup.html", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"setti\u2026show.browser.popup.html\")");
                        CellKt.applyToComponent(Cell.checkBox$default(cell2, string, false, null, 6, null), (Function1)new Function1<JBCheckBox, Unit>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$5$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$receiver");
                                BrowserSettingsPanel.access$setShowBrowserHover$p(this.this$0.this$0.this$0, $this$applyToComponent);
                            }
                        });
                    }
                }, 3, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$titledRow, null, false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$5 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        Cell cell2 = $this$row;
                        String string = IdeBundle.message((String)"settings.browsers.show.browser.popup.xml", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"setti\u2026.show.browser.popup.xml\")");
                        CellKt.applyToComponent(Cell.checkBox$default(cell2, string, false, null, 6, null), (Function1)new Function1<JBCheckBox, Unit>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$5$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$receiver");
                                BrowserSettingsPanel.access$setShowBrowserHoverXml$p(this.this$0.this$0.this$0, $this$applyToComponent);
                            }
                        });
                    }
                }, 3, null);
            }
        }));
        String string2 = IdeBundle.message((String)"settings.browsers.reload.behavior", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"setti\u2026rowsers.reload.behavior\")");
        $this$panel.titledRow(string2, (Function1<? super Row, Unit>)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ BrowserSettingsPanel this$0;
            {
                this.this$0 = browserSettingsPanel;
                super(1);
            }

            public final void invoke(@NotNull Row $this$titledRow) {
                Intrinsics.checkNotNullParameter((Object)$this$titledRow, (String)"$receiver");
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$titledRow, IdeBundle.message((String)"setting.value.reload.mode.server", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$6 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        CellKt.applyToComponent($this$row.component((JComponent)new ComboBox((ComboBoxModel)new DefaultComboBoxModel<ReloadMode>(ReloadMode.values()))), (Function1)new Function1<ComboBox<ReloadMode>, Unit>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$6$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull ComboBox<ReloadMode> $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$receiver");
                                $this$applyToComponent.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", (Function)root.1.1.INSTANCE));
                                BrowserSettingsPanel.access$setServerReloadModeComboBox$p(this.this$0.this$0.this$0, $this$applyToComponent);
                            }
                        });
                    }
                }, 2, null);
                RowBuilder.DefaultImpls.row$default((RowBuilder)$this$titledRow, IdeBundle.message((String)"setting.value.reload.mode.preview", (Object[])new Object[0]), false, (Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$6 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        CellKt.applyToComponent($this$row.component((JComponent)new ComboBox((ComboBoxModel)new DefaultComboBoxModel<ReloadMode>(ReloadMode.values()))), (Function1)new Function1<ComboBox<ReloadMode>, Unit>(this){
                            final /* synthetic */ $special$$inlined$panel$lambda$6$2 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull ComboBox<ReloadMode> $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$receiver");
                                $this$applyToComponent.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", (Function)root.1.1.INSTANCE));
                                BrowserSettingsPanel.access$setPreviewReloadModeComboBox$p(this.this$0.this$0.this$0, $this$applyToComponent);
                            }
                        });
                    }
                }, 2, null);
            }
        }));
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel(builder$iv, panel$iv);
        browserSettingsPanel.root = (JPanel)panel$iv;
    }

    static {
        Companion = new Companion(null);
        APP_FILE_CHOOSER_DESCRIPTOR = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        PATH_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>(IdeBundle.message((String)"settings.browsers.column.path", (Object[])new Object[0])){

            @Nullable
            public String valueOf(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return PathUtil.toSystemDependentName((String)item.getPath());
            }

            public void setValue(@NotNull ConfigurableWebBrowser item, @NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                item.setPath(value2);
            }

            @Nullable
            public TableCellEditor getEditor(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return (TableCellEditor)((Object)new LocalPathCellEditor().fileChooserDescriptor(BrowserSettingsPanel.access$getAPP_FILE_CHOOSER_DESCRIPTOR$cp()).normalizePath(true));
            }
        };
        ACTIVE_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean>(){

            @NotNull
            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            @NotNull
            public Boolean valueOf(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return item.isActive();
            }

            public void setValue(@NotNull ConfigurableWebBrowser item, boolean value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                item.setActive(value2);
            }
        };
        COLUMNS = new ColumnInfo[]{ACTIVE_COLUMN_INFO, new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>(IdeBundle.message((String)"settings.browsers.column.name", (Object[])new Object[0])){

            @NotNull
            public String valueOf(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                String string = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.name");
                return string;
            }

            public void setValue(@NotNull ConfigurableWebBrowser item, @NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                item.setName(value2);
            }
        }, (ColumnInfo)new ColumnInfo<ConfigurableWebBrowser, BrowserFamily>(IdeBundle.message((String)"settings.browsers.column.family", (Object[])new Object[0])){

            @NotNull
            public Class<?> getColumnClass() {
                return BrowserFamily.class;
            }

            @NotNull
            public BrowserFamily valueOf(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                BrowserFamily browserFamily = item.getFamily();
                Intrinsics.checkNotNullExpressionValue((Object)browserFamily, (String)"item.family");
                return browserFamily;
            }

            public void setValue(@NotNull ConfigurableWebBrowser item, @NotNull BrowserFamily value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                item.setFamily(value2);
                item.setSpecificSettings(value2.createBrowserSpecificSettings());
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                IconTableCellRenderer<Iconable> iconTableCellRenderer = IconTableCellRenderer.ICONABLE;
                Intrinsics.checkNotNullExpressionValue(iconTableCellRenderer, (String)"IconTableCellRenderer.ICONABLE");
                return iconTableCellRenderer;
            }

            public boolean isCellEditable(@NotNull ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        }, PATH_COLUMN_INFO};
    }

    public static final /* synthetic */ JComponent access$getBrowsersTable$p(BrowserSettingsPanel $this) {
        JComponent jComponent = $this.browsersTable;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersTable");
        }
        return jComponent;
    }

    public static final /* synthetic */ void access$setBrowsersTable$p(BrowserSettingsPanel $this, JComponent jComponent) {
        $this.browsersTable = jComponent;
    }

    public static final /* synthetic */ TableModelEditor.EditableColumnInfo access$getPATH_COLUMN_INFO$cp() {
        return PATH_COLUMN_INFO;
    }

    public static final /* synthetic */ TableModelEditor.EditableColumnInfo access$getACTIVE_COLUMN_INFO$cp() {
        return ACTIVE_COLUMN_INFO;
    }

    public static final /* synthetic */ DefaultBrowserPolicy access$getDefaultBrowser$p(BrowserSettingsPanel $this) {
        return $this.getDefaultBrowser();
    }

    public static final /* synthetic */ void access$setCustomPathToFirstListed(BrowserSettingsPanel $this) {
        $this.setCustomPathToFirstListed();
    }

    public static final /* synthetic */ TableModelEditor access$getBrowsersEditor$p(BrowserSettingsPanel $this) {
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = $this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
        }
        return tableModelEditor;
    }

    public static final /* synthetic */ void access$setBrowsersEditor$p(BrowserSettingsPanel $this, TableModelEditor tableModelEditor) {
        $this.browsersEditor = tableModelEditor;
    }

    public static final /* synthetic */ String access$getCustomPathValue$p(BrowserSettingsPanel $this) {
        return $this.customPathValue;
    }

    public static final /* synthetic */ void access$setCustomPathValue$p(BrowserSettingsPanel $this, String string) {
        $this.customPathValue = string;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getAlternativeBrowserPathField$p(BrowserSettingsPanel $this) {
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = $this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
        }
        return textFieldWithBrowseButton2;
    }

    public static final /* synthetic */ void access$setAlternativeBrowserPathField$p(BrowserSettingsPanel $this, TextFieldWithBrowseButton textFieldWithBrowseButton2) {
        $this.alternativeBrowserPathField = textFieldWithBrowseButton2;
    }

    public static final /* synthetic */ void access$updateCustomPathTextFieldValue(BrowserSettingsPanel $this, DefaultBrowserPolicy browser2) {
        $this.updateCustomPathTextFieldValue(browser2);
    }

    public static final /* synthetic */ ComboBox access$getDefaultBrowserPolicyComboBox$p(BrowserSettingsPanel $this) {
        ComboBox<DefaultBrowserPolicy> comboBox2 = $this.defaultBrowserPolicyComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBrowserPolicyComboBox");
        }
        return comboBox2;
    }

    public static final /* synthetic */ void access$setDefaultBrowserPolicyComboBox$p(BrowserSettingsPanel $this, ComboBox comboBox2) {
        $this.defaultBrowserPolicyComboBox = comboBox2;
    }

    public static final /* synthetic */ FileChooserDescriptor access$getAPP_FILE_CHOOSER_DESCRIPTOR$cp() {
        return APP_FILE_CHOOSER_DESCRIPTOR;
    }

    public static final /* synthetic */ JBCheckBox access$getShowBrowserHover$p(BrowserSettingsPanel $this) {
        JBCheckBox jBCheckBox = $this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
        }
        return jBCheckBox;
    }

    public static final /* synthetic */ void access$setShowBrowserHover$p(BrowserSettingsPanel $this, JBCheckBox jBCheckBox) {
        $this.showBrowserHover = jBCheckBox;
    }

    public static final /* synthetic */ JBCheckBox access$getShowBrowserHoverXml$p(BrowserSettingsPanel $this) {
        JBCheckBox jBCheckBox = $this.showBrowserHoverXml;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
        }
        return jBCheckBox;
    }

    public static final /* synthetic */ void access$setShowBrowserHoverXml$p(BrowserSettingsPanel $this, JBCheckBox jBCheckBox) {
        $this.showBrowserHoverXml = jBCheckBox;
    }

    public static final /* synthetic */ ComboBox access$getServerReloadModeComboBox$p(BrowserSettingsPanel $this) {
        ComboBox<ReloadMode> comboBox2 = $this.serverReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
        }
        return comboBox2;
    }

    public static final /* synthetic */ void access$setServerReloadModeComboBox$p(BrowserSettingsPanel $this, ComboBox comboBox2) {
        $this.serverReloadModeComboBox = comboBox2;
    }

    public static final /* synthetic */ ComboBox access$getPreviewReloadModeComboBox$p(BrowserSettingsPanel $this) {
        ComboBox<ReloadMode> comboBox2 = $this.previewReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
        }
        return comboBox2;
    }

    public static final /* synthetic */ void access$setPreviewReloadModeComboBox$p(BrowserSettingsPanel $this, ComboBox comboBox2) {
        $this.previewReloadModeComboBox = comboBox2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/browsers/BrowserSettingsPanel$Companion;", "", "()V", "ACTIVE_COLUMN_INFO", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lcom/intellij/ide/browsers/ConfigurableWebBrowser;", "", "APP_FILE_CHOOSER_DESCRIPTOR", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "kotlin.jvm.PlatformType", "COLUMNS", "", "Lcom/intellij/util/ui/ColumnInfo;", "[Lcom/intellij/util/ui/ColumnInfo;", "PATH_COLUMN_INFO", "", "getDefaultBrowserPolicy", "Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "manager", "Lcom/intellij/ide/browsers/WebBrowserManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final DefaultBrowserPolicy getDefaultBrowserPolicy(WebBrowserManager manager2) {
            DefaultBrowserPolicy defaultBrowserPolicy = manager2.getDefaultBrowserPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)defaultBrowserPolicy), (String)"manager.getDefaultBrowserPolicy()");
            DefaultBrowserPolicy policy = defaultBrowserPolicy;
            return policy != DefaultBrowserPolicy.SYSTEM || BrowserLauncherAppless.Companion.canUseSystemDefaultBrowserPolicy() ? policy : DefaultBrowserPolicy.ALTERNATIVE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

