/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lexer.DtdLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.XHtmlHighlightingLexer;
import com.intellij.lexer.XmlHighlightingLexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XmlFileHighlighter
extends SyntaxHighlighterBase {
    static final ExtensionPointName<EmbeddedTokenHighlighter> EMBEDDED_HIGHLIGHTERS = ExtensionPointName.create((String)"com.intellij.embeddedTokenHighlighter");
    private final boolean myIsDtd;
    private boolean myIsXHtml;

    static void registerAdditionalHighlighters(MultiMap<IElementType, TextAttributesKey> map2) {
        for (EmbeddedTokenHighlighter highlighter : EMBEDDED_HIGHLIGHTERS.getExtensionList()) {
            XmlFileHighlighter.registerAdditionalHighlighters(map2, highlighter);
        }
    }

    private static void registerAdditionalHighlighters(MultiMap<IElementType, TextAttributesKey> map2, EmbeddedTokenHighlighter highlighter) {
        MultiMap<IElementType, TextAttributesKey> attributes2 = highlighter.getEmbeddedTokenAttributes();
        for (Map.Entry entry2 : attributes2.entrySet()) {
            if (map2.containsKey((Object)((IElementType)entry2.getKey()))) continue;
            map2.putValues((Object)((IElementType)entry2.getKey()), (Collection)entry2.getValue());
        }
    }

    public XmlFileHighlighter() {
        this(false);
    }

    public XmlFileHighlighter(boolean dtd) {
        this.myIsDtd = dtd;
    }

    public XmlFileHighlighter(boolean dtd, boolean xhtml) {
        this.myIsDtd = dtd;
        this.myIsXHtml = xhtml;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        if (this.myIsDtd) {
            return new DtdLexer(true);
        }
        if (this.myIsXHtml) {
            return new XHtmlHighlightingLexer();
        }
        return new XmlHighlightingLexer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        // MONITORENTER : clazz
        TextAttributesKey[] textAttributesKeyArray = Holder.ourMap.get((Object)tokenType).toArray(TextAttributesKey.EMPTY_ARRAY);
        // MONITOREXIT : clazz
        if (textAttributesKeyArray != null) return textAttributesKeyArray;
        XmlFileHighlighter.$$$reportNull$$$0(0);
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/XmlFileHighlighter", "getTokenHighlights"));
    }

    static class EmbeddedTokenHighlighterExtensionPointListener
    implements ExtensionPointListener<EmbeddedTokenHighlighter> {
        private final MultiMap<IElementType, TextAttributesKey> myMap;

        EmbeddedTokenHighlighterExtensionPointListener(MultiMap<IElementType, TextAttributesKey> map2) {
            this.myMap = map2;
        }

        public void extensionAdded(@NotNull EmbeddedTokenHighlighter extension2, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension2 == null) {
                EmbeddedTokenHighlighterExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                EmbeddedTokenHighlighterExtensionPointListener.$$$reportNull$$$0(1);
            }
            XmlFileHighlighter.registerAdditionalHighlighters(this.myMap, extension2);
        }

        public void extensionRemoved(@NotNull EmbeddedTokenHighlighter extension2, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension2 == null) {
                EmbeddedTokenHighlighterExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                EmbeddedTokenHighlighterExtensionPointListener.$$$reportNull$$$0(3);
            }
            MultiMap<IElementType, TextAttributesKey> attributes2 = extension2.getEmbeddedTokenAttributes();
            for (IElementType key : attributes2.keySet()) {
                this.myMap.remove((Object)key);
            }
            XmlFileHighlighter.registerAdditionalHighlighters(this.myMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/highlighter/XmlFileHighlighter$EmbeddedTokenHighlighterExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final MultiMap<IElementType, TextAttributesKey> ourMap = MultiMap.create();

        private Holder() {
        }

        static {
            ourMap.putValue((Object)XmlTokenType.XML_DATA_CHARACTERS, (Object)XmlHighlighterColors.XML_TAG_DATA);
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_COMMENT_START, XmlTokenType.XML_COMMENT_END, XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_CONDITIONAL_COMMENT_END, XmlTokenType.XML_CONDITIONAL_COMMENT_END_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START, XmlTokenType.XML_CONDITIONAL_COMMENT_START_END})) {
                ourMap.putValue((Object)type, (Object)XmlHighlighterColors.XML_COMMENT);
            }
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE})) {
                ourMap.putValue((Object)type, (Object)XmlHighlighterColors.XML_TAG);
            }
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_CONDITIONAL_IGNORE, XmlTokenType.XML_CONDITIONAL_INCLUDE})) {
                ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_TAG_NAME));
            }
            ourMap.putValues((Object)XmlTokenType.XML_NAME, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_ATTRIBUTE_NAME));
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_EQ, XmlTokenType.XML_TAG_CHARACTERS, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER})) {
                ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_ATTRIBUTE_VALUE));
            }
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_DECL_START, XmlTokenType.XML_DOCTYPE_START, XmlTokenType.XML_DOCTYPE_SYSTEM, XmlTokenType.XML_DOCTYPE_PUBLIC, XmlTokenType.XML_ATTLIST_DECL_START, XmlTokenType.XML_ELEMENT_DECL_START, XmlTokenType.XML_ENTITY_DECL_START})) {
                ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_TAG, XmlHighlighterColors.XML_TAG_NAME));
            }
            for (IElementType type : (IElementType[])ContainerUtil.ar((Object[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_SECTION_START, XmlTokenType.XML_CONDITIONAL_SECTION_END, XmlTokenType.XML_DECL_END, XmlTokenType.XML_DOCTYPE_END})) {
                ourMap.putValues((Object)type, Arrays.asList(XmlHighlighterColors.XML_PROLOGUE, XmlHighlighterColors.XML_TAG_NAME));
            }
            ourMap.putValue((Object)XmlTokenType.XML_PI_START, (Object)XmlHighlighterColors.XML_PROLOGUE);
            ourMap.putValue((Object)XmlTokenType.XML_PI_END, (Object)XmlHighlighterColors.XML_PROLOGUE);
            ourMap.putValue((Object)XmlTokenType.XML_CHAR_ENTITY_REF, (Object)XmlHighlighterColors.XML_ENTITY_REFERENCE);
            ourMap.putValue((Object)XmlTokenType.XML_ENTITY_REF_TOKEN, (Object)XmlHighlighterColors.XML_ENTITY_REFERENCE);
            ourMap.putValue((Object)XmlTokenType.XML_BAD_CHARACTER, (Object)HighlighterColors.BAD_CHARACTER);
            XmlFileHighlighter.registerAdditionalHighlighters(ourMap);
            EMBEDDED_HIGHLIGHTERS.addExtensionPointListener((ExtensionPointListener)new EmbeddedTokenHighlighterExtensionPointListener(ourMap), null);
        }
    }
}

