/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenUntrustedProjectChoice;
import com.intellij.ide.impl.TrustStateListener;
import com.intellij.ide.impl.TrustedPaths;
import com.intellij.ide.impl.TrustedPathsSettings;
import com.intellij.ide.impl.TrustedProjectSettings;
import com.intellij.ide.impl.TrustedProjects$WhenMappings;
import com.intellij.ide.impl.TrustedProjectsStatistics;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u001aB\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0007\u001a\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a\b\u0010\u001a\u001a\u00020\u0006H\u0007\u001a\b\u0010\u001b\u001a\u00020\u0006H\u0002\u001a(\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0!H\u0007\u001a\"\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0007\u001a\f\u0010#\u001a\u00020$*\u00020\bH\u0007\u001a\n\u0010%\u001a\u00020\u0006*\u00020\b\u001a\u0012\u0010&\u001a\u00020\u001d*\u00020\b2\u0006\u0010'\u001a\u00020\u0006\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TRUSTED_PROJECTS_HELP_TOPIC", "", "confirmLoadingUntrustedProject", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "message", "trustButtonText", "distrustButtonText", "confirmOpeningAndSetProjectTrustedStateIfNeeded", "projectFileOrDir", "Ljava/nio/file/Path;", "confirmOpeningUntrustedProject", "Lcom/intellij/ide/impl/OpenUntrustedProjectChoice;", "projectDir", "cancelButtonText", "createDoNotAskOptionForLocation", "Lcom/intellij/openapi/ui/DoNotAskOption;", "projectLocation", "isPathTrustedInSettings", "path", "isProjectImplicitlyTrusted", "isTrustedCheckDisabled", "isTrustedCheckDisabledForProduct", "whenProjectTrusted", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function1;", "Ljava/util/function/Consumer;", "getTrustedState", "Lcom/intellij/util/ThreeState;", "isTrusted", "setTrusted", "value", "intellij.platform.ide.impl"})
@JvmName(name="TrustedProjects")
@ApiStatus.Experimental
public final class TrustedProjects {
    @NotNull
    public static final String TRUSTED_PROJECTS_HELP_TOPIC = "Project_security";
    private static final Logger LOG;

    @ApiStatus.Internal
    public static final boolean confirmOpeningAndSetProjectTrustedStateIfNeeded(@NotNull Path projectFileOrDir) {
        Intrinsics.checkNotNullParameter((Object)projectFileOrDir, (String)"projectFileOrDir");
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Boolean>(projectFileOrDir){
            final /* synthetic */ Path $projectFileOrDir;

            public final boolean invoke() {
                Path path2 = this.$projectFileOrDir;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl = false;
                Path projectDir = Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? this.$projectFileOrDir : this.$projectFileOrDir.getParent();
                TrustedPaths trustedPaths = TrustedPaths.Companion.getInstance();
                Path path3 = projectDir;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"projectDir");
                ThreeState trustedState = trustedPaths.getProjectPathTrustedState(path3);
                if (trustedState == ThreeState.UNSURE) {
                    OpenUntrustedProjectChoice openingUntrustedProjectChoice = TrustedProjects.access$confirmOpeningUntrustedProject(projectDir);
                    switch (TrustedProjects$WhenMappings.$EnumSwitchMapping$0[openingUntrustedProjectChoice.ordinal()]) {
                        case 1: {
                            trustedPaths.setProjectPathTrusted(projectDir, true);
                            break;
                        }
                        case 2: {
                            trustedPaths.setProjectPathTrusted(projectDir, false);
                            break;
                        }
                        case 3: {
                            return false;
                        }
                    }
                }
                return true;
            }
            {
                this.$projectFileOrDir = path2;
                super(0);
            }
        }), (int)1, null);
    }

    private static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(Path projectDir) {
        String string = IdeBundle.message((String)"untrusted.project.open.dialog.title", (Object[])new Object[]{projectDir.getFileName()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"untru\u2026le\", projectDir.fileName)");
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[0] = applicationNamesInfo.getFullProductName();
        String string2 = IdeBundle.message((String)"untrusted.project.open.dialog.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeBundle.message(\"untru\u2026stance().fullProductName)");
        String string3 = IdeBundle.message((String)"untrusted.project.dialog.trust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"untru\u2026ect.dialog.trust.button\")");
        String string4 = IdeBundle.message((String)"untrusted.project.open.dialog.distrust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IdeBundle.message(\"untru\u2026.dialog.distrust.button\")");
        String string5 = IdeBundle.message((String)"untrusted.project.open.dialog.cancel.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"IdeBundle.message(\"untru\u2026en.dialog.cancel.button\")");
        return TrustedProjects.confirmOpeningUntrustedProject(projectDir, string, string2, string3, string4, string5);
    }

    private static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(Path projectDir, @NlsContexts.DialogTitle String title2, @NlsContexts.DialogMessage String message2, @NlsContexts.Button String trustButtonText, @NlsContexts.Button String distrustButtonText, @NlsContexts.Button String cancelButtonText) {
        return (OpenUntrustedProjectChoice)((Object)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<OpenUntrustedProjectChoice>(projectDir, title2, message2, trustButtonText, distrustButtonText, cancelButtonText){
            final /* synthetic */ Path $projectDir;
            final /* synthetic */ String $title;
            final /* synthetic */ String $message;
            final /* synthetic */ String $trustButtonText;
            final /* synthetic */ String $distrustButtonText;
            final /* synthetic */ String $cancelButtonText;

            @NotNull
            public final OpenUntrustedProjectChoice invoke() {
                OpenUntrustedProjectChoice openUntrustedProjectChoice;
                String choice;
                if (TrustedProjects.isProjectImplicitlyTrusted$default(this.$projectDir, null, 2, null)) {
                    return OpenUntrustedProjectChoice.TRUST_AND_OPEN;
                }
                MessageDialogBuilder.Message message2 = new MessageDialogBuilder.Message(this.$title, this.$message).buttons(new String[]{this.$trustButtonText, this.$distrustButtonText, this.$cancelButtonText}).defaultButton(this.$trustButtonText).focusedButton(this.$distrustButtonText);
                Path path2 = this.$projectDir.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectDir.parent");
                String string = choice = MessageDialogBuilder.Message.show$default((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)((MessageDialogBuilder.Message)message2.doNotAsk(TrustedProjects.access$createDoNotAskOptionForLocation(path2))).asWarning()).help("Project_security")), null, null, (int)3, null);
                if (Intrinsics.areEqual((Object)string, (Object)this.$trustButtonText)) {
                    openUntrustedProjectChoice = OpenUntrustedProjectChoice.TRUST_AND_OPEN;
                } else if (Intrinsics.areEqual((Object)string, (Object)this.$distrustButtonText)) {
                    openUntrustedProjectChoice = OpenUntrustedProjectChoice.OPEN_IN_SAFE_MODE;
                } else if (Intrinsics.areEqual((Object)string, (Object)this.$cancelButtonText) || string == null) {
                    openUntrustedProjectChoice = OpenUntrustedProjectChoice.CANCEL;
                } else {
                    TrustedProjects.access$getLOG$p().error("Illegal choice " + choice);
                    return OpenUntrustedProjectChoice.CANCEL;
                }
                OpenUntrustedProjectChoice openChoice = openUntrustedProjectChoice;
                TrustedProjectsStatistics.Companion.getNEW_PROJECT_OPEN_OR_IMPORT_CHOICE().log((Object)((Object)openChoice));
                return openChoice;
            }
            {
                this.$projectDir = path2;
                this.$title = string;
                this.$message = string2;
                this.$trustButtonText = string3;
                this.$distrustButtonText = string4;
                this.$cancelButtonText = string5;
                super(0);
            }
        }), (int)1, null));
    }

    public static final boolean confirmLoadingUntrustedProject(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title2, @NlsContexts.DialogMessage @NotNull String message2, @NlsContexts.Button @NotNull String trustButtonText, @NlsContexts.Button @NotNull String distrustButtonText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)trustButtonText, (String)"trustButtonText");
        Intrinsics.checkNotNullParameter((Object)distrustButtonText, (String)"distrustButtonText");
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Boolean>(project, title2, message2, trustButtonText, distrustButtonText){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ String $message;
            final /* synthetic */ String $trustButtonText;
            final /* synthetic */ String $distrustButtonText;

            public final boolean invoke() {
                if (TrustedProjects.access$isProjectImplicitlyTrusted(this.$project)) {
                    TrustedProjects.setTrusted(this.$project, true);
                    return true;
                }
                boolean answer = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(this.$title, this.$message).yesText(this.$trustButtonText)).noText(this.$distrustButtonText)).asWarning()).help("Project_security")).ask(this.$project);
                TrustedProjects.setTrusted(this.$project, answer);
                TrustedProjectsStatistics.Companion.getLOAD_UNTRUSTED_PROJECT_CONFIRMATION_CHOICE().log(this.$project, (Object)answer);
                return answer;
            }
            {
                this.$project = project;
                this.$title = string;
                this.$message = string2;
                this.$trustButtonText = string3;
                this.$distrustButtonText = string4;
                super(0);
            }
        }), (int)1, null);
    }

    public static final boolean isTrusted(@NotNull Project $this$isTrusted) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrusted, (String)"$this$isTrusted");
        return LightEdit.owns((Project)$this$isTrusted) || TrustedProjects.getTrustedState($this$isTrusted) == ThreeState.YES;
    }

    @ApiStatus.Internal
    @NotNull
    public static final ThreeState getTrustedState(@NotNull Project $this$getTrustedState) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrustedState, (String)"$this$getTrustedState");
        String projectPath = $this$getTrustedState.getBasePath();
        if (projectPath != null) {
            TrustedPaths trustedPaths = TrustedPaths.Companion.getInstance();
            Path path2 = Paths.get(projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(projectPath)");
            ThreeState explicit = trustedPaths.getProjectPathTrustedState(path2);
            if (explicit != ThreeState.UNSURE) {
                return explicit;
            }
        }
        if (TrustedProjects.isProjectImplicitlyTrusted($this$getTrustedState)) {
            return ThreeState.YES;
        }
        Project $this$service$iv = $this$getTrustedState;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((TrustedProjectSettings)((Object)object)).getTrustedState();
    }

    public static final void setTrusted(@NotNull Project $this$setTrusted, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)$this$setTrusted, (String)"$this$setTrusted");
        String projectPath = $this$setTrusted.getBasePath();
        if (projectPath != null) {
            Path path2 = Paths.get(projectPath, new String[0]);
            TrustedPaths trustedPaths = TrustedPaths.Companion.getInstance();
            Path path3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            ThreeState oldValue = trustedPaths.getProjectPathTrustedState(path3);
            trustedPaths.setProjectPathTrusted(path2, value2);
            if (value2 && oldValue != ThreeState.YES) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                ((TrustStateListener)application.getMessageBus().syncPublisher(TrustStateListener.TOPIC)).onProjectTrusted($this$setTrusted);
            }
        }
    }

    private static final DoNotAskOption createDoNotAskOptionForLocation(Path projectLocation) {
        String projectLocationPath = ((Object)projectLocation).toString();
        return (DoNotAskOption)new DoNotAskOption.Adapter(projectLocationPath){
            final /* synthetic */ String $projectLocationPath;

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    TrustedProjectsStatistics.Companion.getTRUST_LOCATION_CHECKBOX_SELECTED().log();
                    boolean $i$f$service = false;
                    Class<TrustedPathsSettings> serviceClass$iv = TrustedPathsSettings.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    ((TrustedPathsSettings)((Object)object)).addTrustedPath(this.$projectLocationPath);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                String path2 = FileUtil.getLocationRelativeToUserHome((String)this.$projectLocationPath, (boolean)false);
                String string = IdeBundle.message((String)"untrusted.project.warning.trust.location.checkbox", (Object[])new Object[]{path2});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"untru\u2026location.checkbox\", path)");
                return string;
            }
            {
                this.$projectLocationPath = $captured_local_variable$0;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public static final boolean isTrustedCheckDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isHeadlessEnvironment()) return true;
        if (Boolean.getBoolean("idea.is.integration.test")) return true;
        if (!Boolean.getBoolean("idea.trust.all.projects")) return false;
        return true;
    }

    private static final boolean isTrustedCheckDisabledForProduct() {
        return Boolean.getBoolean("idea.trust.disabled");
    }

    private static final boolean isProjectImplicitlyTrusted(Project project) {
        Path path2;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path2 = Paths.get(it, new String[0]);
        } else {
            path2 = null;
        }
        return TrustedProjects.isProjectImplicitlyTrusted(path2, project);
    }

    @JvmOverloads
    @ApiStatus.Internal
    public static final boolean isProjectImplicitlyTrusted(@Nullable Path projectDir, @Nullable Project project) {
        if (TrustedProjects.isTrustedCheckDisabled() || TrustedProjects.isTrustedCheckDisabledForProduct()) {
            return true;
        }
        if (projectDir != null && TrustedProjects.isPathTrustedInSettings(projectDir)) {
            TrustedProjectsStatistics.Companion.getPROJECT_IMPLICITLY_TRUSTED_BY_PATH().log(project);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean isProjectImplicitlyTrusted$default(Path path2, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return TrustedProjects.isProjectImplicitlyTrusted(path2, project);
    }

    @JvmOverloads
    @ApiStatus.Internal
    public static final boolean isProjectImplicitlyTrusted(@Nullable Path projectDir) {
        return TrustedProjects.isProjectImplicitlyTrusted$default(projectDir, null, 2, null);
    }

    @ApiStatus.Internal
    public static final boolean isPathTrustedInSettings(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        boolean $i$f$service = false;
        Class<TrustedPathsSettings> serviceClass$iv = TrustedPathsSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return ((TrustedPathsSettings)((Object)object)).isPathTrusted(path2);
    }

    @JvmOverloads
    public static final void whenProjectTrusted(@Nullable Disposable parentDisposable, @NotNull Function1<? super Project, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBus messageBus = application.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
        MessageBus messageBus2 = messageBus;
        MessageBusConnection messageBusConnection2 = parentDisposable == null ? messageBus2.connect() : messageBus2.connect(parentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"if (parentDisposable == \u2026connect(parentDisposable)");
        MessageBusConnection connection = messageBusConnection2;
        connection.subscribe(TrustStateListener.TOPIC, (Object)new TrustStateListener(listener2, connection){
            final /* synthetic */ Function1 $listener;
            final /* synthetic */ MessageBusConnection $connection;

            public void onProjectTrusted(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.$listener.invoke((Object)project);
                this.$connection.disconnect();
            }
            {
                this.$listener = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
            }
        });
    }

    public static /* synthetic */ void whenProjectTrusted$default(Disposable disposable2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            disposable2 = null;
        }
        TrustedProjects.whenProjectTrusted(disposable2, (Function1<? super Project, Unit>)function1);
    }

    @JvmOverloads
    public static final void whenProjectTrusted(@NotNull Function1<? super Project, Unit> listener2) {
        TrustedProjects.whenProjectTrusted$default(null, listener2, 1, null);
    }

    @JvmOverloads
    public static final void whenProjectTrusted(@Nullable Disposable parentDisposable, @NotNull Consumer<Project> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        TrustedProjects.whenProjectTrusted(parentDisposable, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(listener2){
            final /* synthetic */ Consumer $listener;

            public final void invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.$listener.accept(project);
            }
            {
                this.$listener = consumer2;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void whenProjectTrusted$default(Disposable disposable2, Consumer consumer2, int n, Object object) {
        if ((n & 1) != 0) {
            disposable2 = null;
        }
        TrustedProjects.whenProjectTrusted(disposable2, consumer2);
    }

    @JvmOverloads
    public static final void whenProjectTrusted(@NotNull Consumer<Project> listener2) {
        TrustedProjects.whenProjectTrusted$default(null, listener2, 1, null);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.ide.impl.TrustedProjects");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"com.\u2026de.impl.TrustedProjects\")");
        LOG = logger;
    }

    public static final /* synthetic */ OpenUntrustedProjectChoice access$confirmOpeningUntrustedProject(Path projectDir) {
        return TrustedProjects.confirmOpeningUntrustedProject(projectDir);
    }

    public static final /* synthetic */ DoNotAskOption access$createDoNotAskOptionForLocation(Path projectLocation) {
        return TrustedProjects.createDoNotAskOptionForLocation(projectLocation);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$isProjectImplicitlyTrusted(Project project) {
        return TrustedProjects.isProjectImplicitlyTrusted(project);
    }
}

