/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.instrument;

import com.intellij.ide.instrument.LockWrappingClassVisitor;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public final class WriteIntentLockInstrumenter {
    private static final Set<String> ourAlreadyInstrumented = Collections.synchronizedSet(new HashSet());
    public static final Object LOCK = new Object();
    public static final String DIRTY_UI_SIGNATURE = "Lcom/intellij/ui/DirtyUI;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instrument() {
        Instrumentation instrumentation = ByteBuddyAgent.install();
        Object object = LOCK;
        synchronized (object) {
            instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                    if (className == null || loader == null || ourAlreadyInstrumented.contains(className)) {
                        return null;
                    }
                    final boolean[] shouldProcess = new boolean[]{false};
                    final HashSet<String> methodsToAnnotate = new HashSet<String>();
                    ClassReader cr = new ClassReader(classfileBuffer);
                    cr.accept(new ClassVisitor(589824){

                        public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                            if (descriptor2.equals(WriteIntentLockInstrumenter.DIRTY_UI_SIGNATURE)) {
                                shouldProcess[0] = true;
                            }
                            return null;
                        }

                        public MethodVisitor visitMethod(int access, final String name2, String descriptor2, String signature, String[] exceptions) {
                            return new MethodVisitor(this.api){

                                public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                                    if (descriptor2.equals(WriteIntentLockInstrumenter.DIRTY_UI_SIGNATURE)) {
                                        shouldProcess[0] = true;
                                        methodsToAnnotate.add(name2);
                                    }
                                    return null;
                                }
                            };
                        }
                    }, 7);
                    if (!shouldProcess[0] && Stream.concat(Stream.of(cr.getSuperName()), Stream.of(cr.getInterfaces())).noneMatch(name2 -> ourAlreadyInstrumented.contains(name2))) {
                        return null;
                    }
                    ourAlreadyInstrumented.add(className);
                    Logger.getInstance(WriteIntentLockInstrumenter.class).info("Redefining " + className);
                    ClassWriter cw = new ClassWriter(cr, 2);
                    cr.accept((ClassVisitor)new LockWrappingClassVisitor(cw, className, methodsToAnnotate), 4);
                    return cw.toByteArray();
                }
            }, true);
        }
    }
}

