/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarModelBuilder;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarModel {
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Navbar model builder");
    private final NavBarModelListener myNotificator;
    private final NavBarModelBuilder myBuilder;
    private final Project myProject;
    private volatile int mySelectedIndex;
    private volatile List<Object> myModel;
    private volatile boolean myChanged;
    private volatile boolean updated;
    private volatile boolean isFixedComponent;

    public NavBarModel(@NotNull Project project) {
        if (project == null) {
            NavBarModel.$$$reportNull$$$0(0);
        }
        this(project, (NavBarModelListener)project.getMessageBus().syncPublisher(NavBarModelListener.NAV_BAR), NavBarModelBuilder.getInstance());
    }

    protected NavBarModel(Project project, NavBarModelListener notificator, NavBarModelBuilder builder2) {
        this.myChanged = true;
        this.updated = false;
        this.isFixedComponent = false;
        this.myProject = project;
        this.myNotificator = notificator;
        this.myBuilder = builder2;
        this.myModel = Collections.singletonList(this.myProject);
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    @Nullable
    public Object getSelectedValue() {
        return this.getElement(this.mySelectedIndex);
    }

    @Nullable
    public Object getElement(int index2) {
        if (index2 != -1 && index2 < this.myModel.size()) {
            return this.get(index2);
        }
        return null;
    }

    public int size() {
        return this.myModel.size();
    }

    public boolean isEmpty() {
        return this.myModel.isEmpty();
    }

    public int getIndexByModel(int index2) {
        if (index2 < 0) {
            return this.myModel.size() + index2;
        }
        if (index2 >= this.myModel.size() && this.myModel.size() > 0) {
            return index2 % this.myModel.size();
        }
        return index2;
    }

    public void updateModelAsync(@NotNull DataContext dataContext, @Nullable Runnable callback2) {
        if (dataContext == null) {
            NavBarModel.$$$reportNull$$$0(1);
        }
        if (LaterInvocator.isInModalContext() || PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext) instanceof NavBarPanel) {
            return;
        }
        DataContext wrappedDataContext = NavBarModel.wrapDataContext(dataContext);
        ReadAction.nonBlocking(() -> this.createModel(wrappedDataContext)).expireWith((Disposable)this.myProject).finishOnUiThread(ModalityState.current(), model2 -> {
            this.setModelWithUpdate((List<Object>)model2);
            if (callback2 != null) {
                callback2.run();
            }
        }).submit((Executor)ourExecutor);
    }

    @NotNull
    private static DataContext wrapDataContext(@NotNull DataContext context2) {
        DataContext wrapped;
        if (context2 == null) {
            NavBarModel.$$$reportNull$$$0(2);
        }
        if (Utils.isAsyncDataContext(wrapped = Utils.wrapDataContext(context2))) {
            DataContext dataContext = wrapped;
            if (dataContext == null) {
                NavBarModel.$$$reportNull$$$0(3);
            }
            return dataContext;
        }
        DataContext dataContext = SimpleDataContext.builder().addAll(context2, CommonDataKeys.PSI_FILE, CommonDataKeys.PROJECT, CommonDataKeys.VIRTUAL_FILE, PlatformCoreDataKeys.MODULE, CommonDataKeys.EDITOR, PlatformCoreDataKeys.SELECTED_ITEMS).build();
        if (dataContext == null) {
            NavBarModel.$$$reportNull$$$0(4);
        }
        return dataContext;
    }

    private void setModelWithUpdate(@Nullable List<Object> model2) {
        if (model2 != null) {
            this.setModel(model2);
        }
        this.setChanged(false);
        this.updated = true;
    }

    public void updateModel(DataContext dataContext) {
        this.setModelWithUpdate(this.createModel(dataContext));
    }

    @Nullable
    private List<Object> createModel(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NavBarModel.$$$reportNull$$$0(5);
        }
        if (this.updated && !this.isFixedComponent) {
            return null;
        }
        NavBarModelExtension ownerExtension = null;
        PsiElement psiElement = null;
        for (NavBarModelExtension extension2 : NavBarModelExtension.EP_NAME.getExtensionList()) {
            psiElement = extension2.getLeafElement(dataContext);
            if (psiElement == null) continue;
            ownerExtension = extension2;
            break;
        }
        if (psiElement == null) {
            psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
        }
        if (psiElement == null) {
            psiElement = PsiUtilCore.findFileSystemItem((Project)((Project)CommonDataKeys.PROJECT.getData(dataContext)), (VirtualFile)((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)));
        }
        if (ownerExtension == null) {
            psiElement = NavBarModel.normalize(psiElement);
        }
        if (!this.myModel.isEmpty() && Objects.equals(this.get(this.myModel.size() - 1), psiElement) && !this.myChanged) {
            return null;
        }
        if (psiElement != null && psiElement.isValid()) {
            return this.createModel(psiElement, dataContext, ownerExtension);
        }
        if (UISettings.getInstance().getShowNavigationBar() && !this.myModel.isEmpty()) {
            return null;
        }
        Object root2 = this.calculateRoot(dataContext);
        if (root2 != null) {
            return Collections.singletonList(root2);
        }
        return null;
    }

    private Object calculateRoot(DataContext dataContext) {
        Module root2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (root2 != null && !ModuleType.isInternal((Module)root2)) {
            return root2;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Object projectGrandChild = null;
        CommonProcessors.FindFirstAndOnlyProcessor processor2 = new CommonProcessors.FindFirstAndOnlyProcessor();
        this.processChildren(project, (Processor<Object>)processor2);
        Object projectChild = processor2.reset();
        if (projectChild != null) {
            this.processChildren(projectChild, (Processor<Object>)processor2);
            projectGrandChild = processor2.reset();
        }
        return ObjectUtils.chooseNotNull(projectGrandChild, (Object)ObjectUtils.chooseNotNull((Object)projectChild, (Object)project));
    }

    protected void updateModel(PsiElement psiElement, @Nullable NavBarModelExtension ownerExtension) {
        this.setModel(this.createModel(psiElement, null, ownerExtension));
    }

    @NotNull
    private List<Object> createModel(PsiElement psiElement, @Nullable DataContext dataContext, @Nullable NavBarModelExtension ownerExtension) {
        VirtualFile parent;
        HashSet<VirtualFile> roots2 = new HashSet<VirtualFile>();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        for (VirtualFile root2 : projectRootManager.getContentRoots()) {
            parent = root2.getParent();
            if (parent != null && projectFileIndex.isInContent(parent)) continue;
            roots2.add(root2);
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            for (VirtualFile root2 : modelExtension.additionalRoots(psiElement.getProject())) {
                parent = root2.getParent();
                if (parent != null && projectFileIndex.isInContent(parent)) continue;
                roots2.add(root2);
            }
        }
        List updatedModel = (List)ReadAction.compute(() -> NavBarModel.isValid(psiElement) ? this.myBuilder.createModel(psiElement, roots2, dataContext, ownerExtension) : Collections.emptyList());
        List list2 = ContainerUtil.reverse((List)updatedModel);
        if (list2 == null) {
            NavBarModel.$$$reportNull$$$0(6);
        }
        return list2;
    }

    void revalidate() {
        ArrayList<Object> objects = new ArrayList<Object>();
        boolean update2 = false;
        for (Object o : this.myModel) {
            if (NavBarModel.isValid(TreeAnchorizer.getService().retrieveElement(o))) {
                objects.add(o);
                continue;
            }
            update2 = true;
            break;
        }
        if (update2) {
            this.setModel(objects);
        }
    }

    protected void setModel(List<Object> model2) {
        this.setModel(model2, false);
    }

    protected void setModel(List<Object> model2, boolean force) {
        if (!model2.equals(TreeAnchorizer.retrieveList(this.myModel))) {
            this.myModel = this.anchorizeList(model2);
            this.myNotificator.modelChanged();
            this.mySelectedIndex = this.myModel.size() - 1;
            this.myNotificator.selectionChanged();
        } else if (force) {
            this.myModel = this.anchorizeList(model2);
            this.myNotificator.modelChanged();
        }
    }

    @NotNull
    private List<Object> anchorizeList(@NotNull List<Object> model2) {
        List<Project> list2;
        if (model2 == null) {
            NavBarModel.$$$reportNull$$$0(7);
        }
        List<Project> list3 = !(list2 = TreeAnchorizer.anchorizeList(model2)).isEmpty() ? list2 : Collections.singletonList(this.myProject);
        if (list3 == null) {
            NavBarModel.$$$reportNull$$$0(8);
        }
        return list3;
    }

    public void updateModel(Object object) {
        if (object instanceof PsiElement) {
            this.updateModel((PsiElement)object, null);
        } else if (object instanceof Module) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(this.myProject);
            l.add(object);
            this.setModel(l);
        }
    }

    protected boolean hasChildren(Object object) {
        return !this.processChildren(object, (Processor<Object>)new CommonProcessors.FindFirstProcessor());
    }

    public void setChanged(boolean changed2) {
        this.myChanged = changed2;
    }

    static boolean isValid(Object object) {
        if (object instanceof Project) {
            return !((Project)object).isDisposed();
        }
        if (object instanceof Module) {
            return !((Module)object).isDisposed();
        }
        if (object instanceof PsiElement) {
            return (Boolean)ReadAction.compute(() -> ((PsiElement)object).isValid());
        }
        return object != null;
    }

    @Nullable
    public static PsiElement normalize(@Nullable PsiElement child2) {
        if (child2 == null) {
            return null;
        }
        List extensions2 = NavBarModelExtension.EP_NAME.getExtensionList();
        for (int i2 = extensions2.size() - 1; i2 >= 0; --i2) {
            NavBarModelExtension modelExtension = (NavBarModelExtension)extensions2.get(i2);
            child2 = modelExtension.adjustElement(child2);
            if (child2 != null) continue;
            return null;
        }
        return child2;
    }

    public List<Object> getChildren(Object object) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        PairProcessor processor2 = (o, ext) -> {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)(o instanceof PsiElement && ext.normalizeChildren() ? NavBarModel.normalize((PsiElement)o) : o));
            return true;
        };
        this.processChildrenWithExtensions(object, (PairProcessor<Object, ? super NavBarModelExtension>)processor2);
        result2.sort(new SiblingsComparator());
        return result2;
    }

    private boolean processChildren(Object object, @NotNull Processor<Object> processor2) {
        if (processor2 == null) {
            NavBarModel.$$$reportNull$$$0(9);
        }
        return this.processChildrenWithExtensions(object, (PairProcessor<Object, ? super NavBarModelExtension>)((PairProcessor)(o, ext) -> processor2.process(o)));
    }

    private boolean processChildrenWithExtensions(Object object, @NotNull PairProcessor<Object, ? super NavBarModelExtension> pairProcessor) {
        Object rootElement;
        if (pairProcessor == null) {
            NavBarModel.$$$reportNull$$$0(10);
        }
        if (!NavBarModel.isValid(object)) {
            return true;
        }
        Object object2 = rootElement = this.size() > 1 ? this.getElement(1) : null;
        if (rootElement != null && !NavBarModel.isValid(rootElement)) {
            return true;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            if (modelExtension.processChildren(object, rootElement, (Processor<Object>)((Processor)o -> pairProcessor.process(o, (Object)modelExtension)))) continue;
            return false;
        }
        return true;
    }

    public Object get(int index2) {
        return TreeAnchorizer.getService().retrieveElement(this.myModel.get(index2));
    }

    public int indexOf(Object value2) {
        for (int i2 = 0; i2 < this.myModel.size(); ++i2) {
            Object o = this.myModel.get(i2);
            if (!Objects.equals(TreeAnchorizer.getService().retrieveElement(o), value2)) continue;
            return i2;
        }
        return -1;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.mySelectedIndex != selectedIndex) {
            this.mySelectedIndex = selectedIndex;
            this.myNotificator.selectionChanged();
        }
    }

    public void setFixedComponent(boolean fixedComponent) {
        this.isFixedComponent = fixedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDataContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "anchorizeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateModelAsync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapDataContext";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "anchorizeList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenWithExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SiblingsComparator
    implements Comparator<Object> {
        private SiblingsComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int w1 = SiblingsComparator.getWeight(o1);
            int w2 = SiblingsComparator.getWeight(o2);
            if (w1 == 0) {
                return w2 == 0 ? 0 : -1;
            }
            if (w2 == 0) {
                return 1;
            }
            if (w1 != w2) {
                return -w1 + w2;
            }
            String s1 = NavBarPresentation.calcPresentableText(o1, false);
            String s2 = NavBarPresentation.calcPresentableText(o2, false);
            return StringUtil.naturalCompare((String)s1, (String)s2);
        }

        private static int getWeight(Object object) {
            return object instanceof Module ? 5 : (object instanceof PsiDirectoryContainer ? 4 : (object instanceof PsiDirectory ? 4 : (object instanceof PsiFile ? 2 : (object instanceof PsiNamedElement ? 3 : 0))));
        }
    }
}

