/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.plugins.BundledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState;", "", "()V", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class BundledPluginsState {
    @NotNull
    public static final String BUNDLED_PLUGINS_FILENAME = "bundled_plugins.txt";
    private static final String SAVED_VERSION_KEY = "bundled.plugins.list.saved.version";
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public BundledPluginsState() {
        if (Companion.shouldSave()) {
            ProcessIOExecutorService.INSTANCE.execute(1.INSTANCE);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        BundledPluginsState.logger = logger;
    }

    @JvmStatic
    @Nullable
    public static final List<Pair<PluginId, String>> getBundledPlugins(@NotNull Path configDir) {
        return Companion.getBundledPlugins(configDir);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0018\u00010\u0004j\u0002`\u000e0\f\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/BundledPluginsState$Companion;", "", "()V", "BUNDLED_PLUGINS_FILENAME", "", "Lorg/jetbrains/annotations/NonNls;", "SAVED_VERSION_KEY", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getBundledPlugins", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/Category;", "configDir", "Ljava/nio/file/Path;", "saveBundledPlugins", "", "file", "plugins", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "saveBundledPluginsOrLog", "shouldSave", "", "intellij.platform.core.impl"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldSave() {
            String string = PropertiesComponent.getInstance().getValue(BundledPluginsState.SAVED_VERSION_KEY);
            String string2 = string;
            if (string == null) return true;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            BuildNumber buildNumber = BuildNumber.fromString((String)it);
            string2 = buildNumber;
            if (buildNumber == null) return true;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PropertiesComponent.getI\u2026ring(it) } ?: return true");
            String savedVersion = string2;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                if (PluginManagerCore.isRunningFromSources()) return true;
            }
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            if (savedVersion.compareTo(applicationInfo.getBuild()) >= 0) return false;
            return true;
        }

        public final void saveBundledPluginsOrLog(@NotNull List<? extends IdeaPluginDescriptor> plugins2) {
            Intrinsics.checkNotNullParameter(plugins2, (String)"plugins");
            Path file2 = PathManager.getConfigDir().resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            try {
                Path path2 = file2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
                this.saveBundledPlugins(path2, plugins2);
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                propertiesComponent.setValue(BundledPluginsState.SAVED_VERSION_KEY, applicationInfo.getBuild().asString());
            }
            catch (IOException e) {
                logger.warn("Unable to save bundled plugins list", (Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final List<Pair<PluginId, String>> getBundledPlugins(@NotNull Path configDir) {
            Path file2;
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path path2 = file2 = configDir.resolve(BundledPluginsState.BUNDLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            Path path3 = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = false;
            if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            if (!Files.isRegularFile(file2, new LinkOption[0])) {
                return null;
            }
            boolean bl2 = false;
            List bundledPlugins = new ArrayList();
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable<Path> iterable = file2;
                Charset charset = Charsets.UTF_8;
                boolean bl3 = false;
                List<String> list2 = Files.readAllLines(iterable, charset);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"Files.readAllLines(this, charset)");
                iterable = list2;
                boolean $i$f$map = false;
                void var6_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void id2;
                    List list3;
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string2 = it;
                    boolean bl5 = false;
                    void v2 = string2;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    List splitResult = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString(), (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null);
                    if (splitResult.size() != 2) {
                        logger.warn("Incompatible format for bundled plugins list: " + file2);
                        return null;
                    }
                    List list4 = list3 = splitResult;
                    boolean bl6 = false;
                    string2 = (String)list4.get(0);
                    list4 = list3;
                    bl6 = false;
                    String category = (String)list4.get(1);
                    Boolean bl7 = bundledPlugins.add(new Pair((Object)PluginId.getId((String)id2), (Object)(Intrinsics.areEqual((Object)category, (Object)"null") ? null : category)));
                    collection.add(bl7);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            catch (IOException e) {
                logger.warn("Unable to load bundled plugins list from " + file2, (Throwable)e);
            }
            if (bundledPlugins.isEmpty()) {
                return null;
            }
            return bundledPlugins;
        }

        private final void saveBundledPlugins(Path file2, List<? extends IdeaPluginDescriptor> plugins2) {
            NioFiles.createDirectories((Path)file2.getParent());
            PathsKt.writeText$default((Path)file2, (CharSequence)CollectionsKt.joinToString$default((Iterable)plugins2, (CharSequence)"", null, null, (int)0, null, (Function1)saveBundledPlugins.1.INSTANCE, (int)30, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

