/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
public final class CustomPluginRepositoryService {
    private Collection<PluginNode> myCustomRepositoryPluginsList;
    private Map<String, List<PluginNode>> myCustomRepositoryPluginsMap;
    private final Object myRepositoriesLock = new Object();
    private static final Logger LOG = Logger.getInstance(CustomPluginRepositoryService.class);

    public static CustomPluginRepositoryService getInstance() {
        return (CustomPluginRepositoryService)ApplicationManager.getApplication().getService(CustomPluginRepositoryService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, List<PluginNode>> getCustomRepositoryPluginMap() {
        Object object = this.myRepositoriesLock;
        // MONITORENTER : object
        if (this.myCustomRepositoryPluginsMap != null) {
            Map<String, List<PluginNode>> map2 = this.myCustomRepositoryPluginsMap;
            // MONITOREXIT : object
            if (map2 != null) return map2;
            CustomPluginRepositoryService.$$$reportNull$$$0(0);
            return map2;
        }
        // MONITOREXIT : object
        HashMap<PluginId, PluginNode> latestCustomPluginsAsMap = new HashMap<PluginId, PluginNode>();
        HashMap<String, List<PluginNode>> customRepositoryPluginsMap = new HashMap<String, List<PluginNode>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            if (host == null) continue;
            try {
                List<PluginNode> descriptors = RepositoryHelper.loadPlugins(host, null, null);
                for (PluginNode descriptor2 : descriptors) {
                    PluginId pluginId = descriptor2.getPluginId();
                    IdeaPluginDescriptor savedDescriptor = (IdeaPluginDescriptor)latestCustomPluginsAsMap.get(pluginId);
                    if (savedDescriptor != null && StringUtil.compareVersionNumbers((String)descriptor2.getVersion(), (String)savedDescriptor.getVersion()) <= 0) continue;
                    latestCustomPluginsAsMap.put(pluginId, descriptor2);
                }
                customRepositoryPluginsMap.put(host, descriptors);
            }
            catch (IOException e) {
                LOG.info(host, (Throwable)e);
            }
        }
        Object object2 = this.myRepositoriesLock;
        // MONITORENTER : object2
        if (this.myCustomRepositoryPluginsMap == null) {
            this.myCustomRepositoryPluginsMap = customRepositoryPluginsMap;
            this.myCustomRepositoryPluginsList = latestCustomPluginsAsMap.values();
        }
        Map<String, List<PluginNode>> map3 = this.myCustomRepositoryPluginsMap;
        // MONITOREXIT : object2
        if (map3 != null) return map3;
        CustomPluginRepositoryService.$$$reportNull$$$0(1);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<PluginNode> getCustomRepositoryPlugins() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myCustomRepositoryPluginsList != null) {
                Collection<PluginNode> collection = this.myCustomRepositoryPluginsList;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (collection == null) {
                    CustomPluginRepositoryService.$$$reportNull$$$0(2);
                }
                return collection;
            }
        }
        this.getCustomRepositoryPluginMap();
        Collection<PluginNode> collection = this.myCustomRepositoryPluginsList;
        if (collection == null) {
            CustomPluginRepositoryService.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myCustomRepositoryPluginsList = null;
            this.myCustomRepositoryPluginsMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/CustomPluginRepositoryService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepositoryPluginMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepositoryPlugins";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

