/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeClassloaderReferencesGraph;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.ClassLoaderConfigurator;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.DynamicPluginsKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.LoadStateFilter;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ref.GCWatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.ToolTipManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.sf.cglib.core.ClassNameReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00be\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u001a\b\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\b\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a^\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001aJ\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*H\u0002\u001a\u001a\u0010+\u001a\u0004\u0018\u00010&2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\b\u0010.\u001a\u00020\u000eH\u0002\u001a,\u0010/\u001a\u00020\u000e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00180-2\u0006\u0010 \u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002\u001a.\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u0002082\u0006\u0010\u0011\u001a\u00020\u00122\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002\u001a`\u00109\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020'26\u0010=\u001a2\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020'0>H\u0002\u001a-\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0DH\u0082\b\u001a;\u0010E\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020'0DH\u0002\u001a`\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020'26\u0010=\u001a2\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(I\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(J\u0012\u0004\u0012\u00020'0>H\u0002\u001aX\u0010K\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010L\u001a\u00020'26\u0010=\u001a2\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020'0>H\u0002\u001a\u0018\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010O\u001a\u00020'2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a\u0018\u0010P\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010Q\u001a\u00020RH\u0002\u001a\u0018\u0010S\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010T\u001a\u00020RH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"GROUP_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "classloadersFromUnloadedPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/util/containers/WeakList;", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "analyzeSnapshot", "hprofPath", "pluginId", "clearCglibStopBacktrace", "", "clearNewFocusOwner", "clearPluginClassLoaderParentListCache", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "clearTemporaryLostComponent", "createDisposeTreePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/Disposable;", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "doCheckExtensionsCanUnloadWithoutRestart", "extensions", "", "", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "descriptor", "baseDescriptor", "app", "Lcom/intellij/openapi/application/Application;", "optionalDependencyPluginId", "context", "findLoadedPluginExtensionPointRecursive", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/ExtensionPointDescriptor;", "", "epName", "seenPlugins", "", "findPluginExtensionPoint", "getPluginWithContentModules", "Lkotlin/sequences/Sequence;", "hideTooltip", "loadModule", "modules", "Lcom/intellij/openapi/application/impl/ApplicationImpl;", "listenerCallbacks", "", "Ljava/lang/Runnable;", "loadOptionalDependenciesOnPlugin", "dependencyPlugin", "classLoaderConfigurator", "Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "processDependenciesOnPlugin", "loadStateFilter", "Lcom/intellij/ide/plugins/LoadStateFilter;", "onlyOptional", "processor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "moduleDescriptor", "processDirectDependencies", "module", "Lkotlin/Function1;", "processImplementationDetailDependenciesOnPlugin", "processOptionalDependenciesInOldFormatOnPlugin", "dependencyPluginId", "mainDescriptor", "main", "sub", "processOptionalDependenciesOnPlugin", "isLoaded", "reportUnloadResultToFus", "success", "saveMemorySnapshot", "setClassLoaderState", "state", "", "unloadClassLoader", "timeoutMs", "intellij.platform.ide.impl"})
public final class DynamicPluginsKt {
    private static final Logger LOG;
    private static final Map<PluginId, WeakList<PluginClassLoader>> classloadersFromUnloadedPlugins;
    private static final String GROUP_ID = "Dynamic plugin installation";

    private static final void clearTemporaryLostComponent() {
        try {
            Method clearMethod;
            block7: {
                Method method2;
                Method[] methodArray = Window.class.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"Window::class.java.declaredMethods");
                Method[] methodArray2 = methodArray;
                int n = 0;
                Method[] methodArray3 = methodArray2;
                int n2 = 0;
                Method[] methodArray4 = methodArray3;
                int n3 = methodArray4.length;
                for (int j = 0; j < n3; ++j) {
                    Method method3;
                    Method it = method3 = methodArray4[j];
                    boolean bl = false;
                    Method method4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"it");
                    if (!Intrinsics.areEqual((Object)method4.getName(), (Object)"setTemporaryLostComponent")) continue;
                    method2 = method3;
                    break block7;
                }
                method2 = clearMethod = null;
            }
            if (clearMethod == null) {
                LOG.info("setTemporaryLostComponent method not found");
                return;
            }
            clearMethod.setAccessible(true);
            WindowManager windowManager = WindowManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)windowManager, (String)"WindowManager.getInstance()");
            for (Method method5 : windowManager.getAllProjectFrames()) {
                Object object;
                Method method6 = method5;
                if (method6 instanceof ProjectFrameHelper) {
                    object = ((ProjectFrameHelper)((Object)method5)).getFrame();
                } else {
                    if (!(method6 instanceof Window)) continue;
                    object = method5;
                }
                Object window = object;
                clearMethod.invoke(window, new Object[]{null});
            }
        }
        catch (Throwable e) {
            LOG.info("Failed to clear Window.temporaryLostComponent", e);
        }
    }

    private static final void hideTooltip() {
        try {
            Method showMethod;
            block4: {
                Method method2;
                Method[] methodArray = ToolTipManager.class.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"ToolTipManager::class.java.declaredMethods");
                Method[] methodArray2 = methodArray;
                boolean bl = false;
                Method[] methodArray3 = methodArray2;
                boolean bl2 = false;
                Method[] methodArray4 = methodArray3;
                int n = methodArray4.length;
                for (int j = 0; j < n; ++j) {
                    Method method3;
                    Method it = method3 = methodArray4[j];
                    boolean bl3 = false;
                    Method method4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"it");
                    if (!Intrinsics.areEqual((Object)method4.getName(), (Object)"show")) continue;
                    method2 = method3;
                    break block4;
                }
                method2 = showMethod = null;
            }
            if (showMethod == null) {
                LOG.info("ToolTipManager.show method not found");
                return;
            }
            showMethod.setAccessible(true);
            showMethod.invoke((Object)ToolTipManager.sharedInstance(), new Object[]{null});
        }
        catch (Throwable e) {
            LOG.info("Failed to hide tooltip", e);
        }
    }

    private static final void clearCglibStopBacktrace() {
        Field field = ReflectionUtil.getDeclaredField(ClassNameReader.class, (String)"EARLY_EXIT");
        if (field != null) {
            try {
                Object object = field.get(null);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                ThrowableInterner.clearBacktrace((Throwable)((Throwable)object));
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    private static final void clearNewFocusOwner() {
        Field field = ReflectionUtil.getDeclaredField(KeyboardFocusManager.class, (String)"newFocusOwner");
        if (field != null) {
            try {
                field.set(null, null);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    private static final boolean saveMemorySnapshot(PluginId pluginId) {
        String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String snapshotFileName = "unload-" + pluginId + '-' + snapshotDate + ".hprof";
        String snapshotPath = System.getProperty("memory.snapshots.path", SystemProperties.getUserHome()) + "/" + snapshotFileName;
        MemoryDumpHelper.captureMemoryDump((String)snapshotPath);
        WeakList<PluginClassLoader> weakList = classloadersFromUnloadedPlugins.get(pluginId);
        if (weakList == null || weakList.isEmpty()) {
            LOG.info("Successfully unloaded plugin " + pluginId + " (classloader collected during memory snapshot generation)");
            return true;
        }
        if (Registry.is((String)"ide.plugins.analyze.snapshot")) {
            String analysisResult = DynamicPluginsKt.analyzeSnapshot(snapshotPath, pluginId);
            if (analysisResult.length() == 0) {
                LOG.info("Successfully unloaded plugin " + pluginId + " (no strong references to classloader in .hprof file)");
                classloadersFromUnloadedPlugins.remove(pluginId);
                return true;
            }
            LOG.info("Snapshot analysis result: " + analysisResult);
        }
        String string = IdeBundle.message((String)"memory.snapshot.captured.text", (Object[])new Object[]{snapshotPath, snapshotFileName});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"memor\u2026otPath, snapshotFileName)");
        DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(string, NotificationType.WARNING, (AnAction)new DumbAware(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationManager.getApplication().restart();
            }
        }, (AnAction)new DumbAware(snapshotPath, snapshotFileName, IdeBundle.message((String)"memory.snapshot.captured.action.text", (Object[])new Object[]{snapshotFileName, RevealFileAction.getFileManagerName()})){
            final /* synthetic */ String $snapshotPath;
            final /* synthetic */ String $snapshotFileName;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RevealFileAction.openFile(Paths.get(this.$snapshotPath, new String[0]));
            }
            {
                this.$snapshotPath = $captured_local_variable$0;
                this.$snapshotFileName = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        LOG.info("Plugin " + pluginId + " is not unload-safe because class loader cannot be unloaded. Memory snapshot created at " + snapshotPath);
        return false;
    }

    private static final void processImplementationDetailDependenciesOnPlugin(IdeaPluginDescriptorImpl pluginDescriptor, PluginSet pluginSet, Function1<? super IdeaPluginDescriptorImpl, Boolean> processor2) {
        DynamicPluginsKt.processDependenciesOnPlugin(pluginDescriptor, pluginSet, LoadStateFilter.ANY, false, (Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean>)((Function2)new Function2<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl, Boolean>(processor2){
            final /* synthetic */ Function1 $processor;

            public final boolean invoke(@NotNull IdeaPluginDescriptorImpl $noName_0, @NotNull IdeaPluginDescriptorImpl module) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return module.isImplementationDetail() ? (Boolean)this.$processor.invoke((Object)module) : true;
            }
            {
                this.$processor = function1;
                super(2);
            }
        }));
    }

    private static final void loadOptionalDependenciesOnPlugin(IdeaPluginDescriptorImpl dependencyPlugin, ClassLoaderConfigurator classLoaderConfigurator, PluginSet pluginSet, List<Runnable> listenerCallbacks) {
        LinkedHashMap mainToModule = new LinkedHashMap();
        DynamicPluginsKt.processOptionalDependenciesOnPlugin(dependencyPlugin, pluginSet, false, (Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean>)((Function2)new Function2<IdeaPluginDescriptorImpl, IdeaPluginDescriptorImpl, Boolean>(mainToModule){
            final /* synthetic */ LinkedHashMap $mainToModule;

            public final boolean invoke(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl subDescriptor) {
                boolean bl;
                List subDescriptors2;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
                    Intrinsics.checkNotNullParameter((Object)subDescriptor, (String)"subDescriptor");
                    V v = this.$mainToModule.computeIfAbsent(mainDescriptor, loadOptionalDependenciesOnPlugin.subDescriptors.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(v, (String)"mainToModule.computeIfAb\u2026ptor) { mutableListOf() }");
                    subDescriptors2 = (List)v;
                    Iterable $this$any$iv = subDescriptors2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                            boolean bl2 = false;
                            if (!(it == subDescriptor)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw (Throwable)new PluginException("Descriptor has already been added: " + subDescriptor, subDescriptor.getPluginId());
                }
                return subDescriptors2.add(subDescriptor);
            }
            {
                this.$mainToModule = linkedHashMap;
                super(2);
            }
        }));
        if (mainToModule.isEmpty()) {
            return;
        }
        classLoaderConfigurator.configureDependenciesIfNeeded(mainToModule);
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl app2 = (ApplicationImpl)application;
        for (Map.Entry entry2 : mainToModule.entrySet()) {
            for (IdeaPluginDescriptorImpl subDescriptor : (List)entry2.getValue()) {
                DynamicPluginsKt.loadModule((Sequence<IdeaPluginDescriptorImpl>)SequencesKt.sequenceOf((Object[])new IdeaPluginDescriptorImpl[]{subDescriptor}), app2, listenerCallbacks);
            }
        }
    }

    private static final void clearPluginClassLoaderParentListCache(PluginSet pluginSet) {
        for (IdeaPluginDescriptorImpl descriptor2 : pluginSet.allPlugins) {
            ClassLoader classLoader = descriptor2.getPluginClassLoader();
            if (!(classLoader instanceof PluginClassLoader)) {
                classLoader = null;
            }
            PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classLoader);
            if (pluginClassLoader == null) {
                continue;
            }
            pluginClassLoader.clearParentListCache();
        }
    }

    private static final void loadModule(Sequence<IdeaPluginDescriptorImpl> modules2, ApplicationImpl app2, List<Runnable> listenerCallbacks) {
        app2.registerComponents(modules2, app2, null, listenerCallbacks);
        Project[] projectArray = ProjectUtil.getOpenProjects();
        int n = projectArray.length;
        for (int j = 0; j < n; ++j) {
            Project openProject2;
            Project project = openProject2 = projectArray[j];
            if (project == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
            }
            ((ComponentManagerImpl)project).registerComponents(modules2, app2, null, listenerCallbacks);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)openProject2);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(openProject)");
            Module[] moduleArray = moduleManager.getModules();
            int n2 = moduleArray.length;
            for (int k = 0; k < n2; ++k) {
                Module module;
                Module module2 = module = moduleArray[k];
                if (module2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
                }
                ((ComponentManagerImpl)module2).registerComponents(modules2, app2, null, listenerCallbacks);
            }
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
        }
        ((ActionManagerImpl)actionManager).registerActions(modules2);
    }

    private static final Sequence<IdeaPluginDescriptorImpl> getPluginWithContentModules(IdeaPluginDescriptorImpl pluginDescriptor, PluginSet pluginSet) {
        return SequencesKt.filter(pluginSet.getEnabledModules(), (Function1)((Function1)new Function1<IdeaPluginDescriptorImpl, Boolean>(pluginDescriptor){
            final /* synthetic */ IdeaPluginDescriptorImpl $pluginDescriptor;

            public final boolean invoke(@NotNull IdeaPluginDescriptorImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getPluginId(), (Object)this.$pluginDescriptor.getPluginId());
            }
            {
                this.$pluginDescriptor = ideaPluginDescriptorImpl;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String analyzeSnapshot(String hprofPath, PluginId pluginId) {
        Closeable closeable = FileChannel.open(Paths.get(hprofPath, new String[0]), StandardOpenOption.READ);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileChannel channel2 = (FileChannel)closeable;
            boolean bl3 = false;
            FileChannel fileChannel = channel2;
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"channel");
            HProfAnalysis analysis = new HProfAnalysis(fileChannel, new SystemTempFilenameSupplier(), (Function2<? super AnalysisContext, ? super ProgressIndicator, String>)((Function2)new Function2<AnalysisContext, ProgressIndicator, String>(pluginId){
                final /* synthetic */ PluginId $pluginId$inlined;
                {
                    this.$pluginId$inlined = pluginId;
                    super(2);
                }

                @NotNull
                public final String invoke(@NotNull AnalysisContext analysisContext, @NotNull ProgressIndicator progressIndicator) {
                    Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
                    Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                    String string = this.$pluginId$inlined.getIdString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginId.idString");
                    return new AnalyzeClassloaderReferencesGraph(analysisContext, string).analyze(progressIndicator);
                }
            }));
            analysis.setOnlyStrongReferences(true);
            analysis.setIncludeClassesAsRoots(false);
            analysis.setIncludeMetaInfo(false);
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"ProgressManager.getGloba\u2026 EmptyProgressIndicator()");
            String string = analysis.analyze(progressIndicator);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Predicate<Disposable> createDisposeTreePredicate(IdeaPluginDescriptorImpl pluginDescriptor) {
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        if (!(classLoader instanceof PluginClassLoader)) {
            classLoader = null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classLoader);
        if (pluginClassLoader == null) {
            return null;
        }
        PluginClassLoader classLoader2 = pluginClassLoader;
        return new Predicate(classLoader2){
            final /* synthetic */ PluginClassLoader $classLoader;

            public final boolean test(@NotNull Disposable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof PluginManager.PluginAwareDisposable ? ((PluginManager.PluginAwareDisposable)it).getClassLoaderId() == this.$classLoader.getInstanceId() : it.getClass().getClassLoader() == this.$classLoader;
            }
            {
                this.$classLoader = pluginClassLoader;
            }
        };
    }

    private static final void processOptionalDependenciesOnPlugin(IdeaPluginDescriptorImpl dependencyPlugin, PluginSet pluginSet, boolean isLoaded, Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean> processor2) {
        Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean> function2 = processor2;
        LoadStateFilter loadStateFilter = isLoaded ? LoadStateFilter.LOADED : LoadStateFilter.NOT_LOADED;
        boolean bl = true;
        DynamicPluginsKt.processDependenciesOnPlugin(dependencyPlugin, pluginSet, loadStateFilter, bl, function2);
    }

    private static final void processDependenciesOnPlugin(IdeaPluginDescriptorImpl dependencyPlugin, PluginSet pluginSet, LoadStateFilter loadStateFilter, boolean onlyOptional, Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean> processor2) {
        HashSet<String> wantedIds = new HashSet<String>(1 + dependencyPlugin.content.modules.size());
        wantedIds.add(dependencyPlugin.getPluginId().getIdString());
        for (PluginContentDescriptor.ModuleItem module : dependencyPlugin.content.modules) {
            wantedIds.add(module.name);
        }
        for (IdeaPluginDescriptorImpl plugin2 : pluginSet.enabledPlugins) {
            if (plugin2 == dependencyPlugin) continue;
            if (!DynamicPluginsKt.processOptionalDependenciesInOldFormatOnPlugin(dependencyPlugin.getPluginId(), plugin2, loadStateFilter, onlyOptional, processor2)) {
                return;
            }
            for (PluginContentDescriptor.ModuleItem moduleItem : plugin2.content.modules) {
                boolean isModuleLoaded;
                IdeaPluginDescriptorImpl module = moduleItem.requireDescriptor();
                if (loadStateFilter != LoadStateFilter.ANY && (isModuleLoaded = module.getPluginClassLoader() != null) != (loadStateFilter == LoadStateFilter.LOADED)) continue;
                for (ModuleDependenciesDescriptor.ModuleReference item : module.dependencies.modules) {
                    if (!wantedIds.contains(item.name) || ((Boolean)processor2.invoke((Object)plugin2, (Object)module)).booleanValue()) continue;
                    return;
                }
                for (ModuleDependenciesDescriptor.PluginReference item : module.dependencies.plugins) {
                    if (!Intrinsics.areEqual((Object)dependencyPlugin.getPluginId(), (Object)item.id) || ((Boolean)processor2.invoke((Object)plugin2, (Object)module)).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    private static final boolean processOptionalDependenciesInOldFormatOnPlugin(PluginId dependencyPluginId, IdeaPluginDescriptorImpl mainDescriptor, LoadStateFilter loadStateFilter, boolean onlyOptional, Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean> processor2) {
        for (PluginDependency dependency : mainDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            boolean isModuleLoaded;
            if (!dependency.isOptional()) {
                if (onlyOptional || !Intrinsics.areEqual((Object)dependency.getPluginId(), (Object)dependencyPluginId) || ((Boolean)processor2.invoke((Object)mainDescriptor, (Object)mainDescriptor)).booleanValue()) continue;
                return false;
            }
            if (dependency.subDescriptor == null) {
                continue;
            }
            if (loadStateFilter != LoadStateFilter.ANY && (isModuleLoaded = subDescriptor.getPluginClassLoader() != null) != (loadStateFilter == LoadStateFilter.LOADED)) continue;
            if (Intrinsics.areEqual((Object)dependency.getPluginId(), (Object)dependencyPluginId) && !((Boolean)processor2.invoke((Object)mainDescriptor, (Object)subDescriptor)).booleanValue()) {
                return false;
            }
            if (DynamicPluginsKt.processOptionalDependenciesInOldFormatOnPlugin(dependencyPluginId, subDescriptor, loadStateFilter, onlyOptional, processor2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final String doCheckExtensionsCanUnloadWithoutRestart(Map<String, ? extends List<ExtensionDescriptor>> extensions2, IdeaPluginDescriptorImpl descriptor2, IdeaPluginDescriptorImpl baseDescriptor, Application app2, PluginId optionalDependencyPluginId, List<IdeaPluginDescriptorImpl> context2, PluginSet pluginSet) {
        Module module;
        Object[] objectArray = ProjectUtil.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectUtil.getOpenProjects()");
        Project firstProject = (Project)ArraysKt.firstOrNull((Object[])objectArray);
        Project project = firstProject;
        if (project == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project2 = projectManager.getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"ProjectManager.getInstance().defaultProject");
        }
        Project anyProject = project;
        Project project3 = firstProject;
        if (project3 != null) {
            Project project4 = project3;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project4;
            boolean bl3 = false;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)it);
            Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(it)");
            Object[] objectArray2 = moduleManager.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"ModuleManager.getInstance(it).modules");
            module = (Module)ArraysKt.firstOrNull((Object[])objectArray2);
        } else {
            module = null;
        }
        Module anyModule = module;
        Set<IdeaPluginDescriptorImpl> set2 = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"Collections.newSetFromMap(IdentityHashMap())");
        Set<IdeaPluginDescriptorImpl> seenPlugins = set2;
        block0: for (String epName : extensions2.keySet()) {
            ExtensionPoint ep2;
            ExtensionPoint extensionPoint;
            seenPlugins.clear();
            Function1<PluginId, String> $fun$getNonDynamicUnloadError$1 = new Function1<PluginId, String>(baseDescriptor, epName, descriptor2){
                final /* synthetic */ IdeaPluginDescriptorImpl $baseDescriptor;
                final /* synthetic */ String $epName;
                final /* synthetic */ IdeaPluginDescriptorImpl $descriptor;

                @NotNull
                public final String invoke(@Nullable PluginId optionalDependencyPluginId) {
                    Object object;
                    block3: {
                        block2: {
                            object = optionalDependencyPluginId;
                            if (object == null) break block2;
                            PluginId pluginId = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            PluginId it = pluginId;
                            boolean bl3 = false;
                            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = this.$baseDescriptor;
                            object = "Plugin " + (ideaPluginDescriptorImpl != null ? ideaPluginDescriptorImpl.getPluginId() : null) + " is not unload-safe because of use of non-dynamic EP " + this.$epName + " in plugin " + it + " that optionally depends on it";
                            if (object != null) break block3;
                        }
                        object = "Plugin " + this.$descriptor.getPluginId() + " is not unload-safe because of extension to non-dynamic EP " + this.$epName;
                    }
                    return object;
                }
                {
                    this.$baseDescriptor = ideaPluginDescriptorImpl;
                    this.$epName = string;
                    this.$descriptor = ideaPluginDescriptorImpl2;
                    super(1);
                }
            };
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = baseDescriptor;
            if (ideaPluginDescriptorImpl == null) {
                ideaPluginDescriptorImpl = descriptor2;
            }
            Pair<ExtensionPointDescriptor, Boolean> result2 = DynamicPluginsKt.findLoadedPluginExtensionPointRecursive(ideaPluginDescriptorImpl, epName, pluginSet, context2, seenPlugins);
            if (result2 != null) {
                void pluginExtensionPoint;
                Pair<ExtensionPointDescriptor, Boolean> pair = result2;
                ExtensionPointDescriptor extensionPointDescriptor = (ExtensionPointDescriptor)pair.component1();
                boolean foundInDependencies = (Boolean)pair.component2();
                if (pluginExtensionPoint.isDynamic) continue;
                if (baseDescriptor == null || foundInDependencies) {
                    return $fun$getNonDynamicUnloadError$1.invoke(null);
                }
                if (descriptor2 != baseDescriptor) continue;
                return $fun$getNonDynamicUnloadError$1.invoke(descriptor2.getPluginId());
            }
            ExtensionPoint extensionPoint2 = app2.getExtensionArea().getExtensionPointIfRegistered(epName);
            if (extensionPoint2 == null) {
                extensionPoint2 = extensionPoint = anyProject.getExtensionArea().getExtensionPointIfRegistered(epName);
            }
            if (extensionPoint2 == null) {
                Module module2 = anyModule;
                extensionPoint = module2 != null && (module2 = module2.getExtensionArea()) != null ? module2.getExtensionPointIfRegistered(epName) : (ep2 = null);
            }
            if (ep2 != null) {
                if (ep2.isDynamic()) continue;
                return $fun$getNonDynamicUnloadError$1.invoke(optionalDependencyPluginId);
            }
            if (anyModule == null) {
                ExtensionPointDescriptor coreEP;
                PluginId pluginId = PluginManagerCore.CORE_ID;
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginManagerCore.CORE_ID");
                IdeaPluginDescriptorImpl corePlugin = pluginSet.findEnabledPlugin(pluginId);
                if (corePlugin != null && (coreEP = DynamicPluginsKt.findPluginExtensionPoint(corePlugin, epName)) != null) {
                    if (coreEP.isDynamic) continue;
                    return $fun$getNonDynamicUnloadError$1.invoke(optionalDependencyPluginId);
                }
            }
            for (IdeaPluginDescriptorImpl contextPlugin : context2) {
                ExtensionPointDescriptor contextEp;
                if (DynamicPluginsKt.findPluginExtensionPoint(contextPlugin, epName) == null) {
                    continue;
                }
                if (contextEp.isDynamic) continue block0;
                return $fun$getNonDynamicUnloadError$1.invoke(null);
            }
            if (StringsKt.startsWith$default((String)epName, (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)descriptor2.getPluginId().getIdString(), (Object)"org.jetbrains.kotlin")) continue;
            return "Plugin " + descriptor2.getPluginId() + " is not unload-safe because of unresolved extension " + epName;
        }
        return null;
    }

    private static final ExtensionPointDescriptor findPluginExtensionPoint(IdeaPluginDescriptorImpl pluginDescriptor, String epName) {
        ExtensionPointDescriptor extensionPointDescriptor;
        Function1<ContainerDescriptor, ExtensionPointDescriptor> $fun$findContainerExtensionPoint$1 = new Function1<ContainerDescriptor, ExtensionPointDescriptor>(epName, pluginDescriptor){
            final /* synthetic */ String $epName;
            final /* synthetic */ IdeaPluginDescriptorImpl $pluginDescriptor;

            @Nullable
            public final ExtensionPointDescriptor invoke(@NotNull ContainerDescriptor containerDescriptor) {
                ExtensionPointDescriptor extensionPointDescriptor;
                Intrinsics.checkNotNullParameter((Object)containerDescriptor, (String)"containerDescriptor");
                List<ExtensionPointDescriptor> list2 = containerDescriptor.extensionPoints;
                if (list2 != null) {
                    Object v1;
                    block3: {
                        Iterable iterable = list2;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (T t : iterable2) {
                            ExtensionPointDescriptor it = (ExtensionPointDescriptor)t;
                            boolean bl3 = false;
                            if (!it.nameEquals(this.$epName, (PluginDescriptor)this.$pluginDescriptor)) continue;
                            v1 = t;
                            break block3;
                        }
                        v1 = null;
                    }
                    extensionPointDescriptor = v1;
                } else {
                    extensionPointDescriptor = null;
                }
                return extensionPointDescriptor;
            }
            {
                this.$epName = string;
                this.$pluginDescriptor = ideaPluginDescriptorImpl;
                super(1);
            }
        };
        ExtensionPointDescriptor extensionPointDescriptor2 = $fun$findContainerExtensionPoint$1.invoke(pluginDescriptor.appContainerDescriptor);
        if (extensionPointDescriptor2 == null) {
            extensionPointDescriptor2 = extensionPointDescriptor = $fun$findContainerExtensionPoint$1.invoke(pluginDescriptor.projectContainerDescriptor);
        }
        if (extensionPointDescriptor2 == null) {
            extensionPointDescriptor = $fun$findContainerExtensionPoint$1.invoke(pluginDescriptor.moduleContainerDescriptor);
        }
        return extensionPointDescriptor;
    }

    private static final Pair<ExtensionPointDescriptor, Boolean> findLoadedPluginExtensionPointRecursive(IdeaPluginDescriptorImpl pluginDescriptor, String epName, PluginSet pluginSet, List<IdeaPluginDescriptorImpl> context2, Set<IdeaPluginDescriptorImpl> seenPlugins) {
        boolean bl;
        Pair<ExtensionPointDescriptor, Boolean> pair;
        if (!seenPlugins.add(pluginDescriptor)) {
            return null;
        }
        ExtensionPointDescriptor extensionPointDescriptor = DynamicPluginsKt.findPluginExtensionPoint(pluginDescriptor, epName);
        if (extensionPointDescriptor != null) {
            ExtensionPointDescriptor extensionPointDescriptor2 = extensionPointDescriptor;
            boolean bl2 = false;
            boolean bl3 = false;
            ExtensionPointDescriptor it = extensionPointDescriptor2;
            boolean bl4 = false;
            return TuplesKt.to((Object)it, (Object)false);
        }
        for (PluginDependency dependency : pluginDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            boolean $i$f$any;
            if (!pluginSet.isPluginEnabled(dependency.getPluginId())) {
                boolean bl2;
                block12: {
                    Iterable iterable = context2;
                    $i$f$any = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : iterable) {
                            IdeaPluginDescriptorImpl it = (IdeaPluginDescriptorImpl)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)dependency.getPluginId())) continue;
                            bl2 = true;
                            break block12;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
            }
            if (dependency.subDescriptor != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                $i$f$any = false;
                boolean bl4 = false;
                IdeaPluginDescriptorImpl subDescriptor = ideaPluginDescriptorImpl2;
                boolean bl7 = false;
                Pair<ExtensionPointDescriptor, Boolean> pair2 = DynamicPluginsKt.findLoadedPluginExtensionPointRecursive(subDescriptor, epName, pluginSet, context2, seenPlugins);
                if (pair2 != null) {
                    Pair<ExtensionPointDescriptor, Boolean> pair3 = pair2;
                    boolean bl3 = false;
                    boolean bl5 = false;
                    Pair<ExtensionPointDescriptor, Boolean> it = pair3;
                    boolean bl10 = false;
                    return it;
                }
            }
            if (pluginSet.findEnabledPlugin(dependency.getPluginId()) == null) continue;
            $i$f$any = false;
            boolean bl4 = false;
            IdeaPluginDescriptorImpl dependencyDescriptor = ideaPluginDescriptorImpl;
            boolean bl11 = false;
            Pair<ExtensionPointDescriptor, Boolean> pair4 = DynamicPluginsKt.findLoadedPluginExtensionPointRecursive(dependencyDescriptor, epName, pluginSet, context2, seenPlugins);
            if (pair4 != null) {
                Pair<ExtensionPointDescriptor, Boolean> pair5 = pair4;
                boolean bl6 = false;
                boolean bl7 = false;
                Pair<ExtensionPointDescriptor, Boolean> it = pair5;
                boolean bl14 = false;
                return TuplesKt.to((Object)it.getFirst(), (Object)true);
            }
        }
        boolean $i$f$processDirectDependencies = false;
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : pluginDescriptor.dependencies.modules) {
            IdeaPluginDescriptorImpl descriptor$iv = pluginSet.findEnabledModule(moduleReference.name);
            if (descriptor$iv == null) continue;
            IdeaPluginDescriptorImpl dependency = descriptor$iv;
            boolean bl15 = false;
            Pair<ExtensionPointDescriptor, Boolean> pair6 = DynamicPluginsKt.findLoadedPluginExtensionPointRecursive(dependency, epName, pluginSet, context2, seenPlugins);
            if (pair6 == null) continue;
            pair = pair6;
            bl = false;
            boolean bl8 = false;
            Pair<ExtensionPointDescriptor, Boolean> it = pair;
            boolean bl17 = false;
            return TuplesKt.to((Object)it.getFirst(), (Object)true);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : pluginDescriptor.dependencies.plugins) {
            IdeaPluginDescriptorImpl descriptor$iv = pluginSet.findEnabledPlugin(pluginReference.id);
            if (descriptor$iv == null) continue;
            IdeaPluginDescriptorImpl dependency = descriptor$iv;
            boolean bl18 = false;
            Pair<ExtensionPointDescriptor, Boolean> pair7 = DynamicPluginsKt.findLoadedPluginExtensionPointRecursive(dependency, epName, pluginSet, context2, seenPlugins);
            if (pair7 == null) continue;
            pair = pair7;
            bl = false;
            boolean bl9 = false;
            Pair<ExtensionPointDescriptor, Boolean> it = pair;
            boolean bl20 = false;
            return TuplesKt.to((Object)it.getFirst(), (Object)true);
        }
        return null;
    }

    private static final void processDirectDependencies(IdeaPluginDescriptorImpl module, PluginSet pluginSet, Function1<? super IdeaPluginDescriptorImpl, Unit> processor2) {
        int $i$f$processDirectDependencies = 0;
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
            IdeaPluginDescriptorImpl descriptor2 = pluginSet.findEnabledModule(moduleReference.name);
            if (descriptor2 == null) continue;
            processor2.invoke((Object)descriptor2);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
            IdeaPluginDescriptorImpl descriptor2 = pluginSet.findEnabledPlugin(pluginReference.id);
            if (descriptor2 == null) continue;
            processor2.invoke((Object)descriptor2);
        }
    }

    private static final boolean unloadClassLoader(IdeaPluginDescriptorImpl pluginDescriptor, int timeoutMs) {
        if (timeoutMs == 0) {
            pluginDescriptor.setPluginClassLoader(null);
            return true;
        }
        GCWatcher gCWatcher = GCWatcher.tracking((Object[])new Object[]{pluginDescriptor.getPluginClassLoader()});
        Intrinsics.checkNotNullExpressionValue((Object)gCWatcher, (String)"GCWatcher.tracking(plugi\u2026riptor.pluginClassLoader)");
        GCWatcher watcher = gCWatcher;
        pluginDescriptor.setPluginClassLoader(null);
        return watcher.tryCollect(timeoutMs);
    }

    private static final void setClassLoaderState(IdeaPluginDescriptorImpl pluginDescriptor, int state) {
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        if (!(classLoader instanceof PluginClassLoader)) {
            classLoader = null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)((Object)classLoader);
        if (pluginClassLoader != null) {
            pluginClassLoader.setState(state);
        }
        for (PluginDependency dependency : pluginDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl;
            boolean bl3 = false;
            DynamicPluginsKt.setClassLoaderState(it, state);
        }
    }

    private static final void reportUnloadResultToFus(boolean success2, IdeaPluginDescriptorImpl pluginDescriptor) {
        String eventId = success2 ? "unload.success" : "unload.fail";
        FeatureUsageData usageData = new FeatureUsageData().addPluginInfo(PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)((PluginDescriptor)pluginDescriptor)));
        FUCounterUsageLogger.getInstance().logEvent("plugins.dynamic", eventId, usageData);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DynamicPlugins.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        boolean bl = false;
        classloadersFromUnloadedPlugins = new LinkedHashMap();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Map access$getClassloadersFromUnloadedPlugins$p() {
        return classloadersFromUnloadedPlugins;
    }

    public static final /* synthetic */ String access$doCheckExtensionsCanUnloadWithoutRestart(Map extensions2, IdeaPluginDescriptorImpl descriptor2, IdeaPluginDescriptorImpl baseDescriptor, Application app2, PluginId optionalDependencyPluginId, List context2, PluginSet pluginSet) {
        return DynamicPluginsKt.doCheckExtensionsCanUnloadWithoutRestart(extensions2, descriptor2, baseDescriptor, app2, optionalDependencyPluginId, context2, pluginSet);
    }

    public static final /* synthetic */ void access$processOptionalDependenciesOnPlugin(IdeaPluginDescriptorImpl dependencyPlugin, PluginSet pluginSet, boolean isLoaded, Function2 processor2) {
        DynamicPluginsKt.processOptionalDependenciesOnPlugin(dependencyPlugin, pluginSet, isLoaded, (Function2<? super IdeaPluginDescriptorImpl, ? super IdeaPluginDescriptorImpl, Boolean>)processor2);
    }

    public static final /* synthetic */ void access$processImplementationDetailDependenciesOnPlugin(IdeaPluginDescriptorImpl pluginDescriptor, PluginSet pluginSet, Function1 processor2) {
        DynamicPluginsKt.processImplementationDetailDependenciesOnPlugin(pluginDescriptor, pluginSet, (Function1<? super IdeaPluginDescriptorImpl, Boolean>)processor2);
    }

    public static final /* synthetic */ void access$reportUnloadResultToFus(boolean success2, IdeaPluginDescriptorImpl pluginDescriptor) {
        DynamicPluginsKt.reportUnloadResultToFus(success2, pluginDescriptor);
    }

    public static final /* synthetic */ void access$setClassLoaderState(IdeaPluginDescriptorImpl pluginDescriptor, int state) {
        DynamicPluginsKt.setClassLoaderState(pluginDescriptor, state);
    }

    public static final /* synthetic */ void access$clearPluginClassLoaderParentListCache(PluginSet pluginSet) {
        DynamicPluginsKt.clearPluginClassLoaderParentListCache(pluginSet);
    }

    public static final /* synthetic */ void access$clearNewFocusOwner() {
        DynamicPluginsKt.clearNewFocusOwner();
    }

    public static final /* synthetic */ void access$hideTooltip() {
        DynamicPluginsKt.hideTooltip();
    }

    public static final /* synthetic */ void access$clearTemporaryLostComponent() {
        DynamicPluginsKt.clearTemporaryLostComponent();
    }

    public static final /* synthetic */ void access$clearCglibStopBacktrace() {
        DynamicPluginsKt.clearCglibStopBacktrace();
    }

    public static final /* synthetic */ boolean access$unloadClassLoader(IdeaPluginDescriptorImpl pluginDescriptor, int timeoutMs) {
        return DynamicPluginsKt.unloadClassLoader(pluginDescriptor, timeoutMs);
    }

    public static final /* synthetic */ boolean access$saveMemorySnapshot(PluginId pluginId) {
        return DynamicPluginsKt.saveMemorySnapshot(pluginId);
    }

    public static final /* synthetic */ Predicate access$createDisposeTreePredicate(IdeaPluginDescriptorImpl pluginDescriptor) {
        return DynamicPluginsKt.createDisposeTreePredicate(pluginDescriptor);
    }

    public static final /* synthetic */ Sequence access$getPluginWithContentModules(IdeaPluginDescriptorImpl pluginDescriptor, PluginSet pluginSet) {
        return DynamicPluginsKt.getPluginWithContentModules(pluginDescriptor, pluginSet);
    }

    public static final /* synthetic */ void access$loadModule(Sequence modules2, ApplicationImpl app2, List listenerCallbacks) {
        DynamicPluginsKt.loadModule((Sequence<IdeaPluginDescriptorImpl>)modules2, app2, listenerCallbacks);
    }

    public static final /* synthetic */ void access$loadOptionalDependenciesOnPlugin(IdeaPluginDescriptorImpl dependencyPlugin, ClassLoaderConfigurator classLoaderConfigurator, PluginSet pluginSet, List listenerCallbacks) {
        DynamicPluginsKt.loadOptionalDependenciesOnPlugin(dependencyPlugin, classLoaderConfigurator, pluginSet, listenerCallbacks);
    }
}

