/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PluginHeaderPanel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private IdeaPluginDescriptor myPlugin;
    private JBLabel myCategory;
    private JBLabel myName;
    private JBLabel myDownloads;
    private RatesPanel myRating;
    private JBLabel myUpdated;
    private JBLabel myVersion;
    private JPanel myRoot;
    private JPanel myDownloadsPanel;
    private JPanel myVersionInfoPanel;

    public PluginHeaderPanel() {
        this.$$$setupUI$$$();
        Font font = this.myName.getFont();
        this.myName.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() + 2));
        JBColor greyed = new JBColor((Color)Gray._130, (Color)Gray._200);
        this.myCategory.setForeground((Color)greyed);
        this.myDownloads.setForeground((Color)greyed);
        this.myUpdated.setForeground((Color)greyed);
        this.myVersion.setForeground((Color)greyed);
        Font smallFont = new Font(font.getFontName(), font.getStyle(), font.getSize() - 1);
        this.myCategory.setFont(smallFont);
        this.myVersion.setFont(smallFont);
        this.myVersion.setCopyable(true);
        this.myDownloads.setFont(smallFont);
        this.myUpdated.setFont(smallFont);
        this.myRoot.setVisible(false);
    }

    public void setPlugin(IdeaPluginDescriptor plugin2) {
        Object versionText;
        boolean showVersion;
        this.myPlugin = plugin2;
        this.myRoot.setVisible(true);
        this.myRoot.setBackground(UIUtil.getTextFieldBackground());
        this.myCategory.setVisible(true);
        this.myDownloadsPanel.setVisible(true);
        this.myUpdated.setVisible(true);
        this.myName.setFont(UIUtil.getLabelFont().deriveFont(4.0f + (float)UIUtil.getLabelFont().getSize()));
        this.myName.setText("<html><body>" + plugin2.getName() + "</body></html>");
        this.myCategory.setText(plugin2.getCategory() == null ? IdeBundle.message((String)"label.category.unknown", (Object[])new Object[0]) : StringUtil.toUpperCase((String)plugin2.getCategory()));
        boolean bl = showVersion = !plugin2.isBundled() || plugin2.allowBundledUpdate();
        if (plugin2 instanceof PluginNode) {
            PluginNode node2 = (PluginNode)plugin2;
            this.myRating.setRate(node2.getRating());
            this.myDownloads.setText(IdeBundle.message((String)"label.plugin.0.downloads", (Object[])new Object[]{node2.getDownloads()}));
            versionText = showVersion ? "v" + node2.getVersion() : null;
            this.myUpdated.setText(IdeBundle.message((String)"label.plugin.updated.0", (Object[])new Object[]{DateFormatUtil.formatDate((long)node2.getDate())}));
            if (node2.getRepositoryName() != null) {
                this.myCategory.setVisible(false);
                this.myDownloadsPanel.setVisible(false);
                this.myUpdated.setVisible(false);
            }
        } else {
            this.myVersionInfoPanel.remove((Component)this.myUpdated);
            this.myCategory.setVisible(false);
            this.myDownloadsPanel.setVisible(false);
            String version2 = plugin2.getVersion();
            versionText = ourState.wasUpdated(plugin2.getPluginId()) ? IdeBundle.message((String)"label.new.version.will.be.available.after.restart", (Object[])new Object[0]) : (version2 != null && showVersion ? IdeBundle.message((String)"label.version", (Object[])new Object[]{version2}) : null);
            this.myUpdated.setVisible(false);
        }
        this.myVersion.setVisible(versionText != null);
        this.myVersion.setText(StringUtil.notNullize((String)versionText));
        this.myRoot.revalidate();
        this.myVersion.getParent().revalidate();
        this.myVersion.revalidate();
    }

    public JBLabel getCategory() {
        return this.myCategory;
    }

    public JBLabel getName() {
        return this.myName;
    }

    public JBLabel getDownloads() {
        return this.myDownloads;
    }

    public RatesPanel getRating() {
        return this.myRating;
    }

    public JBLabel getUpdated() {
        return this.myUpdated;
    }

    public JPanel getPanel() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JBLabel jBLabel3;
        RatesPanel ratesPanel;
        JPanel jPanel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel4;
        this.myRoot = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setOpaque(true);
        this.myCategory = jBLabel5 = new JBLabel();
        jBLabel5.setText("CATEGORY");
        jPanel4.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = jBLabel4 = new JBLabel();
        jBLabel4.setText("Name name name");
        jPanel4.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDownloadsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRating = ratesPanel = new RatesPanel();
        jPanel3.add((Component)ratesPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDownloads = jBLabel3 = new JBLabel();
        jBLabel3.setText("777 downloads");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(false);
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUpdated = jBLabel2 = new JBLabel();
        jBLabel2.setText("Updated: 11/12/13");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersion = jBLabel = new JBLabel();
        jBLabel.setText("v 1.2.3");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel5.setOpaque(false);
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

