/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.DialogAcceptanceResultEnum;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerMain {
    private PluginManagerMain() {
    }

    @Deprecated(since="2020.2", forRemoval=true)
    public static boolean downloadPlugins(@NotNull List<PluginNode> plugins2, @NotNull List<? extends IdeaPluginDescriptor> customPlugins, @Nullable Runnable onSuccess2, @NotNull PluginEnabler pluginEnabler, @Nullable Runnable cleanup) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(0);
        }
        if (customPlugins == null) {
            PluginManagerMain.$$$reportNull$$$0(1);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(2);
        }
        return PluginManagerMain.downloadPluginsAndCleanup(plugins2, ContainerUtil.filterIsInstance(customPlugins, PluginNode.class), onSuccess2, pluginEnabler, ModalityState.any(), cleanup);
    }

    public static boolean downloadPluginsAndCleanup(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins, @Nullable Runnable onSuccess2, @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull ModalityState modalityState, @Nullable Runnable cleanup) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(3);
        }
        if (customPlugins == null) {
            PluginManagerMain.$$$reportNull$$$0(4);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            PluginManagerMain.$$$reportNull$$$0(6);
        }
        return PluginManagerMain.downloadPlugins(plugins2, customPlugins, false, onSuccess2, pluginEnabler, modalityState, cleanup != null ? __ -> cleanup.run() : null);
    }

    @Deprecated
    public static boolean downloadPlugins(@NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins, boolean allowInstallWithoutRestart, @Nullable Runnable onSuccess2, @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @Nullable Consumer<? super Boolean> function) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(7);
        }
        if (customPlugins == null) {
            PluginManagerMain.$$$reportNull$$$0(8);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(9);
        }
        return PluginManagerMain.downloadPlugins(plugins2, customPlugins, allowInstallWithoutRestart, onSuccess2, pluginEnabler, ModalityState.any(), function);
    }

    public static boolean downloadPlugins(final @NotNull List<PluginNode> plugins2, final @NotNull Collection<PluginNode> customPlugins, final boolean allowInstallWithoutRestart, final @Nullable Runnable onSuccess2, final @NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, final @NotNull ModalityState modalityState, final @Nullable Consumer<? super Boolean> function) throws IOException {
        if (plugins2 == null) {
            PluginManagerMain.$$$reportNull$$$0(10);
        }
        if (customPlugins == null) {
            PluginManagerMain.$$$reportNull$$$0(11);
        }
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(12);
        }
        if (modalityState == null) {
            PluginManagerMain.$$$reportNull$$$0(13);
        }
        try {
            final boolean[] result2 = new boolean[1];
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, PluginManagerUISettings.getInstance()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator2) {
                    if (indicator2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        boolean success2;
                        PluginInstallOperation operation = new PluginInstallOperation((List<PluginNode>)plugins2, customPlugins, pluginEnabler, indicator2);
                        operation.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
                        operation.run();
                        result2[0] = success2 = operation.isSuccess();
                        if (success2) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (allowInstallWithoutRestart) {
                                    for (PendingDynamicPluginInstall install2 : operation.getPendingDynamicPluginInstalls()) {
                                        PluginInstaller.installAndLoadDynamicPlugin(install2.getFile(), install2.getPluginDescriptor());
                                    }
                                }
                                if (onSuccess2 != null) {
                                    onSuccess2.run();
                                }
                            }, modalityState);
                        }
                    }
                    finally {
                        if (function != null) {
                            ApplicationManager.getApplication().invokeLater(() -> function.accept(result2[0]), ModalityState.any());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$1", "run"));
                }
            });
            return result2[0];
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean suggestToEnableInstalledDependantPlugins(@NotNull com.intellij.ide.plugins.PluginEnabler pluginEnabler, @NotNull List<? extends IdeaPluginDescriptor> list2) {
        if (pluginEnabler == null) {
            PluginManagerMain.$$$reportNull$$$0(14);
        }
        if (list2 == null) {
            PluginManagerMain.$$$reportNull$$$0(15);
        }
        HashSet<Object> disabled = new HashSet<Object>();
        HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : list2) {
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (pluginEnabler.isDisabled(pluginId)) {
                disabled.add(ideaPluginDescriptor);
            }
            for (IdeaPluginDependency dependency : ideaPluginDescriptor.getDependencies()) {
                IdeaPluginDescriptor pluginDescriptor2;
                PluginId dependantId;
                if (dependency.isOptional() || PluginManagerCore.isModuleDependency(dependantId = dependency.getPluginId()) && PluginManagerCore.findPluginByModuleDependency(dependantId) == null || (pluginDescriptor2 = PluginManagerCore.getPlugin(dependantId)) == null || !pluginEnabler.isDisabled(dependantId)) continue;
                disabledDependants.add(pluginDescriptor2);
            }
        }
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            void var5_8;
            Object message2 = "";
            if (disabled.size() == 1) {
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part1", (Object[])new Object[]{((IdeaPluginDescriptor)disabled.iterator().next()).getName()});
            } else if (!disabled.isEmpty()) {
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part2", (Object[])new Object[]{StringUtil.join(disabled, pluginDescriptor -> pluginDescriptor.getName(), (String)", ")});
            }
            if (!disabledDependants.isEmpty()) {
                message2 = (String)message2 + "<br>";
                message2 = (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part3", (Object[])new Object[]{list2.size()});
                message2 = (String)message2 + " ";
                message2 = disabledDependants.size() == 1 ? (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part4", (Object[])new Object[]{((IdeaPluginDescriptor)disabledDependants.iterator().next()).getName()}) : (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part5", (Object[])new Object[]{StringUtil.join(disabledDependants, pluginDescriptor -> pluginDescriptor.getName(), (String)", ")});
            }
            message2 = (String)message2 + " ";
            message2 = (String)message2 + IdeBundle.message((String)(disabled.isEmpty() ? "plugin.manager.main.suggest.to.enable.message.part6" : "plugin.manager.main.suggest.to.enable.message.part7"), (Object[])new Object[0]);
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                int code = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message2)).yesText(IdeBundle.message((String)"button.enable.all", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.enable.updated.plugins", (Object[])new Object[]{disabled.size()}))).guessWindowAndAsk();
                if (code == 2) {
                    return false;
                }
                boolean bl = code == 0;
            } else {
                message2 = (String)message2 + "<br>";
                message2 = !disabled.isEmpty() ? (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part8", (Object[])new Object[]{disabled.size()}) : (String)message2 + IdeBundle.message((String)"plugin.manager.main.suggest.to.enable.message.part9", (Object[])new Object[]{disabledDependants.size()});
                message2 = (String)message2 + "?";
                boolean bl = MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)XmlStringUtil.wrapInHtml((CharSequence)message2)).guessWindowAndAsk();
                if (!bl) {
                    return false;
                }
            }
            if (var5_8 != false) {
                disabled.addAll(disabledDependants);
                pluginEnabler.enablePlugins(disabled);
            } else if (!disabled.isEmpty()) {
                pluginEnabler.enablePlugins(disabled);
            }
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void onEvent(String description) {
        switch (description) {
            case "disable": {
                PluginManagerCore.onEnable(false);
                break;
            }
            case "enable": {
                if (!PluginManagerCore.onEnable(true)) break;
                PluginManagerMain.notifyPluginsUpdated(null);
                break;
            }
            case "edit": {
                IdeFrame frame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                PluginManagerConfigurable.showPluginConfigurable(frame != null ? frame.getComponent() : null, null, List.of());
            }
        }
    }

    public static void notifyPluginsUpdated(@Nullable Project project) {
        ApplicationEx app2 = ApplicationManagerEx.getApplicationEx();
        String title2 = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String action2 = IdeBundle.message((String)"ide.restart.required.notification", (Object[])new Object[]{app2.isRestartCapable() ? 1 : 0});
        UpdateChecker.getNotificationGroup().createNotification(title2, NotificationType.INFORMATION).setDisplayId("plugins.updated.suggest.restart").addAction((AnAction)new NotificationAction(action2){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (PluginManagerConfigurable.showRestartDialog() == 0) {
                    notification.expire();
                    ApplicationManagerEx.getApplicationEx().restart(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerMain$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    public static boolean checkThirdPartyPluginsAllowed(@NotNull Iterable<? extends IdeaPluginDescriptor> descriptors) {
        UpdateSettings updateSettings;
        if (descriptors == null) {
            PluginManagerMain.$$$reportNull$$$0(16);
        }
        if ((updateSettings = UpdateSettings.getInstance()).isThirdPartyPluginsAllowed()) {
            PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.AUTO_ACCEPTED);
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            String noText;
            String yesText;
            if (PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)ideaPluginDescriptor)) continue;
            String title2 = IdeBundle.message((String)"third.party.plugins.privacy.note.title", (Object[])new Object[0]);
            String message2 = IdeBundle.message((String)"third.party.plugins.privacy.note.message", (Object[])new Object[0]);
            if (Messages.showYesNoDialog((String)message2, (String)title2, (String)(yesText = IdeBundle.message((String)"third.party.plugins.privacy.note.yes", (Object[])new Object[0])), (String)(noText = IdeBundle.message((String)"third.party.plugins.privacy.note.no", (Object[])new Object[0])), (Icon)Messages.getWarningIcon()) == 0) {
                updateSettings.setThirdPartyPluginsAllowed(true);
                PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.ACCEPTED);
                return true;
            }
            PluginManagerUsageCollector.thirdPartyAcceptanceCheck(DialogAcceptanceResultEnum.DECLINED);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadPluginsAndCleanup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToEnableInstalledDependantPlugins";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkThirdPartyPluginsAllowed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    public static interface PluginEnabler
    extends com.intellij.ide.plugins.PluginEnabler {
        @Override
        default public boolean isDisabled(@NotNull PluginId pluginId) {
            if (pluginId == null) {
                PluginEnabler.$$$reportNull$$$0(0);
            }
            return HEADLESS.isDisabled(pluginId);
        }

        @Override
        default public boolean enableById(@NotNull Set<PluginId> pluginIds2) {
            if (pluginIds2 == null) {
                PluginEnabler.$$$reportNull$$$0(1);
            }
            return HEADLESS.enableById(pluginIds2);
        }

        @Override
        default public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
            if (descriptors == null) {
                PluginEnabler.$$$reportNull$$$0(2);
            }
            return HEADLESS.enable(descriptors);
        }

        @Override
        default public boolean disableById(@NotNull Set<PluginId> pluginIds2) {
            if (pluginIds2 == null) {
                PluginEnabler.$$$reportNull$$$0(3);
            }
            return HEADLESS.disableById(pluginIds2);
        }

        @Override
        default public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
            if (descriptors == null) {
                PluginEnabler.$$$reportNull$$$0(4);
            }
            return HEADLESS.disable(descriptors);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginIds";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain$PluginEnabler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDisabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enableById";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "enable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disableById";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static final class HEADLESS
        implements PluginEnabler {
        }
    }

    public static class MyHyperlinkListener
    extends HyperlinkAdapter {
        protected void hyperlinkActivated(HyperlinkEvent e) {
            JEditorPane pane2 = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument doc = (HTMLDocument)pane2.getDocument();
                doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                URL url = e.getURL();
                if (url != null) {
                    BrowserUtil.browse((URL)url);
                }
            }
        }
    }
}

